/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.transaction;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.transaction.TransactionStateConstants;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSet;
import com.metamatrix.modeler.internal.core.transaction.SourcedNotificationImpl;
import com.metamatrix.modeler.internal.core.transaction.TxnNotificationFilter;
import com.metamatrix.modeler.internal.core.transaction.UndoableImpl;
import com.metamatrix.modeler.internal.core.transaction.UnitOfWorkProviderImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.ChangeNotifier;

public class UnitOfWorkImpl
implements UnitOfWork {
    private final TxnNotificationFilter filter;
    private final List resourcesChanged;
    private final List ignoredResources;
    private final Collection removedEObjects;
    private Object id;
    private int state;
    private CompoundCommand txnCommand;
    private Container container;
    private boolean significant;
    private boolean isUndoable;
    private String description;
    private Object source;

    public UnitOfWorkImpl(ResourceSet resources) {
        this(resources, Integer.MAX_VALUE);
    }

    public UnitOfWorkImpl(ResourceSet resources, int waitTimeouts) {
        if (resources == null) {
            String msg = ModelerCore.Util.getString("UnitOfWorkImpl.The_ResourceSet_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (!(resources instanceof EmfResourceSet)) {
            String msg = ModelerCore.Util.getString("UnitOfWorkImpl.The_supplied_ResourceSet_must_be_an_implementation_of_EmfResourceSet");
            throw new IllegalArgumentException(msg);
        }
        this.resourcesChanged = new ArrayList();
        this.ignoredResources = new ArrayList();
        this.removedEObjects = new HashSet();
        this.container = ((EmfResourceSet)((Object)resources)).getContainer();
        this.filter = new TxnNotificationFilter(resources);
        this.setState(-1);
        this.isUndoable = true;
    }

    public Collection getRemovedEObjects() {
        return new HashSet(this.removedEObjects);
    }

    public void begin() {
        if (this.isStarted()) {
            Assertion.failed(ModelerCore.Util.getString("UnitOfWorkImpl.Transaction_already_started_1"));
        }
        if (this.state != 4 && this.state != -1 && this.state != 5) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_begin", TransactionStateConstants.getDisplayValue(this.state)));
        }
        this.description = null;
        this.id = UnitOfWorkProviderImpl.getIdFactory().create();
        this.significant = true;
        this.isUndoable = true;
        this.filter.clear();
        this.resourcesChanged.clear();
        this.removedEObjects.clear();
        this.setState(1);
    }

    public Object getId() {
        return this.id;
    }

    public void processNotification(Notification notification) throws ModelerCoreException {
        boolean addedNotification;
        if (!this.isStarted() && !this.isRollingBack()) {
            int preState = this.getState();
            this.setState(5);
            throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_processing_notification", TransactionStateConstants.getDisplayValue(preState)));
        }
        Assertion.isNotNull(notification);
        if (ModelerCore.DEBUG_NOTIFICATIONS) {
            System.out.println("Processing " + notification + " in UnitOfWork");
        }
        Object changedObject = notification.getNotifier();
        int type = notification.getEventType();
        if (changedObject instanceof ResourceSet) {
            Object oldVal;
            if (type == 3 || type == 5) {
                Object newVal = notification.getNewValue();
                if (newVal instanceof Resource) {
                    this.resourcesChanged.remove(newVal);
                    this.ignoredResources.add(newVal);
                }
            } else if ((type == 4 || type == 6) && (oldVal = notification.getOldValue()) instanceof Resource) {
                this.resourcesChanged.remove(oldVal);
                this.ignoredResources.add(oldVal);
            }
        }
        if (addedNotification = this.filter.addNotification(notification)) {
            Resource changedResource;
            if (changedObject instanceof Resource) {
                if (notification.getOldValue() instanceof ResourceSet || notification.getNewValue() instanceof ResourceSet) {
                    this.resourcesChanged.remove(changedObject);
                    this.ignoredResources.add(changedObject);
                } else if (notification.getEventType() != 1 && !this.resourcesChanged.contains(changedObject) && !this.ignoredResources.contains(changedObject)) {
                    this.resourcesChanged.add(changedObject);
                }
            } else if (changedObject instanceof EObject && (changedResource = ((EObject)changedObject).eResource()) != null && !this.resourcesChanged.contains(changedResource) && !this.ignoredResources.contains(changedResource)) {
                this.resourcesChanged.add(changedResource);
            }
        }
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    /*
     * Loose catch block
     */
    public void commit() throws ModelerCoreException {
        block21: {
            boolean success;
            block20: {
                success = false;
                if (!this.isStarted() && !this.isRollingBack()) {
                    int preState = this.getState();
                    throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_commit", TransactionStateConstants.getDisplayValue(preState)));
                }
                this.setState(2);
                ArrayList<Resource> changedResourcesCopy = new ArrayList<Resource>(this.resourcesChanged.size());
                Iterator resourceIter = this.resourcesChanged.iterator();
                while (resourceIter.hasNext()) {
                    Resource changedResource = (Resource)resourceIter.next();
                    changedResourcesCopy.add(changedResource);
                    changedResource.setModified(true);
                }
                this.resourcesChanged.clear();
                if (this.txnCommand != null && this.isUndoable) {
                    UnitOfWorkProviderImpl uowp = (UnitOfWorkProviderImpl)this.container.getEmfTransactionProvider();
                    UndoableImpl undoable = new UndoableImpl(this.container, this.txnCommand, changedResourcesCopy, this.id, this.source);
                    undoable.setSignificant(this.significant);
                    if (this.description != null) {
                        undoable.setDescription(this.description);
                    }
                    this.txnCommand = null;
                    uowp.processUndoable(undoable);
                }
                success = true;
                Object var7_8 = null;
                if (!success) break block20;
                this.setState(4);
                try {
                    List notifications = this.filter.getSourcedNotifications(this.source);
                    if (ModelerCore.DEBUG_NOTIFICATIONS) {
                        this.helpPrintFilterResults(notifications, this.description);
                    }
                    if (notifications.isEmpty()) break block21;
                    ChangeNotifier notifier = this.container.getChangeNotifier();
                    try {
                        Iterator i2 = notifications.iterator();
                        while (i2.hasNext()) {
                            Notification n2 = (Notification)i2.next();
                            notifier.fireNotifyChanged(n2);
                        }
                        break block21;
                    }
                    catch (Throwable e1) {
                        ModelerCore.Util.log(4, e1, ModelerCore.Util.getString("UnitOfWorkImpl.Error_processing_notification_1"));
                    }
                }
                catch (Throwable e1) {
                    ModelerCore.Util.log(4, e1, ModelerCore.Util.getString("UnitOfWorkImpl.Error_processing_notifications____1") + e1.getMessage());
                }
                break block21;
            }
            this.setState(5);
            {
                break block21;
                catch (Throwable e2) {
                    success = false;
                    this.setState(5);
                    this.rollback();
                    throw new ModelerCoreException(e2, ModelerCore.Util.getString("UnitOfWorkImpl.Error_committing_transaction"));
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Object var7_9 = null;
                    if (success) {
                        this.setState(4);
                        try {
                            List notifications = this.filter.getSourcedNotifications(this.source);
                            if (ModelerCore.DEBUG_NOTIFICATIONS) {
                                this.helpPrintFilterResults(notifications, this.description);
                            }
                            if (notifications.isEmpty()) break block22;
                            ChangeNotifier notifier = this.container.getChangeNotifier();
                            try {
                                Iterator i2 = notifications.iterator();
                                while (i2.hasNext()) {
                                    Notification n2 = (Notification)i2.next();
                                    notifier.fireNotifyChanged(n2);
                                }
                            }
                            catch (Throwable e1) {
                                ModelerCore.Util.log(4, e1, ModelerCore.Util.getString("UnitOfWorkImpl.Error_processing_notification_1"));
                            }
                        }
                        catch (Throwable e1) {
                            ModelerCore.Util.log(4, e1, ModelerCore.Util.getString("UnitOfWorkImpl.Error_processing_notifications____1") + e1.getMessage());
                        }
                    } else {
                        this.setState(5);
                    }
                }
                this.filter.clear();
                this.cleanup();
                throw throwable;
            }
        }
        this.filter.clear();
        this.cleanup();
    }

    public void helpPrintFilterResults(List sns, String description) {
        if (sns == null || sns.isEmpty()) {
            return;
        }
        if (!StringUtil.isEmpty(description)) {
            System.out.println("\n" + description);
            System.out.println("TxnNotificationFilter result:");
        } else {
            System.out.println("\nTxnNotificationFilter result:");
        }
        Iterator i2 = sns.iterator();
        while (i2.hasNext()) {
            SourcedNotificationImpl sn = (SourcedNotificationImpl)i2.next();
            System.out.println(sn.getNotifier());
            System.out.println("   primary notification: " + sn.getPrimaryNotification());
            Iterator j2 = sn.getNotifications().iterator();
            while (j2.hasNext()) {
                Notification n2 = (Notification)j2.next();
                System.out.println("      notification: " + n2);
            }
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws ModelerCoreException {
        boolean success = false;
        try {
            if (!this.isStarted() && !this.isFailed()) {
                int preState = this.getState();
                throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_rollback", TransactionStateConstants.getDisplayValue(preState)));
            }
            this.setState(3);
            if (this.txnCommand != null && !this.txnCommand.isEmpty()) {
                CompoundCommand tmp = this.txnCommand;
                this.txnCommand = null;
                tmp.undo();
            }
            this.filter.clear();
            this.txnCommand = null;
            this.cleanup();
            success = true;
        }
        catch (Exception e2) {
            success = false;
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("UnitOfWorkImpl.Error_rolling_back_transaction"));
        }
        finally {
            if (success) {
                this.setState(4);
            } else {
                this.setState(5);
            }
        }
    }

    public boolean executeCommand(Command command) throws ModelerCoreException {
        if (!this.isStarted() && !this.isRollingBack()) {
            int preState = this.getState();
            this.setState(5);
            throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Transaction_must_be_started_before_you_can_execute_commands", TransactionStateConstants.getDisplayValue(preState)));
        }
        if (!command.canExecute()) {
            String msg = ModelerCore.Util.getString("UnitOfWorkImpl.Command_object_not_executable", command);
            if (ModelerCore.DEBUG) {
                ModelerCore.Util.log(4, msg);
            }
            command.dispose();
            throw new ModelerCoreException(msg);
        }
        if (this.txnCommand == null) {
            this.txnCommand = new CompoundCommand(command.getLabel());
        }
        this.txnCommand.append(command);
        try {
            command.execute();
        }
        catch (RuntimeException exception) {
            Object[] params = new Object[]{command, exception.getMessage()};
            String msg = ModelerCore.Util.getString("UnitOfWorkImpl.error_executing_command", params);
            command.dispose();
            throw new ModelerCoreException((Throwable)exception, msg);
        }
        this.updateRemovedEObjects(command);
        return true;
    }

    public boolean isStarted() {
        return this.getState() == 1;
    }

    public boolean isCommitting() {
        return this.getState() == 2;
    }

    public boolean isComplete() {
        return this.getState() == 4;
    }

    public boolean isRollingBack() {
        return this.getState() == 3;
    }

    public boolean isFailed() {
        return this.getState() == 5;
    }

    public boolean requiresStart() {
        switch (this.state) {
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public void setSignificant(boolean b2) throws ModelerCoreException {
        if (!this.isStarted()) {
            int preState = this.getState();
            throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_Unit_of_Work_State___May_only_set_isSignificant_on_started_Unit_of_Work_3", TransactionStateConstants.getDisplayValue(preState)));
        }
        this.significant = b2;
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    public void setUndoable(boolean b2) {
        this.isUndoable = b2;
    }

    public String toString() {
        if (this.description == null) {
            return this.getClass().getName() + " : " + TransactionStateConstants.getDisplayValue(this.getState());
        }
        return this.description + " : " + TransactionStateConstants.getDisplayValue(this.getState());
    }

    public int getState() {
        return this.state;
    }

    private void setState(int state) {
        this.state = state;
        if (ModelerCore.DEBUG_TRANSACTION) {
            switch (state) {
                case 5: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_FAILED_12"));
                    Thread.dumpStack();
                    break;
                }
                case 1: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_STARTED_13"));
                    break;
                }
                case 4: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_COMPLETE_14"));
                    break;
                }
                case 2: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_COMMITTING_15"));
                    break;
                }
                case 3: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_ROLLING_BACK_16"));
                    break;
                }
            }
        }
    }

    private void cleanup() {
        this.id = null;
        this.significant = true;
        this.isUndoable = true;
        this.source = null;
        this.removedEObjects.clear();
        this.resourcesChanged.clear();
        this.filter.clear();
        this.container.getEmfTransactionProvider().cleanup(Thread.currentThread());
    }

    private void updateRemovedEObjects(Command cmd) {
        if (cmd instanceof RemoveCommand) {
            EList ownerList;
            RemoveCommand remove = (RemoveCommand)cmd;
            Collection list = remove.getCollection();
            EStructuralFeature sf = remove.getFeature();
            if (sf != null && sf instanceof EReference) {
                EReference ref = (EReference)sf;
                if (ref.isContainment()) {
                    this.removedEObjects.addAll(list);
                } else if (ref.isContainer()) {
                    this.removedEObjects.addAll(list);
                }
            } else if (list != null && !list.isEmpty() && (ownerList = remove.getOwnerList()) instanceof EcoreEList) {
                EcoreEList eList = (EcoreEList)ownerList;
                EStructuralFeature listSf = eList.getEStructuralFeature();
                Iterator vals = list.iterator();
                while (vals.hasNext()) {
                    EReference ownerSf;
                    Object next = vals.next();
                    if (!(next instanceof EObject) || (ownerSf = ((EObject)next).eContainmentFeature()) != listSf || ownerSf == null) continue;
                    this.removedEObjects.add(next);
                }
            }
        } else if (cmd instanceof SetCommand) {
            SetCommand set = (SetCommand)cmd;
            EStructuralFeature sf = set.getFeature();
            if (sf instanceof EReference) {
                EReference ref = (EReference)sf;
                if (ref.isContainment() || ref.isContainer()) {
                    Object oldVal = set.getOldValue();
                    if (oldVal != null && set.getValue() == null) {
                        if (oldVal instanceof Collection) {
                            this.removedEObjects.addAll((Collection)oldVal);
                        } else if (oldVal instanceof EObject) {
                            this.removedEObjects.add(oldVal);
                        }
                    } else if (oldVal == null && set.getValue() != null) {
                        Object val = set.getValue();
                        if (val instanceof Collection) {
                            this.removedEObjects.removeAll((Collection)val);
                        } else if (val instanceof EObject) {
                            this.removedEObjects.remove(val);
                        }
                    }
                } else if (ref.isContainer()) {
                    Object oldVal = set.getOldValue();
                    if (oldVal != null && set.getValue() == null) {
                        this.removedEObjects.add(set.getOwner());
                    } else if (oldVal == null && set.getValue() != null) {
                        this.removedEObjects.remove(set.getOwner());
                    }
                }
            }
        } else if (cmd instanceof AddCommand) {
            this.removedEObjects.removeAll(((AddCommand)cmd).getCollection());
        }
    }
}

