/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.index.IQueryResult;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.search.runtime.ReferencesRecord;
import com.metamatrix.modeler.core.search.runtime.ResourceImportRecord;
import com.metamatrix.modeler.core.search.runtime.ResourceObjectRecord;
import com.metamatrix.modeler.core.search.runtime.ResourceRecord;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceSearchIndexSelector;
import com.metamatrix.modeler.internal.core.search.runtime.SearchRuntimeAdapter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ModelWorkspaceSearch {
    private static final IQueryResult[] EMTPY_QUERY_RESULT_ARRAY = new IQueryResult[0];
    private static final IEntryResult[] EMTPY_ENTRY_RESULT_ARRAY = new IEntryResult[0];
    private IndexSelector selector;
    private IProgressMonitor monitor;
    private int iIncrement = -1;
    private static final int NOMINAL_WORK = 100;
    private static final int START_UNITS = 10;

    public ModelWorkspaceSearch() {
    }

    public ModelWorkspaceSearch(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public IPath[] getResourcesContainingObjectId(ObjectID id) {
        return this.getResourcesContainingObjectId(((Object)id).toString());
    }

    public IPath[] getResourcesContainingObjectId(String id) {
        String prefix = IndexUtil.getPrefixPattern('C', id);
        IQueryResult[] results = this.queryPrefix(prefix);
        ObjectVector tmp = new ObjectVector(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IQueryResult result = results[i2];
            String resultPath = result.getPath();
            int beginIndex = resultPath.indexOf(47);
            if (beginIndex > 0) {
                resultPath = resultPath.substring(beginIndex);
            }
            Path path = new Path(resultPath);
            tmp.add(path);
        }
        Object[] paths = new IPath[tmp.size()];
        tmp.copyInto(paths);
        return paths;
    }

    public IPath[] getResourcesWithId(ObjectID id) {
        return this.getResourcesWithId(((Object)id).toString());
    }

    public IPath[] getResourcesWithId(String id) {
        String prefix = IndexUtil.getPrefixPattern('A', id);
        IEntryResult[] results = this.queryWithPrefix(prefix);
        ObjectVector tmp = new ObjectVector(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult result = results[i2];
            ResourceRecord record = (ResourceRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            tmp.add(new Path(record.getPath()));
        }
        Object[] paths = new IPath[tmp.size()];
        tmp.copyInto(paths);
        return paths;
    }

    public Collection getAllModelObjectRecords() {
        this.initMonitor();
        String prefix = IndexUtil.getPrefixPattern('C', null);
        IEntryResult[] results = null;
        results = this.monitor != null ? this.queryWithPrefix(prefix, this.monitor) : this.queryWithPrefix(prefix);
        HashSet<ResourceObjectRecord> objRecords = new HashSet<ResourceObjectRecord>(results.length);
        int iRecordCount = results.length;
        for (int i2 = 0; i2 < iRecordCount; ++i2) {
            IEntryResult result = results[i2];
            ResourceObjectRecord record = (ResourceObjectRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            objRecords.add(record);
            try {
                this.updateMonitor(i2, iRecordCount);
                continue;
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        return objRecords;
    }

    private void initMonitor() {
        if (this.monitor == null) {
            return;
        }
        this.monitor.beginTask(null, 100);
    }

    private void updateMonitor(int iCurrentIndex, int iTotalRecords) throws InterruptedException {
        if (this.monitor == null || iTotalRecords == 0) {
            return;
        }
        if (this.iIncrement == -1) {
            int iRemainingUnits = 90;
            this.iIncrement = iTotalRecords / iRemainingUnits;
            if (this.iIncrement == 0) {
                this.iIncrement = 1;
            }
        }
        if (iCurrentIndex % this.iIncrement == 0) {
            if (this.monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.monitor.worked(this.iIncrement);
        }
    }

    public Collection getModelsImportingResources(String folderOrFilePath) {
        String prefix = "B\u00a0" + folderOrFilePath.trim();
        IEntryResult[] results = this.queryWithPrefix(prefix);
        HashSet<ResourceImportRecord> refRecords = new HashSet<ResourceImportRecord>(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult result = results[i2];
            ResourceImportRecord record = (ResourceImportRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
        }
        return refRecords;
    }

    public Collection getResourcesImportedByModel(String folderOrFilePath) {
        String pattern = "B\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + folderOrFilePath.trim() + '\u00a0';
        IEntryResult[] results = this.queryWithPattern(pattern);
        HashSet<ResourceImportRecord> refRecords = new HashSet<ResourceImportRecord>(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult result = results[i2];
            ResourceImportRecord record = (ResourceImportRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
        }
        return refRecords;
    }

    public Collection getUniDirectionalReferencesTo(String id) {
        String prefix = "D\u00a0" + id.trim() + '\u00a0';
        IEntryResult[] results = this.queryWithPrefix(prefix);
        HashSet<ReferencesRecord> refRecords = new HashSet<ReferencesRecord>(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult result = results[i2];
            ReferencesRecord record = (ReferencesRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
        }
        return refRecords;
    }

    public Collection getUniDirectionalReferencesFrom(String id) {
        String pattern = "D\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + id.trim() + '\u00a0';
        IEntryResult[] results = this.queryWithPattern(pattern);
        HashSet<ReferencesRecord> refRecords = new HashSet<ReferencesRecord>(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult result = results[i2];
            ReferencesRecord record = (ReferencesRecord)SearchRuntimeAdapter.getSearchRecord(result.getWord());
            refRecords.add(record);
        }
        return refRecords;
    }

    public void setIndexSelector(IndexSelector indexSelector) {
        this.selector = indexSelector;
    }

    protected IndexSelector getIndexSelector() {
        return this.getIndexSelector(null);
    }

    protected IndexSelector getIndexSelector(IProgressMonitor monitor) {
        if (this.selector == null) {
            this.selector = new ModelWorkspaceSearchIndexSelector(monitor);
        }
        if (this.selector instanceof ModelWorkspaceSearchIndexSelector) {
            ((ModelWorkspaceSearchIndexSelector)this.selector).setMonitor(monitor);
        }
        return this.selector;
    }

    private IEntryResult[] queryWithPrefix(String prefix) {
        return this.queryWithPrefix(prefix, null);
    }

    private IEntryResult[] queryWithPrefix(String prefix, IProgressMonitor monitor) {
        try {
            Index[] indexes = null;
            indexes = monitor != null ? this.getIndexSelector(monitor).getIndexes() : this.getIndexSelector().getIndexes();
            return IndexUtil.queryIndex(monitor, indexes, prefix.toCharArray(), true, false);
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, e2.getMessage());
        }
        catch (IOException e3) {
            ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_index_files_from_selector_1"));
        }
        return EMTPY_ENTRY_RESULT_ARRAY;
    }

    private IEntryResult[] queryWithPattern(String pattern) {
        try {
            Index[] indexes = this.getIndexSelector().getIndexes();
            return IndexUtil.queryIndex(indexes, pattern.toCharArray(), false, false);
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, e2.getMessage());
        }
        catch (IOException e3) {
            ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_index_files_from_selector_1"));
        }
        return EMTPY_ENTRY_RESULT_ARRAY;
    }

    private IQueryResult[] queryPrefix(String prefix) {
        try {
            Index[] indexes = this.getIndexSelector().getIndexes();
            return this.queryPrefix(indexes, prefix.toCharArray());
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, e2.getMessage());
        }
        catch (IOException e3) {
            ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_index_files_from_selector_1"));
        }
        return EMTPY_QUERY_RESULT_ARRAY;
    }

    private IQueryResult[] queryPrefix(Index[] indexes, char[] prefix) throws ModelerCoreException {
        ObjectVector queryResult = new ObjectVector();
        try {
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                Object[] partialResult = indexes[i2].queryPrefix(prefix);
                if (partialResult == null || partialResult.length <= 0) continue;
                queryResult.addAll(partialResult);
            }
        }
        catch (IOException e2) {
            Object[] params = new Object[]{new String(prefix)};
            throw new ModelerCoreException((Throwable)e2, ModelerCore.Util.getString("ModelWorkspaceSearch.Error_trying_to_query_index_files_for_prefix_2", params));
        }
        Object[] result = new IQueryResult[queryResult.size()];
        queryResult.copyInto(result);
        return result;
    }
}

