/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.AssertionException;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSet;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class EmfResourceImpl
extends XMIResourceImpl
implements EmfResource {
    public static final char UUID_PROTOCOL_DELIMITER = '/';
    private final IDGenerator idGenerator = IDGenerator.getInstance();
    private Container container;
    private MetamodelRegistry registry;
    private String uriString;
    private ModelContents modelContents = new ModelContents(this);

    public EmfResourceImpl(URI uri) {
        super(uri);
        this.updateUriString();
    }

    public Container getContainer() {
        if (this.container == null) {
            ResourceSet resourceSet = this.resourceSet;
            if (resourceSet == null) {
                // empty if block
            }
            if (resourceSet instanceof EmfResourceSet) {
                this.container = ((EmfResourceSet)((Object)resourceSet)).getContainer();
                if (this.container == null) {
                    // empty if block
                }
            }
            if (this.container == null) {
                // empty if block
            }
        }
        return this.container;
    }

    public MetamodelRegistry getMetamodelRegistry() {
        if (this.registry == null) {
            Container emfContainer = this.getContainer();
            if (this.container != null) {
                this.registry = emfContainer.getMetamodelRegistry();
                if (this.registry == null) {
                    String msg = ModelerCore.Util.getString("EmfResourceImpl.The_MetamodelRegistry_reference_may_not_be_null_4");
                    throw new AssertionException(msg);
                }
            }
            if (this.registry == null) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EmfResourceImpl.The_MetamodelRegistry_reference_is_null_for__5") + this);
            }
        }
        return this.registry;
    }

    public EObject getEObject(Object key) {
        return null;
    }

    public List getNamespacePrefixToUris() {
        return null;
    }

    public ModelAnnotation getModelAnnotation() {
        if (this.modelContents != null) {
            return this.modelContents.getModelAnnotation();
        }
        return null;
    }

    public ModelContents getModelContents() {
        return this.modelContents;
    }

    protected void doUnload() {
        super.doUnload();
        this.modelContents = null;
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        this.modelContents = new ModelContents(this);
        super.doLoad(inputStream, options);
    }

    public void setURI(URI uri) {
        super.setURI(uri);
        this.updateUriString();
    }

    protected void updateUriString() {
        this.uriString = this.getURI() != null ? this.getURI().toString() : "";
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        this.container = null;
        this.registry = null;
        return super.basicSetResourceSet(resourceSet, notifications);
    }

    public String getDescription() {
        String description = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            description = this.getModelContents().getModelAnnotation().getDescription();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                description = header.getDescription();
            }
        }
        return description;
    }

    public ModelType getModelType() {
        ModelType type = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            type = this.getModelContents().getModelAnnotation().getModelType();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                type = ModelType.get(header.getModelType());
            }
        }
        return type;
    }

    public URI getPrimaryMetamodelUri() {
        URI metamodelUri = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            metamodelUri = URI.createURI(this.getModelContents().getModelAnnotation().getPrimaryMetamodelUri());
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                metamodelUri = URI.createURI(header.getPrimaryMetamodelURI());
            }
        }
        return metamodelUri;
    }

    public boolean isVisible() {
        boolean isVisible = true;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            isVisible = this.getModelContents().getModelAnnotation().isVisible();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                isVisible = header.isVisible();
            }
        }
        return isVisible;
    }

    public ObjectID getUuid() {
        ObjectID uuid = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            uuid = this.getModelContents().getModelAnnotation().getObjectId();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null && header.getUUID() != null) {
                uuid = this.getObjectIDFromString(header.getUUID());
            }
        }
        return uuid;
    }

    protected XMIHeader doGetXmiHeader() {
        File f2;
        XMIHeader header = null;
        if (this.getURI().isFile() && (f2 = new File(this.getURI().toFileString())).exists()) {
            header = ModelUtil.getXmiHeader(f2);
        }
        return header;
    }

    private ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }

    public String getURIFragment(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        ObjectID id = eObject.getObjectId();
        if (id != null) {
            return id.toString('/');
        }
        return super.getURIFragment(eObject);
    }

    public String getUriString() {
        return this.uriString;
    }

    public IDGenerator getIDGenerator() {
        return this.idGenerator;
    }
}

