/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.resource.EResourceImpl;
import com.metamatrix.modeler.internal.core.resource.EResourceSetImpl;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.xml.sax.Attributes;

public class EResourceXmiHandler
extends SAXXMIHandler {
    private static final String MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi";
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SimpleDateFormat("yyyy-MM-dd")};
    private final IDGenerator idGenerator;
    private final EResourceImpl eResource;
    private final Collection roots;
    private final Collection proxyResourceURIs;
    private final Collection modelImportsToConvert;
    private boolean isXsdResource;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$core$resource$EResourceImpl;
    static /* synthetic */ Class class$java$util$Date;

    public EResourceXmiHandler(XMIResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
        ArgCheck.isNotNull(xmiResource);
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$internal$core$resource$EResourceImpl == null ? (class$com$metamatrix$modeler$internal$core$resource$EResourceImpl = EResourceXmiHandler.class$("com.metamatrix.modeler.internal.core.resource.EResourceImpl")) : class$com$metamatrix$modeler$internal$core$resource$EResourceImpl, xmiResource);
        this.eResource = (EResourceImpl)xmiResource;
        this.idGenerator = IDGenerator.getInstance();
        this.roots = new ArrayList();
        this.proxyResourceURIs = new HashSet();
        this.modelImportsToConvert = new HashSet();
        this.isXsdResource = false;
    }

    public void startElement(String uri, String localName, String name) {
        super.startElement(uri, localName, name);
    }

    protected void createTopObject(String prefix, String name) {
        if (this.isXsdPrefix(prefix)) {
            this.isXsdResource = true;
        }
        super.createTopObject(prefix, name);
    }

    protected void processTopObject(EObject object) {
        super.processObject(object);
        this.roots.add(object);
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int size = this.attribs.getLength();
            for (int i2 = 0; i2 < size; ++i2) {
                String qName = this.attribs.getQName(i2);
                if (qName.equals("xmi:id")) {
                    this.xmlResource.setID(internalEObject, this.attribs.getValue(i2));
                    continue;
                }
                if (qName.equals("xmi:uuid")) {
                    ObjectID uuid = this.getObjectIDFromString(this.attribs.getValue(i2));
                    Assertion.isNotNull(uuid);
                    uuid = this.patch_defect14449(obj, uuid, i2);
                    obj.setObjectId(uuid);
                    this.eResource.addToEObjectCache(obj, false);
                    continue;
                }
                if (qName.equals("href")) {
                    String value = this.attribs.getValue(i2);
                    if (value.startsWith("#")) {
                        value = this.resourceURI.toString() + value;
                    }
                    this.handleProxy(internalEObject, value);
                    continue;
                }
                if (qName.startsWith("xmlns") || this.notFeatures.contains(qName)) continue;
                EStructuralFeature feature = obj.eClass().getEStructuralFeature(qName);
                if (feature != null && feature.isChangeable()) {
                    this.setAttribValue(obj, qName, this.attribs.getValue(i2));
                }
                if (!(obj instanceof EPackage) || !EcorePackage.eINSTANCE.getEPackage_NsURI().equals(feature)) continue;
                EPackage.Registry.INSTANCE.put(this.attribs.getValue(i2), obj);
            }
            this.patchA_modelImport(obj, this.attribs);
        }
    }

    protected void handleProxy(InternalEObject proxy, String uriLiteral) {
        EResourceSetImpl rs;
        super.handleProxy(proxy, uriLiteral);
        this.proxyResourceURIs.add(proxy.eProxyURI().trimFragment());
        URI physicalUri = null;
        if (this.eResource.getResourceSet() instanceof EResourceSetImpl && (rs = (EResourceSetImpl)this.eResource.getResourceSet()).getEObjectHrefConverter() != null) {
            physicalUri = rs.getEObjectHrefConverter().getPhysicalURI(proxy.eProxyURI());
        }
        if (physicalUri != null) {
            proxy.eSetProxyURI(physicalUri);
        }
    }

    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (this.isXsdResource || this.isXsdPrefix(object.eClass().getEPackage().getNsPrefix())) {
            this.setValue(object, feature, value, position);
            return;
        }
        if (feature instanceof EAttribute && value instanceof String && (class$java$util$Date == null ? (class$java$util$Date = EResourceXmiHandler.class$("java.util.Date")) : class$java$util$Date).equals(((EAttribute)feature).getEAttributeType().getInstanceClass())) {
            value = this.convertDateFormat((String)value);
        }
        super.setFeatureValue(object, feature, value, position);
    }

    protected EObject createObjectFromFactory(EFactory factory, String typeName) {
        EObject newObject = null;
        if (factory != null) {
            newObject = this.findEProxy();
            if (newObject == null) {
                newObject = this.helper.createObject(factory, typeName);
            }
            if (newObject != null) {
                if (this.disableNotify) {
                    newObject.eSetDeliver(false);
                }
                this.handleObjectAttribs(newObject);
                newObject = this.patch_defect12764(newObject, this.attribs);
            }
        }
        return newObject;
    }

    public void endDocument() {
        if (this.isXsdResource) {
            EList topObjects = this.xmlResource.getContents();
            Iterator iter = topObjects.iterator();
            while (iter.hasNext()) {
                this.updateSchema((EObject)iter.next());
            }
        }
        this.eResource.getContents().addAll(this.roots);
        this.patchB_modelImport();
        super.endDocument();
    }

    protected EObject findEProxy() {
        int size = this.attribs.getLength();
        for (int i2 = 0; i2 < size; ++i2) {
            String qName = this.attribs.getQName(i2);
            if (!qName.equals("xmi:uuid")) continue;
            ObjectID uuid = this.getObjectIDFromString(this.attribs.getValue(i2));
            Assertion.isNotNull(uuid);
            EObject eProxy = this.eResource.findInEProxyCache(uuid);
            if (eProxy != null) {
                this.eResource.removeFromEProxyCache(uuid);
                ((InternalEObject)eProxy).eSetProxyURI(null);
            }
            return eProxy;
        }
        return null;
    }

    protected ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }

    protected EObject patch_defect12764(EObject obj, Attributes attribs) {
        if (attribs != null) {
            int size = attribs.getLength();
            for (int i2 = 0; i2 < size; ++i2) {
                URI uri;
                String qName = attribs.getQName(i2);
                String value = attribs.getValue(i2);
                if (!qName.equals("href") || !"http://www.eclipse.org/emf/2002/Ecore".equals((uri = URI.createURI(value)).trimFragment().toString())) continue;
                EcorePackageImpl.init();
            }
        }
        return obj;
    }

    protected ObjectID patch_defect14449(EObject obj, ObjectID objUuid, int attribsIndex) {
        Assertion.assertTrue(attribsIndex >= 0 && attribsIndex < this.attribs.getLength());
        Assertion.assertTrue(this.attribs.getQName(attribsIndex).equals("xmi:uuid"));
        if (obj instanceof ModelImport) {
            ModelImport modelImport = (ModelImport)obj;
            String uuidString = this.attribs.getValue(attribsIndex);
            String uuidOfRefedModel = modelImport.getUuid();
            if (uuidOfRefedModel == null) {
                String uuidFeatureName = CorePackage.eINSTANCE.getModelImport_Uuid().getName();
                for (int k2 = attribsIndex + 1; k2 < this.attribs.getLength(); ++k2) {
                    String qName = this.attribs.getQName(k2);
                    if (!qName.equals(uuidFeatureName)) continue;
                    uuidOfRefedModel = this.attribs.getValue(k2);
                }
            }
            if (uuidString.equals(uuidOfRefedModel)) {
                return this.idGenerator.create();
            }
        }
        return objUuid;
    }

    protected EObject patchA_modelImport(EObject obj, Attributes attribs) {
        if (obj instanceof ModelImport && attribs != null) {
            int size = attribs.getLength();
            for (int i2 = 0; i2 < size; ++i2) {
                String qName = attribs.getQName(i2);
                String value = attribs.getValue(i2);
                if (!qName.equals("path")) continue;
                ((ModelImport)obj).setModelLocation(value);
                this.modelImportsToConvert.add(obj);
            }
        }
        return obj;
    }

    protected void patchB_modelImport() {
        URI deresolvedURI;
        boolean deresolve;
        String uriString;
        URI importURI;
        Iterator j2;
        String modelLocation;
        ModelImport modelImport;
        if (this.modelImportsToConvert.isEmpty()) {
            return;
        }
        URI eResourceURI = this.eResource.getURI();
        if (MANIFEST_MODEL_NAME.equals(eResourceURI.lastSegment())) {
            return;
        }
        this.removeBadProxyResourceUris(this.proxyResourceURIs);
        HashSet unconvertedImports = new HashSet(this.modelImportsToConvert);
        Iterator i2 = this.modelImportsToConvert.iterator();
        block0: while (i2.hasNext()) {
            modelImport = (ModelImport)i2.next();
            modelLocation = modelImport.getModelLocation().toLowerCase();
            j2 = this.proxyResourceURIs.iterator();
            while (j2.hasNext()) {
                importURI = (URI)j2.next();
                uriString = URI.decode(importURI.toString()).toLowerCase();
                if (uriString.startsWith("http") && !uriString.endsWith("xmi") || !uriString.endsWith(modelLocation)) continue;
                boolean bl = deresolve = eResourceURI != null && !eResourceURI.isRelative() && eResourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(eResourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setModelLocation(URI.decode(importURI.toString()));
                unconvertedImports.remove(modelImport);
                continue block0;
            }
        }
        i2 = unconvertedImports.iterator();
        block2: while (i2.hasNext()) {
            modelImport = (ModelImport)i2.next();
            modelLocation = this.removeProjectNameFromLocation(modelImport.getModelLocation()).toLowerCase();
            j2 = this.proxyResourceURIs.iterator();
            while (j2.hasNext()) {
                importURI = (URI)j2.next();
                uriString = URI.decode(importURI.toString()).toLowerCase();
                if (uriString.startsWith("http") && !uriString.endsWith("xmi") || !uriString.endsWith(modelLocation)) continue;
                boolean bl = deresolve = eResourceURI != null && !eResourceURI.isRelative() && eResourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(eResourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setModelLocation(URI.decode(importURI.toString()));
                i2.remove();
                continue block2;
            }
        }
        i2 = unconvertedImports.iterator();
        while (i2.hasNext()) {
            modelImport = (ModelImport)i2.next();
            modelImport.setModel(null);
        }
    }

    protected String removeProjectNameFromLocation(String location) {
        String newLocation = location;
        URI uri = URI.createURI(location);
        if (uri.segmentCount() > 1) {
            StringBuffer sb = new StringBuffer(location.length());
            String[] segments = uri.segments();
            for (int i2 = 1; i2 != segments.length; ++i2) {
                sb.append("/");
                sb.append(segments[i2]);
            }
            newLocation = sb.toString();
        }
        return newLocation;
    }

    protected void removeBadProxyResourceUris(Collection proxyResourceUris) {
        String uriString;
        URI uri;
        if (proxyResourceUris == null || proxyResourceUris.isEmpty()) {
            return;
        }
        ArrayList<URI> badUris = new ArrayList<URI>(proxyResourceUris.size());
        Iterator i2 = proxyResourceUris.iterator();
        while (i2.hasNext()) {
            uri = (URI)i2.next();
            uriString = uri.toString();
            if (uriString.charAt(0) != '/') continue;
            badUris.add(uri);
            i2.remove();
        }
        if (badUris.isEmpty()) {
            return;
        }
        i2 = proxyResourceUris.iterator();
        while (i2.hasNext()) {
            uri = (URI)i2.next();
            uriString = URI.decode(uri.toString()).toLowerCase();
            Iterator j2 = badUris.iterator();
            while (j2.hasNext()) {
                URI badUri = (URI)j2.next();
                String badUriString = URI.decode(badUri.toString()).toLowerCase();
                if (!uriString.endsWith(badUriString)) continue;
                j2.remove();
            }
        }
        if (!badUris.isEmpty()) {
            proxyResourceUris.addAll(badUris);
        }
    }

    protected void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        int kind = this.helper.getFeatureKind(feature);
        switch (kind) {
            case 1: 
            case 2: {
                EClassifier eMetaObject = feature.getEType();
                EDataType eDataType = (EDataType)eMetaObject;
                EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                if (kind == 2) {
                    BasicEList list = (BasicEList)object.eGet(feature);
                    if (position == -2) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)value, " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken();
                            list.addUnique(eFactory.createFromString(eDataType, token));
                        }
                        if (!list.isEmpty()) break;
                        list.clear();
                        break;
                    }
                    if (value == null) {
                        list.addUnique(null);
                        break;
                    }
                    list.addUnique(eFactory.createFromString(eDataType, (String)value));
                    break;
                }
                if (value == null) {
                    object.eSet(feature, null);
                    break;
                }
                object.eSet(feature, eFactory.createFromString(eDataType, (String)value));
                break;
            }
            case 3: 
            case 4: {
                BasicEList list = (BasicEList)object.eGet(feature);
                if (position == -1) {
                    list.addUnique(value);
                    break;
                }
                if (position == -2) {
                    list.clear();
                    break;
                }
                if (kind == 3) {
                    list.addUnique(position, value);
                    break;
                }
                list.move(position, value);
                break;
            }
            default: {
                object.eSet(feature, value);
            }
        }
    }

    protected boolean isXsdPrefix(String prefix) {
        return prefix.equalsIgnoreCase("xsd");
    }

    protected String convertDateFormat(String value) {
        Date valueAsDate = null;
        for (int i2 = 0; i2 < DATE_FORMATS.length; ++i2) {
            try {
                valueAsDate = DATE_FORMATS[i2].parse(value);
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        if (valueAsDate == null) {
            String msg = ModelerCore.Util.getString("EResourceXmiHandler.Error_parsing_date_string", value);
            ModelerCore.Util.log(4, msg);
            return value;
        }
        return DateUtil.getDateAsString(valueAsDate);
    }

    protected void updateSchema(EObject topObject) {
        String msg;
        Object[] args = new Object[]{};
        Class<?> xmlSchemaClass = topObject.getClass();
        ReflectionHelper helper = new ReflectionHelper(xmlSchemaClass);
        Method updateSchemaMethod = null;
        try {
            updateSchemaMethod = helper.findBestMethodOnTarget("update", args);
        }
        catch (SecurityException e2) {
            msg = ModelerCore.Util.getString("EResourceXmiHandler.Error_executing_XSD_update_method", xmlSchemaClass);
            ModelerCore.Util.log(4, e2, msg);
        }
        catch (NoSuchMethodException e3) {
            // empty catch block
        }
        if (updateSchemaMethod != null) {
            try {
                updateSchemaMethod.invoke((Object)topObject, args);
            }
            catch (Throwable t2) {
                msg = ModelerCore.Util.getString("EResourceXmiHandler.Error_executing_XSD_update_method", updateSchemaMethod);
                ModelerCore.Util.log(4, msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

