/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.resource;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.DuplicateResourceException;
import com.metamatrix.modeler.core.resource.EObjectHrefConverter;
import com.metamatrix.modeler.core.resource.EResource;
import com.metamatrix.modeler.core.resource.EResourceSet;
import com.metamatrix.modeler.internal.core.resource.BuiltInTypesHrefConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;

public class EResourceSetImpl
extends ResourceSetImpl
implements EResourceSet {
    private static final char SEGMENT_SEPARATOR = '/';
    private EObjectHrefConverter eObjectHrefConverter;
    private final List externalResourceSets = new ArrayList(7);
    private final IChangeNotifier changeNotifier = new ChangeNotifier();

    public EResourceSetImpl() {
        this.eAdapters().add(new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                EResourceSetImpl.this.getChangeNotifier().fireNotifyChanged(notification);
            }
        });
    }

    public Map getLoadOptions() {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>(super.getLoadOptions());
        if (options.get("DISABLE_NOTIFY") == null) {
            options.put("DISABLE_NOTIFY", Boolean.TRUE);
        }
        return options;
    }

    public Resource createResource(URI uri) {
        this.canCreateResource(uri);
        return super.createResource(uri);
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        Resource eResource = super.delegatedGetResource(uri, loadOnDemand);
        if (eResource == null) {
            ResourceSet[] eResourceSets = this.getExternalResourceSets();
            for (int i2 = 0; i2 < eResourceSets.length && (eResource = eResourceSets[i2].getResource(uri, false)) == null; ++i2) {
            }
        }
        return eResource;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource eResource = super.getResource(uri, loadOnDemand);
        if (eResource == null && uri.toString().charAt(0) == '/') {
            String relativePath = uri.toFileString();
            Iterator iter = this.getResources().iterator();
            while (iter.hasNext()) {
                Resource rsrc = (Resource)iter.next();
                String uriString = rsrc.getURI().toFileString();
                if (!uriString.endsWith(relativePath)) continue;
                return rsrc;
            }
        }
        return eResource;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        EObject eObject;
        URI physicalUri;
        File f2;
        URI eResourceURI = uri.trimFragment();
        if (eResourceURI.isFile() && !(f2 = new File(eResourceURI.toFileString())).exists()) {
            return null;
        }
        URI lookupUri = uri;
        if (this.getEObjectHrefConverter() != null && (physicalUri = this.getEObjectHrefConverter().getPhysicalURI(uri)) != null) {
            lookupUri = physicalUri;
        }
        if ((eObject = super.getEObject(lookupUri, loadOnDemand)) == null) {
            String msg = ModelerCore.Util.getString("EResourceSetImpl.Unresolved_proxy", lookupUri);
            ModelerCore.Util.log(2, msg);
        }
        return eObject;
    }

    public EObjectHrefConverter getEObjectHrefConverter() {
        if (this.eObjectHrefConverter == null) {
            this.eObjectHrefConverter = new BuiltInTypesHrefConverter(this);
        }
        return this.eObjectHrefConverter;
    }

    public void setEObjectHrefConverter(EObjectHrefConverter theConverter) {
        this.eObjectHrefConverter = theConverter;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void addExternalResourceSet(ResourceSet resourceSet, Map physicalToLogicalUri) {
        if (resourceSet != null && !this.externalResourceSets.contains(resourceSet)) {
            this.externalResourceSets.add(resourceSet);
            if (physicalToLogicalUri != null) {
                Iterator i2 = physicalToLogicalUri.entrySet().iterator();
                while (i2.hasNext()) {
                    Map.Entry entry = i2.next();
                    URI physicalURI = (URI)entry.getKey();
                    URI logicalURI = (URI)entry.getValue();
                    this.getURIConverter().getURIMap().put(logicalURI, physicalURI);
                }
            }
        }
    }

    public void addExternalResourceSet(ResourceSet resourceSet) {
        if (resourceSet != null && !this.externalResourceSets.contains(resourceSet)) {
            this.externalResourceSets.add(resourceSet);
        }
    }

    public ResourceSet[] getExternalResourceSets() {
        return this.externalResourceSets.toArray(new ResourceSet[this.externalResourceSets.size()]);
    }

    public IChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    protected void canCreateResource(URI uri) {
        this.checkForInvalidXmiVersion(uri);
        this.checkForDuplicateUuid(uri);
    }

    protected void checkForDuplicateUuid(URI uri) {
        XMIHeader header = this.doGetXMIHeader(uri);
        if (header != null && header.getUUID() != null) {
            String uuidString = header.getUUID();
            try {
                ObjectID uuid = IDGenerator.getInstance().stringToObject(uuidString);
                Iterator iter = this.getResources().iterator();
                while (iter.hasNext()) {
                    Resource rsrc = (Resource)iter.next();
                    if (!(rsrc instanceof EResource) || !uuid.equals(((EResource)rsrc).getUuid())) continue;
                    Object[] params = new Object[]{URI.decode(uri.toString()), URI.decode(rsrc.getURI().toString())};
                    String msg = ModelerCore.Util.getString("EResourceSetImpl.Duplicate_resource_UUID_encountered", params);
                    throw new DuplicateResourceException(rsrc, null, msg);
                }
            }
            catch (InvalidIDException e2) {
                ModelerCore.Util.log(e2);
            }
        }
    }

    protected void checkForInvalidXmiVersion(URI uri) {
        XMIHeader header = this.doGetXMIHeader(uri);
        if (header != null && header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
            Object[] params = new Object[]{uri};
            String msg = ModelerCore.Util.getString("EResourceSetImpl.Old_model_format_encountered", params);
            throw new MetaMatrixRuntimeException(msg);
        }
    }

    protected XMIHeader doGetXMIHeader(URI uri) {
        File f2;
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        if (normalizedURI.isFile() && (f2 = new File(normalizedURI.toFileString())).isFile() && f2.exists()) {
            try {
                return XMIHeaderReader.readHeader(f2);
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return null;
    }
}

