/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.refactor;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.refactor.ReferenceUpdator;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelImportReferenceUpdator
implements ReferenceUpdator {
    public void updateEObject(EObject eObject, Map oldToNewObjects) {
        ModelImport modelImport;
        ModelAnnotation newModel;
        ArgCheck.isNotNull(eObject);
        ArgCheck.isNotNull(oldToNewObjects);
        if (eObject instanceof ModelImport && (newModel = this.getNewResourceModelAnnotation(modelImport = (ModelImport)eObject, oldToNewObjects)) != null) {
            Resource newResource = newModel.eResource();
            String resourcePath = WorkspaceResourceFinderUtil.getWorkspaceUri(newResource);
            if (resourcePath == null) {
                return;
            }
            Resource eResource = eObject.eResource();
            URI resourceURI = eResource.getURI();
            URI importURI = newResource.getURI();
            String uriString = URI.decode(importURI.toString());
            if (importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                    uriString = URI.decode(importURI.toString());
                }
                modelImport.setModelLocation(uriString);
            } else {
                modelImport.setModelLocation(uriString);
            }
            modelImport.setName(this.getResourceName(newResource));
            modelImport.setModelType(newModel.getModelType());
            modelImport.setPrimaryMetamodelUri(newModel.getPrimaryMetamodelUri());
            ObjectID id = newModel.getObjectId();
            modelImport.setUuid(((Object)id).toString());
        }
    }

    private ModelAnnotation getNewResourceModelAnnotation(ModelImport modelImport, Map oldToNewObjects) {
        String primaryMetamodelUri = modelImport.getPrimaryMetamodelUri();
        String resourcePath = modelImport.getPath();
        ModelType modelType = modelImport.getModelType();
        Iterator keyIter = oldToNewObjects.keySet().iterator();
        while (keyIter.hasNext()) {
            Resource oldModelResource;
            String modelPath;
            Object keyObj = keyIter.next();
            if (!(keyObj instanceof ModelAnnotation)) continue;
            ModelAnnotation modelAnnotation = (ModelAnnotation)keyObj;
            if (primaryMetamodelUri != null && !primaryMetamodelUri.equals(modelAnnotation.getPrimaryMetamodelUri())) continue;
            if (modelType != null) {
                int oldType;
                int type = modelType.getValue();
                ModelType oldModelType = modelAnnotation.getModelType();
                if (oldModelType != null && type != (oldType = oldModelType.getValue())) continue;
            }
            if (resourcePath != null && !resourcePath.equals(modelPath = WorkspaceResourceFinderUtil.getWorkspaceUri(oldModelResource = modelAnnotation.eResource()))) continue;
            return (ModelAnnotation)oldToNewObjects.get(keyObj);
        }
        return null;
    }

    private String getResourceName(Resource resource) {
        int index;
        ArgCheck.isNotNull(resource);
        URI resourceUri = resource.getURI();
        String modelNameWithExt = resourceUri.lastSegment();
        String extension = resourceUri.fileExtension();
        if (extension != null && (index = modelNameWithExt.indexOf(extension)) > 1) {
            return modelNameWithExt.substring(0, index - 1);
        }
        return modelNameWithExt;
    }
}

