/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metamodel;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.core.extension.XClass;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.MetamodelRootClassDescriptor;
import com.metamatrix.modeler.core.Metamodels;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelAspect;
import com.metamatrix.modeler.internal.core.MetamodelDescriptorImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelContentProvider;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRootClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

public class MetamodelsImpl
implements Metamodels {
    private static final Comparator ECLASS_NAME_COMPARATOR = new EClassNameComparator();
    private static final Comparator METAMODEL_ROOT_CLASS_NAME_COMPARATOR = new MetamodelRootClassNameComparator();
    private static MetamodelRegistry registry = MetamodelsImpl.getMetamodelRegistry();
    private static Map uriMetaclassMap = new HashMap();
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$IItemLabelProvider;
    static /* synthetic */ Class class$org$eclipse$emf$ecore$EClass;

    public Collection getMetamodelDescriptors() {
        return registry.getMetamodelDescriptors();
    }

    public Collection getMetamodelURIs() {
        return MetamodelContentProvider.getMetamodelURIs();
    }

    public Collection getMetamodelNames() {
        return MetamodelContentProvider.getMetamodelNames();
    }

    public MetamodelDescriptor getMetamodelDescriptor(String metamodelURI) {
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MetamodelsImpl.The_metamodel_URI_string_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        if (metamodelURI.length() == 0) {
            String msg = ModelerCore.Util.getString("MetamodelsImpl.The_metamodel_URI_string_may_not_be_zero-length_2");
            throw new IllegalArgumentException(msg);
        }
        URI uri = registry.getURI(metamodelURI);
        return uri != null ? registry.getMetamodelDescriptor(uri) : null;
    }

    public URI getMetamodelURI(String metamodelName) {
        return MetamodelContentProvider.getMetamodelURI(metamodelName);
    }

    public String getMetamodelName(URI metamodelURI) {
        return MetamodelContentProvider.getMetamodelName(metamodelURI);
    }

    public List getMetamodelRootClasses(String stringifiedURI) {
        URI metamodelURI = MetamodelContentProvider.getURIFromString(stringifiedURI);
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MetamodelsImpl.No_metamodel_URI_exists", stringifiedURI);
            throw new IllegalArgumentException(msg);
        }
        return this.getMetamodelRootClasses(metamodelURI);
    }

    public List getRootClasses(String stringifiedURI) {
        URI metamodelURI = MetamodelContentProvider.getURIFromString(stringifiedURI);
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MetamodelsImpl.No_metamodel_URI_exists", stringifiedURI);
            throw new IllegalArgumentException(msg);
        }
        return this.getRootClasses(metamodelURI);
    }

    public String getMetaClassURI(EClass metaClass) {
        ArgCheck.isNotNull(metaClass);
        String metaClassURI = EcoreUtil.getURI(metaClass).toString();
        uriMetaclassMap.put(metaClassURI, metaClass);
        return metaClassURI;
    }

    public String getMetaClassLabel(EClass metaClass) {
        EFactory objectFactory;
        EObject instance;
        AdapterFactory factory = ModelerCore.getMetamodels().getEmfAdapterFactory();
        IItemLabelProvider provider = (IItemLabelProvider)((Object)factory.adapt(instance = (objectFactory = metaClass.getEPackage().getEFactoryInstance()).create(metaClass), (Object)(class$org$eclipse$emf$edit$provider$IItemLabelProvider == null ? (class$org$eclipse$emf$edit$provider$IItemLabelProvider = MetamodelsImpl.class$("org.eclipse.emf.edit.provider.IItemLabelProvider")) : class$org$eclipse$emf$edit$provider$IItemLabelProvider)));
        if (provider != null && provider instanceof ItemProviderAdapter) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)((Object)provider);
            try {
                String name = adapter.getString("_UI_" + metaClass.getName() + "_type");
                return name;
            }
            catch (MissingResourceException e2) {
                // empty catch block
            }
        }
        return metaClass.getName();
    }

    public EClass getMetamodelClass(String metaclassURI) {
        ArgCheck.isNotEmpty(metaclassURI);
        if (uriMetaclassMap.get(metaclassURI) == null) {
            try {
                Container container = ModelerCore.getModelContainer();
                URI theUri = URI.createURI(metaclassURI);
                EObject metaClass = container.getEObject(theUri, true);
                Assertion.isInstanceOf(metaClass, class$org$eclipse$emf$ecore$EClass == null ? (class$org$eclipse$emf$ecore$EClass = MetamodelsImpl.class$("org.eclipse.emf.ecore.EClass")) : class$org$eclipse$emf$ecore$EClass, (class$org$eclipse$emf$ecore$EClass == null ? (class$org$eclipse$emf$ecore$EClass = MetamodelsImpl.class$("org.eclipse.emf.ecore.EClass")) : class$org$eclipse$emf$ecore$EClass).getName());
                uriMetaclassMap.put(metaclassURI, metaClass);
                return (EClass)metaClass;
            }
            catch (CoreException e2) {
                ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("MetamodelsImpl.Error_trying_to_look_up_an_EClass_for_the_uri_{0}._1", metaclassURI));
            }
        }
        return (EClass)uriMetaclassMap.get(metaclassURI);
    }

    public EFactory getFactory(URI metamodelURI) {
        return MetamodelContentProvider.getFactory(metamodelURI);
    }

    public EFactory getFactory(String stringifiedURI) {
        URI metamodelURI = MetamodelContentProvider.getURIFromString(stringifiedURI);
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MetamodelsImpl.No_metamodel_URI_exists", stringifiedURI);
            throw new IllegalArgumentException(msg);
        }
        return MetamodelContentProvider.getFactory(metamodelURI);
    }

    public List getReferencedClasses(EClass metamodelClass) {
        return MetamodelContentProvider.getReferencedClasses(metamodelClass);
    }

    public List getUniDirectionalReferences(EClass metamodelClass) {
        return MetamodelContentProvider.getUniDirectionalReferences(metamodelClass);
    }

    public List getContainedClasses(EClass metamodelClass) {
        return MetamodelContentProvider.getContainedClasses(metamodelClass);
    }

    public List getAttributes(EClass metamodelClass) {
        return MetamodelContentProvider.getAttributes(metamodelClass);
    }

    public MetamodelAspect getMetamodelAspect(EClass metamodelClass, String id) {
        return MetamodelContentProvider.getMetamodelAspect(metamodelClass, id);
    }

    public Collection getMetamodelAspects(EClass metamodelClass) {
        return MetamodelContentProvider.getMetamodelAspects(metamodelClass);
    }

    public MetamodelAspect getMetamodelAspect(EObject modelEntity, String id) {
        EClass metamodelClass = this.getMetamodelClass(modelEntity);
        if (metamodelClass != null) {
            return this.getMetamodelAspect(metamodelClass, id);
        }
        return null;
    }

    public Collection getMetamodelAspects(EObject modelEntity) {
        EClass metamodelClass = this.getMetamodelClass(modelEntity);
        if (metamodelClass != null) {
            return this.getMetamodelAspects(metamodelClass);
        }
        return null;
    }

    public AdapterFactory getEmfAdapterFactory() {
        return MetamodelContentProvider.getEmfAdapterFactory();
    }

    public void shutdown() throws CoreException {
    }

    public List getRootClasses(URI metamodelURI) {
        List rootClasses = this.getMetamodelRootClasses(metamodelURI);
        ArrayList<EClass> result = new ArrayList<EClass>(rootClasses.size());
        Iterator iter = rootClasses.iterator();
        while (iter.hasNext()) {
            Object rootClass = iter.next();
            if (rootClass instanceof MetamodelRootClass) {
                result.add(((MetamodelRootClass)rootClass).getEClass());
                continue;
            }
            if (!(rootClass instanceof EClass)) continue;
            result.add((EClass)rootClass);
        }
        return result;
    }

    public List getMetamodelRootClasses(URI metamodelURI) {
        if (registry.containsURI(metamodelURI)) {
            List rootEClasses = MetamodelContentProvider.getRootClasses(metamodelURI);
            MetamodelDescriptorImpl descriptor = (MetamodelDescriptorImpl)registry.getMetamodelDescriptor(metamodelURI);
            MetamodelRootClassDescriptor[] rootClasses = descriptor.getRootClassDescriptors();
            if (rootClasses != null && rootClasses.length > 0) {
                EClass eClass;
                ArrayList<EClass> allEClasses = new ArrayList<EClass>();
                Iterator iter = MetamodelContentProvider.getAllContents(metamodelURI);
                while (iter.hasNext()) {
                    EObject eObject = (EObject)iter.next();
                    if (!(eObject instanceof EClass) || allEClasses.contains(eClass = (EClass)eObject) || eClass.isAbstract() || eClass.isInterface()) continue;
                    allEClasses.add(eClass);
                }
                HashMap<EClass, MetamodelRootClass> result = new HashMap<EClass, MetamodelRootClass>(rootClasses.length);
                Iterator iter2 = allEClasses.iterator();
                block1: while (iter2.hasNext()) {
                    eClass = (EClass)iter2.next();
                    for (int i2 = 0; i2 < rootClasses.length; ++i2) {
                        Class<?> eClassClass = eClass.getClass();
                        Class eClassInstanceClass = eClass.getInstanceClass();
                        Class rootClass = rootClasses[i2].getExtensionClass();
                        int maxOccurs = rootClasses[i2].getMaxOccurs();
                        if (eClassClass.equals(rootClass) && !result.containsKey(eClass)) {
                            result.put(eClass, new MetamodelRootClass(eClass, maxOccurs));
                            continue block1;
                        }
                        if (eClassInstanceClass == null || !eClassInstanceClass.equals(rootClass) || result.containsKey(eClass)) continue;
                        result.put(eClass, new MetamodelRootClass(eClass, maxOccurs));
                        continue block1;
                    }
                }
                ArrayList listResult = new ArrayList(result.values());
                Collections.sort(listResult, METAMODEL_ROOT_CLASS_NAME_COMPARATOR);
                return listResult;
            }
            Collections.sort(rootEClasses, ECLASS_NAME_COMPARATOR);
            return rootEClasses;
        }
        return Collections.EMPTY_LIST;
    }

    private EClass getMetamodelClass(EObject modelEntity) {
        boolean classExtension = modelEntity instanceof XClass;
        if (!classExtension && modelEntity instanceof EClass) {
            return (EClass)modelEntity;
        }
        EClassImpl eClass = (EClassImpl)modelEntity.eClass();
        Resource resource = eClass.eResource();
        URI uri = resource.getURI();
        if (registry.containsURI(uri)) {
            EFactory eFactory = this.getFactory(uri);
            EPackage ePackage = eFactory.getEPackage();
            return (EClass)ePackage.getEClassifier(eClass.getName());
        }
        return null;
    }

    private static MetamodelRegistry getMetamodelRegistry() {
        MetamodelRegistry registry = null;
        try {
            registry = ModelerCore.getMetamodelRegistry();
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("MetamodelContentProvider.Error_obtaining_the_MetamodelRegistry_instance_from_MetabaseToolKitPlugin_35"));
        }
        if (registry == null) {
            String msg = ModelerCore.Util.getString("MetamodelContentProvider.The_MetamodelRegistry_reference_may_not_be_null_36");
            throw new IllegalArgumentException(msg);
        }
        return registry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MetamodelRootClassNameComparator
    implements Comparator {
        private MetamodelRootClassNameComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            MetamodelRootClass rootClass1 = (MetamodelRootClass)obj1;
            MetamodelRootClass rootClass2 = (MetamodelRootClass)obj2;
            EClass eClass1 = rootClass1.getEClass();
            EClass eClass2 = rootClass2.getEClass();
            String value1 = eClass1.getName();
            String value2 = eClass2.getName();
            return value1.compareToIgnoreCase(value2);
        }
    }

    private static class EClassNameComparator
    implements Comparator {
        private EClassNameComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            EClass eClass1 = (EClass)obj1;
            EClass eClass2 = (EClass)obj2;
            String value1 = eClass1.getName();
            String value2 = eClass2.getName();
            return value1.compareToIgnoreCase(value2);
        }
    }
}

