/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metamodel;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.internal.core.MetamodelDescriptorImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelResourceSetImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class MetamodelRegistryImpl
implements MetamodelRegistry {
    private final ResourceSet resources = new MetamodelResourceSetImpl(this);
    private final Map normalizedURIToDescriptor = new HashMap();
    private final Map uriByString = new HashMap();
    private final List uris = new ArrayList();

    public synchronized Object register(MetamodelDescriptor descriptor) throws ModelerCoreException {
        if (descriptor == null) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_MetamodelDescriptor_reference_may_not_be_null_1");
            throw new IllegalArgumentException(msg);
        }
        URI logicalURI = this.getLogicalURI(descriptor);
        URI normalizedURI = this.normalizeURI(logicalURI);
        if (this.normalizedURIToDescriptor.get(normalizedURI) != null) {
            if (ModelerCore.DEBUG_METAMODEL) {
                String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.>>_Returning_reference_to_existing_registered_metamodel", new Object[]{descriptor.getName(), logicalURI});
                ModelerCore.Util.log(1, msg);
            }
            return logicalURI;
        }
        this.addURIMapping((MetamodelDescriptorImpl)descriptor);
        normalizedURI = this.normalizeURI(logicalURI);
        this.normalizedURIToDescriptor.put(normalizedURI, descriptor);
        this.uris.add(logicalURI);
        Resource resource = this.getResourceSet().createResource(normalizedURI);
        if (resource == null) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_Resource_instance_may_not_be_null_3");
            throw new IllegalArgumentException(msg);
        }
        if (ModelerCore.DEBUG_METAMODEL) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.>>_Registered_metamodel_with_URI", new Object[]{descriptor.getName(), logicalURI});
            ModelerCore.Util.log(1, msg);
        }
        return logicalURI;
    }

    private URI getLogicalURI(MetamodelDescriptor descriptor) {
        return this.createURI(descriptor.getURI());
    }

    public synchronized void unregister(Object metamodelURI) {
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        this.unsetEFactory(normalizedURI);
        this.unload(normalizedURI);
        Resource resource = this.getResource(normalizedURI);
        if (resource != null) {
            this.getResourceSet().getResources().remove(resource);
        }
        if (this.normalizedURIToDescriptor.containsKey(normalizedURI)) {
            MetamodelDescriptor descriptor = (MetamodelDescriptor)this.normalizedURIToDescriptor.get(normalizedURI);
            this.normalizedURIToDescriptor.remove(normalizedURI);
            this.uris.remove(this.getLogicalURI(descriptor));
        }
    }

    public URI getURI(String uriString) {
        return (URI)this.uriByString.get(uriString);
    }

    public Collection getURIs() {
        return Collections.unmodifiableCollection(this.uris);
    }

    public boolean containsURI(Object metamodelURI) {
        boolean resourceSetResult;
        if (metamodelURI instanceof String) {
            return this.uriByString.get(metamodelURI) != null;
        }
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        boolean descriptorsResult = this.normalizedURIToDescriptor.containsKey(normalizedURI);
        boolean bl = resourceSetResult = this.getResourceSet().getResource(normalizedURI, false) != null;
        if (descriptorsResult != resourceSetResult) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_contents_of_the_ResourceSet_are_inconsistent_10");
            throw new IllegalArgumentException(msg);
        }
        return descriptorsResult;
    }

    public Collection getMetamodelDescriptors() {
        return Collections.unmodifiableCollection(this.normalizedURIToDescriptor.values());
    }

    public MetamodelDescriptor getMetamodelDescriptor(Object metamodelURI) {
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        return (MetamodelDescriptor)this.normalizedURIToDescriptor.get(normalizedURI);
    }

    public synchronized void setEFactory(Object metamodelURI, EFactory eFactory) {
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        String normalizedURIString = normalizedURI.toString();
        if (eFactory == null) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_EFactory_reference_may_not_be_null_11");
            throw new IllegalArgumentException(msg);
        }
        EPackage ePackage = (EPackage)EPackage.Registry.INSTANCE.get(normalizedURIString);
        if (ePackage == null) {
            ePackage = (EPackage)EPackage.Registry.INSTANCE.get(metamodelURI);
        }
        if (ePackage != null) {
            ePackage.setEFactoryInstance(null);
            ePackage.setEFactoryInstance(eFactory);
            if (ModelerCore.DEBUG_METAMODEL) {
                String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.>>_Registered_EFactory_with_URI", new Object[]{eFactory, normalizedURI});
                ModelerCore.Util.log(1, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource load(Object metamodelURI) throws ModelerCoreException {
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        if (!this.containsURI(metamodelURI)) {
            Object[] params = new Object[]{normalizedURI};
            throw new ModelerCoreException(ModelerCore.Util.getString("MetamodelRegistryImpl.A_resource_specified_by_the_URI_has_not_been_registered.", params));
        }
        Resource resource = this.getResource(normalizedURI);
        if (resource != null && !resource.isLoaded()) {
            Resource resource2 = resource;
            synchronized (resource2) {
                try {
                    Map options = resource.getResourceSet() != null ? resource.getResourceSet().getLoadOptions() : Collections.EMPTY_MAP;
                    resource.load(options);
                }
                catch (IOException e2) {
                    throw new ModelerCoreException(e2);
                }
                if (ModelerCore.DEBUG_METAMODEL) {
                    String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.>>_Loaded_Resource_with_URI", new Object[]{normalizedURI});
                    ModelerCore.Util.log(1, msg);
                }
            }
        }
        return resource;
    }

    public synchronized void loadAll() {
        Iterator iter = this.normalizedURIToDescriptor.entrySet().iterator();
        while (iter.hasNext()) {
            String msg;
            Object[] params;
            Map.Entry entry = iter.next();
            MetamodelDescriptor descriptor = (MetamodelDescriptor)entry.getValue();
            URI normalizedURI = (URI)entry.getKey();
            URI logicalURI = this.getLogicalURI(descriptor);
            try {
                this.load(normalizedURI);
                EPackage ePackage = (EPackage)EPackage.Registry.INSTANCE.get(normalizedURI.toString());
                if (ePackage == null) {
                    ePackage = (EPackage)EPackage.Registry.INSTANCE.get(logicalURI.toString());
                }
                if (ePackage == null) continue;
                EPackage.Registry.INSTANCE.put(logicalURI.toString(), ePackage);
                EPackage.Registry.INSTANCE.put(normalizedURI.toString(), ePackage);
                List alternateURIs = descriptor.getAlternateURIs();
                Iterator uriIter = alternateURIs.iterator();
                while (uriIter.hasNext()) {
                    EPackage.Registry.INSTANCE.put(uriIter.next(), ePackage);
                }
            }
            catch (ModelerCoreException e2) {
                params = new Object[]{normalizedURI};
                msg = ModelerCore.Util.getString("MetamodelRegistryImpl.Should_have_been_able_to_load_the_metamodel", params);
                ModelerCore.Util.log(4, e2, msg);
            }
            catch (Throwable e3) {
                params = new Object[]{normalizedURI};
                msg = ModelerCore.Util.getString("MetamodelRegistryImpl.Error_loading_the_metamodel", params);
                ModelerCore.Util.log(4, e3, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource unload(Object metamodelURI) {
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        Resource resource = this.getResource(normalizedURI);
        if (resource != null && resource.isLoaded()) {
            Resource resource2 = resource;
            synchronized (resource2) {
                resource.unload();
                if (ModelerCore.DEBUG_METAMODEL) {
                    String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.>>_Unloaded_Resource_with_URI", new Object[]{normalizedURI});
                    ModelerCore.Util.log(1, msg);
                }
            }
        }
        return resource;
    }

    public List getInstantiableObjects(Object metamodelURI) {
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        ArrayList<EObject> objs = new ArrayList<EObject>();
        Resource resource = this.getResource(normalizedURI);
        if (resource != null) {
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                if (!this.isInstantiable(eObj)) continue;
                objs.add(eObj);
            }
        }
        return objs;
    }

    public Resource getResource(Object metamodelURI) {
        URI normalizedURI = this.normalizeURI(this.assertURI(metamodelURI));
        return this.getResource(normalizedURI, false);
    }

    public ResourceSet getResourceSet() {
        return this.resources;
    }

    public void register(List resourceDescriptors) throws ModelerCoreException {
        if (this.resources instanceof MetamodelResourceSetImpl) {
            ((MetamodelResourceSetImpl)this.resources).register(resourceDescriptors);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(ModelerCore.Util.getString("MetamodelRegistryImpl.MetaModelRegistry_[_22"));
        Iterator iter = this.normalizedURIToDescriptor.values().iterator();
        while (iter.hasNext()) {
            sb.append(ModelerCore.Util.getString("MetamodelRegistryImpl.(_23"));
            sb.append(iter.next());
            sb.append(ModelerCore.Util.getString("MetamodelRegistryImpl.)_24"));
            if (!iter.hasNext()) continue;
            sb.append(ModelerCore.Util.getString("MetamodelRegistryImpl.,__25"));
        }
        sb.append(ModelerCore.Util.getString("MetamodelRegistryImpl.]_26"));
        return sb.toString();
    }

    private URI assertURI(Object metamodelURI) {
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_identifier_reference_may_not_be_null_27");
            throw new IllegalArgumentException(msg);
        }
        if (!(metamodelURI instanceof URI)) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_identifier_must_be_a_URI_instance_28");
            throw new IllegalArgumentException(msg);
        }
        return (URI)metamodelURI;
    }

    private URI createURI(String uriString) {
        if (uriString == null) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_URI_string_may_not_be_null_36");
            throw new IllegalArgumentException(msg);
        }
        if (uriString.length() == 0) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_URI_string_may_not_be_zero-length_1");
            throw new IllegalArgumentException(msg);
        }
        if (this.uriByString.containsKey(uriString)) {
            return (URI)this.uriByString.get(uriString);
        }
        File file = new File(uriString);
        if (file.exists()) {
            URI uri = URI.createFileURI(uriString);
            this.uriByString.put(uriString, uri);
            return uri;
        }
        URI uri = URI.createURI(uriString);
        this.uriByString.put(uriString, uri);
        return uri;
    }

    private void addURIMapping(MetamodelDescriptorImpl descriptor) {
        if (descriptor == null) {
            String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.The_MetamodelDescriptor_reference_may_not_be_null_29");
            throw new IllegalArgumentException(msg);
        }
        URI logicalURI = this.createURI(descriptor.getURI());
        String internalURI = descriptor.getInternalURI();
        String resourceURL = descriptor.getResourceURL();
        if (internalURI != null) {
            URI physicalURI = this.createURI(internalURI);
            this.getResourceSet().getURIConverter().getURIMap().put(logicalURI, physicalURI);
            Iterator it = descriptor.getAlternateURIs().iterator();
            while (it.hasNext()) {
                URI alternateURI = this.createURI((String)it.next());
                this.getResourceSet().getURIConverter().getURIMap().put(alternateURI, physicalURI);
            }
            if (ModelerCore.DEBUG_METAMODEL) {
                String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.>>_Added_URIMap_entry_with_logicalURI_,_internalURI", new Object[]{logicalURI, physicalURI});
                ModelerCore.Util.log(1, msg);
            }
            return;
        }
        if (resourceURL != null) {
            URI physicalURI = this.createURI(resourceURL);
            this.getResourceSet().getURIConverter().getURIMap().put(logicalURI, physicalURI);
            if (ModelerCore.DEBUG_METAMODEL) {
                String msg = ModelerCore.Util.getString("MetamodelRegistryImpl.>>_Added_URIMap_entry_with_logicalURI,_resourceURL", new Object[]{logicalURI, physicalURI});
                ModelerCore.Util.log(1, msg);
            }
            return;
        }
    }

    private boolean isInstantiable(EObject eObj) {
        EClass eClass;
        return eObj != null && eObj instanceof EClass && !(eClass = (EClass)eObj).isAbstract() && !eClass.isInterface();
    }

    private synchronized void unsetEFactory(URI uri) {
        Assertion.isNotNull(uri);
        EPackage ePackage = (EPackage)EPackage.Registry.INSTANCE.get(uri.toString());
        if (ePackage != null) {
            ePackage.setEFactoryInstance(null);
        }
    }

    private Resource getResource(URI uri, boolean demandLoad) {
        Assertion.isNotNull(uri);
        return this.resources.getResource(uri, demandLoad);
    }

    private URI normalizeURI(URI uri) {
        return this.getResourceSet().getURIConverter().normalize(uri);
    }
}

