/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metamodel;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.StringUtilities;
import com.metamatrix.metamodels.diagram.provider.DiagramItemProviderAdapterFactory;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.metamodel.Multiplicity;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelAspectFactory;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelEntity;
import com.metamatrix.modeler.internal.core.MetamodelDescriptorImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelEntityImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistryImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;

public class MetamodelContentProvider {
    private static final String ECORE_URI = "http://www.eclipse.org/emf/2002/Ecore";
    private static MetamodelRegistry registry = MetamodelContentProvider.getMetamodelRegistry();
    private static Map nameToURIMap;
    private static Map adapterFactoriesToURIMap;
    private static Map aspectFactoriesToURIMap;
    private static Map rootClassesMap;
    private static Map concreteClassesMap;
    private static Map abstractClassesMap;
    private static Map interfacesMap;
    private static Map metamodelEntityMap;
    private static Map multiplicityMap;
    private static Map classFeaturesMap;
    private static ComposedAdapterFactory composedAdapterFactory;
    static /* synthetic */ Class class$org$eclipse$emf$ecore$provider$EcoreItemProviderAdapterFactory;

    public static AdapterFactory getEmfAdapterFactory() {
        if (composedAdapterFactory == null) {
            ResourceItemProviderAdapterFactory factory = new ResourceItemProviderAdapterFactory();
            composedAdapterFactory = new ComposedAdapterFactoryWithMetamodelLoading(factory);
            composedAdapterFactory.addAdapterFactory(new DiagramItemProviderAdapterFactory());
            if (ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelContentProvider.DEBUG.Created_new_instance_of_ComposedAdapterFactory_1"));
                ModelerCore.Util.log(ModelerCore.Util.getString("MetamodelContentProvider.DEBUG.Added_to_ComposedAdapterFactory_the_instance_1", factory));
            }
        }
        Iterator iter = registry.getURIs().iterator();
        while (iter.hasNext()) {
            URI metamodelURI = (URI)iter.next();
            Resource resource = registry.getResource(metamodelURI);
            if (!resource.isLoaded() && !MetamodelContentProvider.isActivated(metamodelURI)) continue;
            MetamodelContentProvider.addAdapterFactory(metamodelURI);
        }
        return composedAdapterFactory;
    }

    public static boolean isActivated(URI metamodelURI) {
        MetamodelDescriptor descriptor = registry.getMetamodelDescriptor(metamodelURI);
        String pluginId = descriptor.getPluginID();
        if (pluginId != null) {
            try {
                IPluginRegistry pluginReg = Platform.getPluginRegistry();
                IPluginDescriptor pluginDesc = pluginReg.getPluginDescriptor(pluginId);
                return pluginDesc.isPluginActivated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static Resource getResource(URI metamodelURI) {
        return MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
    }

    public static URI getURIFromString(String stringifiedURI) {
        if (StringUtil.isEmpty(stringifiedURI)) {
            ArgCheck.isNotZeroLength(stringifiedURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_string_may_not_be_zero-length_2"));
        }
        return registry.getURI(stringifiedURI);
    }

    public static Collection getMetamodelNames() {
        return MetamodelContentProvider.getNameToURIMap().keySet();
    }

    public static Collection getMetamodelURIs() {
        return MetamodelContentProvider.getNameToURIMap().values();
    }

    public static Collection getMetamodelDescriptors() {
        return registry.getMetamodelDescriptors();
    }

    public static URI getMetamodelURI(String metamodelName) {
        if (metamodelName == null) {
            ArgCheck.isNotNull(metamodelName, ModelerCore.Util.getString("MetamodelContentProvider.The_metamodel_name_string_may_not_be_null_3"));
        }
        return (URI)MetamodelContentProvider.getNameToURIMap().get(metamodelName);
    }

    public static String getMetamodelName(URI metamodelURI) {
        MetamodelDescriptor descriptor;
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        return (descriptor = registry.getMetamodelDescriptor(metamodelURI)) != null ? descriptor.getName() : null;
    }

    public static Iterator getAllContents(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        Resource resource = MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
        return resource.getAllContents();
    }

    public static List getRootClasses(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        URI normalizedURI = MetamodelContentProvider.normalizeURI(metamodelURI);
        if (rootClassesMap == null || !rootClassesMap.containsKey(normalizedURI)) {
            Iterator iter2;
            EClass eClass;
            if (rootClassesMap == null) {
                rootClassesMap = new HashMap();
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
            List classes = MetamodelContentProvider.getAllConcreteClasses(metamodelURI);
            ArrayList<EClassifier> containedClasses = new ArrayList<EClassifier>();
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                eClass = (EClass)iter.next();
                EList containRefs = eClass.getEAllContainments();
                iter2 = containRefs.iterator();
                while (iter2.hasNext()) {
                    EReference eOpp;
                    EReference eRef = (EReference)iter2.next();
                    if (eRef.getLowerBound() > 0 && eRef.getEType() instanceof EClass) {
                        containedClasses.add(eRef.getEType());
                    }
                    if ((eOpp = eRef.getEOpposite()) == null || eOpp.getLowerBound() <= 0) continue;
                    containedClasses.add(eClass);
                }
            }
            iter = classes.iterator();
            while (iter.hasNext()) {
                eClass = (EClass)iter.next();
                EList superTypes = eClass.getESuperTypes();
                iter2 = superTypes.iterator();
                while (iter2.hasNext()) {
                    EClass superType = (EClass)iter2.next();
                    if (!containedClasses.contains(superType) || superType.isInterface()) continue;
                    containedClasses.add(eClass);
                }
            }
            classes.removeAll(containedClasses);
            rootClassesMap.put(normalizedURI, classes);
        }
        return (List)rootClassesMap.get(normalizedURI);
    }

    public static EFactory getFactory(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
        EPackage ePackage = (EPackage)EPackage.Registry.INSTANCE.get(metamodelURI.toString());
        if (ePackage == null) {
            ePackage = (EPackage)EPackage.Registry.INSTANCE.get(MetamodelContentProvider.normalizeURI(metamodelURI).toString());
        }
        return ePackage != null ? ePackage.getEFactoryInstance() : null;
    }

    public static List getAllConcreteClasses(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        URI normalizedURI = MetamodelContentProvider.normalizeURI(metamodelURI);
        if (concreteClassesMap == null || !concreteClassesMap.containsKey(normalizedURI)) {
            if (concreteClassesMap == null) {
                concreteClassesMap = new HashMap();
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
            ArrayList<EClass> classes = new ArrayList<EClass>();
            Resource resource = registry.getResource(metamodelURI);
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                EClass eClass;
                EObject eObj = (EObject)iter.next();
                if (!(eObj instanceof EClass) || classes.contains(eClass = (EClass)eObj) || eClass.isAbstract() || eClass.isInterface()) continue;
                classes.add(eClass);
            }
            concreteClassesMap.put(normalizedURI, classes);
        }
        return (List)concreteClassesMap.get(normalizedURI);
    }

    public static List getAllAbstractClasses(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        URI normalizedURI = MetamodelContentProvider.normalizeURI(metamodelURI);
        if (abstractClassesMap == null || !abstractClassesMap.containsKey(normalizedURI)) {
            if (abstractClassesMap == null) {
                abstractClassesMap = new HashMap();
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
            ArrayList<EClass> classes = new ArrayList<EClass>();
            Resource resource = registry.getResource(metamodelURI);
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                EClass eClass;
                EObject eObj = (EObject)iter.next();
                if (!(eObj instanceof EClass) || classes.contains(eClass = (EClass)eObj) || !eClass.isAbstract()) continue;
                classes.add(eClass);
            }
            abstractClassesMap.put(normalizedURI, classes);
        }
        return (List)abstractClassesMap.get(normalizedURI);
    }

    public static List getAllInterfaces(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        URI normalizedURI = MetamodelContentProvider.normalizeURI(metamodelURI);
        if (interfacesMap == null || !interfacesMap.containsKey(normalizedURI)) {
            if (interfacesMap == null) {
                interfacesMap = new HashMap();
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
            ArrayList<EClass> classes = new ArrayList<EClass>();
            Resource resource = registry.getResource(metamodelURI);
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                EClass eClass;
                EObject eObj = (EObject)iter.next();
                if (!(eObj instanceof EClass) || classes.contains(eClass = (EClass)eObj) || !eClass.isInterface()) continue;
                classes.add(eClass);
            }
            interfacesMap.put(normalizedURI, classes);
        }
        return (List)interfacesMap.get(normalizedURI);
    }

    public static List getReferencedClasses(EClass metamodelClass) {
        if (metamodelClass == null) {
            ArgCheck.isNotNull(metamodelClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        MetamodelContentProvider.ensureMetamodelEntityIsLoaded(metamodelClass);
        MetamodelEntity entity = (MetamodelEntity)metamodelEntityMap.get(metamodelClass);
        return entity != null ? entity.getReferencedClasses() : Collections.EMPTY_LIST;
    }

    public static List getUniDirectionalReferences(EClass metamodelClass) {
        if (metamodelClass == null) {
            ArgCheck.isNotNull(metamodelClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        MetamodelContentProvider.ensureMetamodelEntityIsLoaded(metamodelClass);
        MetamodelEntity entity = (MetamodelEntity)metamodelEntityMap.get(metamodelClass);
        return entity != null ? entity.getUniDirectionalReferences() : Collections.EMPTY_LIST;
    }

    public static List getContainedClasses(EClass metamodelClass) {
        if (metamodelClass == null) {
            ArgCheck.isNotNull(metamodelClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        MetamodelContentProvider.ensureMetamodelEntityIsLoaded(metamodelClass);
        MetamodelEntity entity = (MetamodelEntity)metamodelEntityMap.get(metamodelClass);
        return entity != null ? entity.getContainedClasses() : Collections.EMPTY_LIST;
    }

    public static List getAttributes(EClass metamodelClass) {
        if (metamodelClass == null) {
            ArgCheck.isNotNull(metamodelClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        MetamodelContentProvider.ensureMetamodelEntityIsLoaded(metamodelClass);
        MetamodelEntity entity = (MetamodelEntity)metamodelEntityMap.get(metamodelClass);
        return entity != null ? entity.getAttributes() : Collections.EMPTY_LIST;
    }

    public static MetamodelAspect getMetamodelAspect(EClass metamodelClass, String id) {
        boolean isSupportedAndLoaded;
        if (metamodelClass == null) {
            ArgCheck.isNotNull(metamodelClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        if (!(isSupportedAndLoaded = MetamodelContentProvider.ensureMetamodelEntityIsLoaded(metamodelClass))) {
            return null;
        }
        MetamodelEntity entity = (MetamodelEntity)metamodelEntityMap.get(metamodelClass);
        return entity != null ? entity.getMetamodelAspect(id) : null;
    }

    public static Collection getMetamodelAspects(EClass metamodelClass) {
        if (metamodelClass == null) {
            ArgCheck.isNotNull(metamodelClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        if (!MetamodelContentProvider.isSupportedMetamodel(metamodelClass)) {
            return null;
        }
        MetamodelContentProvider.ensureMetamodelEntityIsLoaded(metamodelClass);
        MetamodelEntity entity = (MetamodelEntity)metamodelEntityMap.get(metamodelClass);
        return entity != null ? entity.getMetamodelAspects() : null;
    }

    public static EStructuralFeature getStructuralFeature(EObject eObject, String name) {
        if (eObject == null) {
            ArgCheck.isNotNull(eObject, ModelerCore.Util.getString("MetamodelContentProvider.The_EObject_reference_may_not_be_null_22"));
        }
        if (name == null) {
            ArgCheck.isNotNull(name, ModelerCore.Util.getString("MetamodelContentProvider.The_structural_feature_name_may_not_be_null_23"));
        }
        EClass metamodelClass = MetamodelContentProvider.getEClass(eObject);
        return metamodelClass.getEStructuralFeature(name);
    }

    public static EStructuralFeature getStructuralFeature(EObject eObject, Method m2) {
        Map methodToFeaturesMap;
        if (eObject == null) {
            ArgCheck.isNotNull(eObject, ModelerCore.Util.getString("MetamodelContentProvider.The_EObject_reference_may_not_be_null_22"));
        }
        if (m2 == null) {
            ArgCheck.isNotNull(m2, ModelerCore.Util.getString("MetamodelContentProvider.The_Method_reference_may_not_be_null_25"));
        }
        EClass metamodelClass = MetamodelContentProvider.getEClass(eObject);
        if (classFeaturesMap == null || !classFeaturesMap.containsKey(metamodelClass)) {
            if (classFeaturesMap == null) {
                classFeaturesMap = new HashMap();
            }
            URI metamodelURI = metamodelClass.eResource().getURI();
            Object[] params = new Object[]{metamodelClass};
            if (metamodelURI == null) {
                Assertion.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_for_may_not_be_null_26", params));
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
            EList features = metamodelClass.getEAllStructuralFeatures();
            HashMap<Method, EStructuralFeature> methodsMap = new HashMap<Method, EStructuralFeature>();
            if (features != null) {
                Method[] methods = eObject.getClass().getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    Method method = methods[i2];
                    Iterator iter = features.iterator();
                    while (iter.hasNext()) {
                        EStructuralFeature feature = (EStructuralFeature)iter.next();
                        String featureName = StringUtilities.upperCaseFirstChar(feature.getName());
                        String getFeature = "get" + featureName;
                        String setFeature = "set" + featureName;
                        if (!method.getName().equals(getFeature) && !method.getName().equals(setFeature)) continue;
                        methodsMap.put(method, feature);
                    }
                }
            }
            classFeaturesMap.put(metamodelClass, methodsMap);
        }
        if ((methodToFeaturesMap = (Map)classFeaturesMap.get(metamodelClass)) != null) {
            return (EStructuralFeature)methodToFeaturesMap.get(m2);
        }
        return null;
    }

    public static Multiplicity getMultiplicity(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        if (multiplicityMap == null || !multiplicityMap.containsKey(feature)) {
            if (multiplicityMap == null) {
                multiplicityMap = new HashMap();
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(feature.getEContainingClass());
            int lowerBound = feature.getLowerBound();
            int upperBound = feature.getUpperBound();
            multiplicityMap.put(feature, Multiplicity.getInstance(lowerBound, upperBound));
        }
        return (Multiplicity)multiplicityMap.get(feature);
    }

    public static boolean isAttribute(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature != null && feature instanceof EAttribute;
    }

    public static boolean isReference(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature != null && feature instanceof EReference;
    }

    public static boolean isMultiValued(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature != null && feature.isMany();
    }

    public static boolean hasDefaultValue(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature != null && feature.getDefaultValue() != null;
    }

    public static boolean isModifiable(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature != null && feature.isChangeable();
    }

    public static boolean isRequired(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature != null && feature.isRequired();
    }

    public static EClassifier getType(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature.getEType();
    }

    public static Object getDefaultValue(EStructuralFeature feature) {
        if (feature == null) {
            ArgCheck.isNotNull(feature, ModelerCore.Util.getString("MetamodelContentProvider.The_EStructuralFeature_reference_may_not_be_null_27"));
        }
        return feature.getDefaultValue();
    }

    public static Collection getMetamodelAspectFactories(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        MetamodelDescriptorImpl descriptor = (MetamodelDescriptorImpl)registry.getMetamodelDescriptor(metamodelURI);
        URI normalizedURI = MetamodelContentProvider.normalizeURI(metamodelURI);
        if (aspectFactoriesToURIMap == null || !aspectFactoriesToURIMap.containsKey(normalizedURI)) {
            if (aspectFactoriesToURIMap == null) {
                aspectFactoriesToURIMap = new HashMap();
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
            String[] aspectIDs = ModelerCore.EXTENSION_POINT.METAMODEL_ASPECT.ASPECT_IDS;
            ArrayList<MetamodelAspectFactory> factories = new ArrayList<MetamodelAspectFactory>(aspectIDs.length);
            for (int i2 = 0; i2 < aspectIDs.length; ++i2) {
                String extPtId = aspectIDs[i2];
                MetamodelAspectFactory factory = descriptor.getMetamodelAspectFactoryClassInstance(extPtId);
                if (factory == null) continue;
                factories.add(factory);
            }
            aspectFactoriesToURIMap.put(normalizedURI, factories);
        }
        return (Collection)aspectFactoriesToURIMap.get(normalizedURI);
    }

    private static MetamodelRegistry getMetamodelRegistry() {
        MetamodelRegistry registry = null;
        try {
            registry = ModelerCore.getMetamodelRegistry();
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("MetamodelContentProvider.Error_obtaining_the_MetamodelRegistry_instance_from_the_MetabaseToolkitPlugin_38"));
        }
        if (registry == null) {
            Assertion.isNotNull(registry, ModelerCore.Util.getString("MetamodelContentProvider.The_MetamodelRegistry_reference_may_not_be_null_39"));
        }
        if (!(registry instanceof MetamodelRegistryImpl)) {
            Assertion.assertTrue(registry instanceof MetamodelRegistryImpl, ModelerCore.Util.getString("MetamodelContentProvider.MetamodelRegistry_must_be_a_MetamodelRegistryImpl_instance_40"));
        }
        return registry;
    }

    private static Map getNameToURIMap() {
        if (nameToURIMap == null) {
            int numMetamodels = registry.getMetamodelDescriptors().size();
            nameToURIMap = new HashMap(numMetamodels);
            Iterator iter = registry.getMetamodelDescriptors().iterator();
            while (iter.hasNext()) {
                MetamodelDescriptor descriptor = (MetamodelDescriptor)iter.next();
                String name = descriptor.getName();
                nameToURIMap.put(name, registry.getURI(descriptor.getURI()));
            }
        }
        return nameToURIMap;
    }

    private static URI normalizeURI(URI uri) {
        return registry.getResourceSet().getURIConverter().normalize(uri);
    }

    private static void addAdapterFactory(URI metamodelURI) {
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        URI normalizedURI = MetamodelContentProvider.normalizeURI(metamodelURI);
        if (adapterFactoriesToURIMap == null || !adapterFactoriesToURIMap.containsKey(normalizedURI)) {
            if (adapterFactoriesToURIMap == null) {
                adapterFactoriesToURIMap = new HashMap();
            }
            MetamodelDescriptorImpl descriptor = (MetamodelDescriptorImpl)registry.getMetamodelDescriptor(metamodelURI);
            MetamodelContentProvider.ensureMetamodelIsLoaded(metamodelURI);
            AdapterFactory factory = descriptor.getAdapterFactoryClassInstance();
            if (factory != null) {
                composedAdapterFactory.addAdapterFactory(factory);
                adapterFactoriesToURIMap.put(normalizedURI, factory);
                if (ModelerCore.DEBUG_METAMODEL) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("MetamodelContentProvider.DEBUG.Added_to_ComposedAdapterFactory_the_instance__4", factory));
                }
            }
        }
    }

    private static Resource ensureMetamodelIsLoaded(URI metamodelURI) {
        Resource resource;
        if (metamodelURI == null) {
            ArgCheck.isNotNull(metamodelURI, ModelerCore.Util.getString("MetamodelContentProvider.The_URI_reference_may_not_be_null_4"));
        }
        if (!registry.containsURI(metamodelURI)) {
            ArgCheck.isTrue(registry.containsURI(metamodelURI), ModelerCore.Util.getString("MetamodelContentProvider.A_metamodel_with_the_URI_does_not_exist_in_the_metamodel_registry_6", new Object[]{metamodelURI}));
        }
        if (!(resource = registry.getResource(metamodelURI)).isLoaded()) {
            try {
                registry.load(metamodelURI);
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(4, ModelerCore.Util.getString("MetamodelContentProvider.Error_loading_metamodel_with_URI", metamodelURI));
            }
        }
        return resource;
    }

    private static Resource ensureMetamodelIsLoaded(EClass eClass) {
        Resource resource;
        if (eClass == null) {
            ArgCheck.isNotNull(eClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        if ((resource = eClass.eResource()) == null) {
            Assertion.isNotNull(resource, ModelerCore.Util.getString("MetamodelContentProvider.The_Resource_reference_for_EClass_may_not_be_null_46", eClass.getName()));
        }
        if (ECORE_URI.equals(resource.getURI().toString())) {
            return resource;
        }
        return MetamodelContentProvider.ensureMetamodelIsLoaded(resource.getURI());
    }

    private static boolean ensureMetamodelEntityIsLoaded(EClass eClass) {
        if (eClass == null) {
            ArgCheck.isNotNull(eClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        if (!MetamodelContentProvider.isSupportedMetamodel(eClass)) {
            return false;
        }
        if (metamodelEntityMap == null || !metamodelEntityMap.containsKey(eClass)) {
            if (metamodelEntityMap == null) {
                metamodelEntityMap = new HashMap();
            }
            MetamodelContentProvider.ensureMetamodelIsLoaded(eClass);
            URI metamodelURI = eClass.eResource().getURI();
            if (metamodelURI != null && ECORE_URI.equals(metamodelURI.toString())) {
                return true;
            }
            metamodelEntityMap.put(eClass, MetamodelContentProvider.createMetamodelEntity(eClass));
        }
        return metamodelEntityMap.containsKey(eClass);
    }

    private static boolean isSupportedMetamodel(EClass eClass) {
        URI metamodelURI;
        Resource resource;
        if (eClass == null) {
            ArgCheck.isNotNull(eClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        return (resource = eClass.eResource()) != null && (metamodelURI = resource.getURI()) != null && registry.containsURI(metamodelURI);
    }

    private static EClass getEClass(EObject eObject) {
        if (eObject == null) {
            ArgCheck.isNotNull(eObject, ModelerCore.Util.getString("MetamodelContentProvider.The_EObject_reference_may_not_be_null_22"));
        }
        if (eObject instanceof EClass) {
            return (EClass)eObject;
        }
        EClass eClass = eObject.eClass();
        if (eClass == null) {
            ArgCheck.isNotNull(eClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        return eClass;
    }

    private static MetamodelEntityImpl createMetamodelEntity(EClass eClass) {
        if (eClass == null) {
            ArgCheck.isNotNull(eClass, ModelerCore.Util.getString("MetamodelContentProvider.The_EClass_reference_may_not_be_null_17"));
        }
        URI metamodelURI = eClass.eResource().getURI();
        MetamodelEntityImpl entity = new MetamodelEntityImpl(metamodelURI, eClass);
        Iterator iter = MetamodelContentProvider.getMetamodelAspectFactories(metamodelURI).iterator();
        while (iter.hasNext()) {
            MetamodelAspectFactory factory = (MetamodelAspectFactory)iter.next();
            try {
                MetamodelAspect aspect = factory.create(eClass, entity);
                if (aspect == null) continue;
                entity.addMetamodelAspect(aspect.getID(), aspect);
            }
            catch (IllegalArgumentException e2) {}
        }
        return entity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ComposedAdapterFactoryWithMetamodelLoading
    extends ComposedAdapterFactory {
        private static final String UML_ADAPTER_FACTORY_CLASS_NAME = "com.metamatrix.metamodels.uml2.provider.Uml2ItemProviderAdapterFactory";
        private EcoreItemProviderAdapterFactory ecoreAdapter;

        public ComposedAdapterFactoryWithMetamodelLoading(AdapterFactory delegateFactory) {
            super(delegateFactory);
        }

        public AdapterFactory getFactoryForTypes(Collection types) {
            AdapterFactory result = super.getFactoryForTypes(types);
            if (result != null) {
                return result;
            }
            HashSet<URI> processedUris = new HashSet<URI>();
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                EObject eObj;
                EClass eClass;
                Resource resource;
                URI uri;
                Object type = iter.next();
                if (!(type instanceof EObject) || !processedUris.contains(uri = (resource = (eClass = (eObj = (EObject)type).eClass()).eResource()).getURI())) continue;
                MetamodelContentProvider.ensureMetamodelIsLoaded(uri);
                processedUris.add(uri);
            }
            if (processedUris.size() != 0) {
                return super.getFactoryForTypes(types);
            }
            return null;
        }

        public Adapter adapt(Notifier target, Object type) {
            Adapter adapter = super.adapt(target, type);
            if (adapter == null && this.ecoreAdapter != null) {
                adapter = this.ecoreAdapter.adapt(target, type);
            }
            return adapter;
        }

        public void addAdapterFactory(AdapterFactory adapterFactory) {
            if (adapterFactory == null) {
                return;
            }
            AdapterFactory ecoreAdapterFactory = null;
            AdapterFactory umlAdapterFactory = null;
            Iterator iter = this.adapterFactories.iterator();
            while (iter.hasNext()) {
                AdapterFactory af2 = (AdapterFactory)iter.next();
                if (af2 != null && af2.getClass().equals(adapterFactory.getClass())) {
                    return;
                }
                if (UML_ADAPTER_FACTORY_CLASS_NAME.equals(af2.getClass().getName())) {
                    umlAdapterFactory = af2;
                    continue;
                }
                if (!af2.getClass().equals(class$org$eclipse$emf$ecore$provider$EcoreItemProviderAdapterFactory == null ? MetamodelContentProvider.class$("org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory") : class$org$eclipse$emf$ecore$provider$EcoreItemProviderAdapterFactory)) continue;
                ecoreAdapterFactory = af2;
            }
            super.addAdapterFactory(adapterFactory);
            if (umlAdapterFactory != null) {
                this.adapterFactories.remove(umlAdapterFactory);
                super.addAdapterFactory(umlAdapterFactory);
            }
            if (ecoreAdapterFactory != null) {
                this.adapterFactories.remove(ecoreAdapterFactory);
                super.addAdapterFactory(ecoreAdapterFactory);
                this.ecoreAdapter = (EcoreItemProviderAdapterFactory)ecoreAdapterFactory;
            }
        }
    }
}

