/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.metadata.runtime;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metadata.runtime.TransformationRecord;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTransformationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTransformationInfo;
import com.metamatrix.modeler.internal.core.metadata.runtime.AbstractMetadataRecord;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class TransformationRecordImpl
extends AbstractMetadataRecord
implements TransformationRecord {
    private String transformation;
    private Object transformedObjectID;
    private String transformationType;
    private List bindings;
    private List schemaPaths;
    private SqlTransformationInfo info;
    private boolean transformationInfoSet;
    private boolean transformedObjectIDSet;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlTransformationAspect;

    public TransformationRecordImpl(SqlAspect sqlAspect, EObject eObject, String type) {
        super(sqlAspect, eObject);
        this.setTransformationType(type);
    }

    private SqlTransformationAspect getTransformationAspect() {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlTransformationAspect == null ? (class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlTransformationAspect = TransformationRecordImpl.class$("com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTransformationAspect")) : class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlTransformationAspect, super.getSqlAspect());
        return (SqlTransformationAspect)super.getSqlAspect();
    }

    public TransformationRecordImpl() {
    }

    public String getTransformation() {
        if (this.eObject != null && !this.transformationInfoSet) {
            SqlTransformationInfo info = this.getTransformationInfo();
            return info != null ? info.getSqlTransform() : null;
        }
        return this.transformation;
    }

    public List getBindings() {
        if (this.eObject != null && !this.transformationInfoSet) {
            return this.getTransformationInfo().getBindings();
        }
        return this.bindings;
    }

    public List getSchemaPaths() {
        if (this.eObject != null && !this.transformationInfoSet) {
            return this.getTransformationInfo().getSchemaPaths();
        }
        return this.schemaPaths;
    }

    public String getTransformationType() {
        return this.transformationType;
    }

    public Object getTransformedObjectID() {
        if (this.eObject != null && !this.transformedObjectIDSet) {
            EObject transformedObj = (EObject)this.getTransformationAspect().getTransformedObject(this.eObject);
            this.setTransformedObjectID(this.getObjectID(transformedObj));
        }
        return this.transformedObjectID;
    }

    public String getType() {
        return this.getTransformTypeForRecordType(this.getRecordType());
    }

    public void setTransformation(String string) {
        this.transformation = string;
    }

    public void setTransformedObjectID(Object object) {
        this.transformedObjectID = object;
        this.transformedObjectIDSet = true;
    }

    public void setTransformationType(String string) {
        this.transformationType = string;
    }

    public void setBindings(List bindings) {
        this.bindings = bindings;
    }

    public void setSchemaPaths(List collection) {
        this.schemaPaths = collection;
    }

    private SqlTransformationInfo getTransformationInfo() {
        if (this.eObject != null) {
            this.info = this.getTransformationAspect().getTransformationInfo(this.eObject, null, this.getTransformationType());
        }
        return this.info;
    }

    protected String getTransformTypeForRecordType(char recordType) {
        switch (recordType) {
            case 'P': {
                return "Select";
            }
            case 'Q': {
                return "Insert";
            }
            case 'R': {
                return "Update";
            }
            case 'S': {
                return "Delete";
            }
            case 'T': {
                return "Procedure";
            }
            case 'U': {
                return "Mapping";
            }
        }
        throw new IllegalArgumentException(ModelerCore.Util.getString("ColumnSetRecordImpl.Invalid_record_type,_for_a_key_1", new Character(recordType)));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(ClassUtil.getSimpleClassName(this));
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(", nameInSource=");
        sb.append(this.getNameInSource());
        sb.append(", uuid=");
        sb.append(this.getUUID());
        sb.append(", pathInModel=");
        sb.append(this.getPath());
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

