/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class TargetLocationIndexSelector
extends AbstractIndexSelector {
    public static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private final String indexLocation;
    private Index[] indexes;

    public TargetLocationIndexSelector(String indexLocation) {
        ArgCheck.isNotNull(indexLocation);
        this.indexLocation = indexLocation;
    }

    public Index[] getIndexes() throws IOException {
        if (this.indexes == null) {
            File indexDir = new File(this.indexLocation);
            FilenameFilter fileFilter = this.getIndexFileFilter();
            File[] files = null;
            files = fileFilter != null ? indexDir.listFiles(fileFilter) : indexDir.listFiles();
            ObjectVector tmp = new ObjectVector();
            for (int i2 = 0; i2 < files.length; ++i2) {
                File indexFile = files[i2];
                if (!IndexUtil.indexFileExists(indexFile)) continue;
                tmp.add(new Index(indexFile.getAbsolutePath(), true));
            }
            this.indexes = new Index[tmp.size()];
            tmp.copyInto(this.indexes);
        }
        return this.indexes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("TargetLocationIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        try {
            indexes = this.getIndexes();
        }
        catch (IOException e2) {
            // empty catch block
        }
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i2].getIndexFile());
        }
        sb.append("]");
        return sb.toString();
    }

    protected void setIndexes(Index[] indexes) {
        this.indexes = indexes;
    }

    protected FilenameFilter getIndexFileFilter() {
        return null;
    }
}

