/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.builder.ModelBuildUtil;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.TargetLocationIndexSelector;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ModelWorkspaceSearchIndexSelector
extends TargetLocationIndexSelector {
    private static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private Collection resources = null;
    private IProgressMonitor monitor;
    private final boolean bCreatedWithResources;

    public ModelWorkspaceSearchIndexSelector() {
        super(IndexUtil.INDEX_PATH);
        this.bCreatedWithResources = false;
    }

    public ModelWorkspaceSearchIndexSelector(IProgressMonitor monitor) {
        super(IndexUtil.INDEX_PATH);
        this.monitor = monitor;
        this.bCreatedWithResources = false;
    }

    public ModelWorkspaceSearchIndexSelector(Collection resources) {
        super(IndexUtil.INDEX_PATH);
        this.resources = resources;
        this.bCreatedWithResources = true;
    }

    private boolean updateIndexes() {
        LinkedList<IResource> nonIndexedResources = null;
        try {
            if (this.resources == null) {
                nonIndexedResources = ModelWorkspaceManager.getModelWorkspaceManager().getNonIndexedResources(2);
            } else {
                nonIndexedResources = new LinkedList<IResource>();
                Iterator rscIter = this.resources.iterator();
                while (rscIter.hasNext()) {
                    ModelResource mResource;
                    if (this.monitor != null) {
                        this.monitor.worked(1);
                    }
                    if ((mResource = (ModelResource)rscIter.next()).getIndexType() == 3 || mResource.getIndexType() == 2) continue;
                    nonIndexedResources.add(mResource.getResource());
                }
            }
            if (nonIndexedResources != null && !nonIndexedResources.isEmpty()) {
                final ArrayList resourcesToIndex = new ArrayList(nonIndexedResources);
                TransactionRunnable runnable = new TransactionRunnable(){

                    public Object run(UnitOfWork uow) throws ModelerCoreException {
                        ModelBuildUtil.createSearchIndexes(ModelWorkspaceSearchIndexSelector.this.monitor, resourcesToIndex);
                        return null;
                    }
                };
                ModelerCore.getModelEditor().executeAsTransaction(runnable, "Updating ModelIndexes", false, false, (Object)this);
                return true;
            }
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelWorkspaceSearchIndexSelector.Error_trying_to_index_update_search_indexes___1") + e2.getMessage());
        }
        return false;
    }

    public Index[] getIndexes() throws IOException {
        boolean indexesUpdated = this.updateIndexes();
        if (!this.bCreatedWithResources && !indexesUpdated) {
            return super.getIndexes();
        }
        this.setIndexes(null);
        if (this.resources != null) {
            ObjectVector tmp = new ObjectVector();
            Iterator rscIter = this.resources.iterator();
            while (rscIter.hasNext()) {
                ModelResource mResource = (ModelResource)rscIter.next();
                String fileName = IndexUtil.getSearchIndexFileName(mResource);
                String path = IndexUtil.INDEX_PATH + fileName;
                if (!IndexUtil.indexFileExists(path)) continue;
                tmp.add(new Index(path, true));
            }
            Object[] result = new Index[tmp.size()];
            tmp.copyInto(result);
            super.setIndexes((Index[])result);
        }
        return super.getIndexes();
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ModelWorkspaceSearchIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        try {
            indexes = this.getIndexes();
        }
        catch (IOException e2) {
            // empty catch block
        }
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i2].getIndexFile());
        }
        sb.append("]");
        return sb.toString();
    }

    protected FilenameFilter getIndexFileFilter() {
        return IndexFilter.FILTER_INSTANCE;
    }

    public static class IndexFilter
    implements FilenameFilter {
        public static IndexFilter FILTER_INSTANCE = new IndexFilter();

        public boolean accept(File dir, String name) {
            Path path = new Path(name);
            String extension = path.getFileExtension();
            return extension != null && extension.equals("SEARCH_INDEX");
        }
    }
}

