/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.RuntimeIndexSelector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CompositeIndexSelector
extends AbstractIndexSelector {
    private List indexSelectors;

    public CompositeIndexSelector(List indexSelectors) {
        this.indexSelectors = indexSelectors;
    }

    public Index[] getIndexes() throws IOException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        Iterator selectIter = this.indexSelectors.iterator();
        while (selectIter.hasNext()) {
            IndexSelector indexSelector = (IndexSelector)selectIter.next();
            if (indexSelector == null) continue;
            for (int i2 = 0; i2 < indexSelector.getIndexes().length; ++i2) {
                indexes.add(indexSelector.getIndexes()[i2]);
            }
        }
        return indexes.toArray(new Index[0]);
    }

    public String[] getFilePaths() {
        ArrayList<String> paths = new ArrayList<String>();
        Iterator selectIter = this.indexSelectors.iterator();
        while (selectIter.hasNext()) {
            IndexSelector indexSelector = (IndexSelector)selectIter.next();
            if (indexSelector == null) continue;
            for (int i2 = 0; i2 < indexSelector.getFilePaths().length; ++i2) {
                paths.add(indexSelector.getFilePaths()[i2]);
            }
        }
        return paths.toArray(new String[0]);
    }

    public List getFileContentsAsString(List paths) {
        ArgCheck.isNotEmpty(paths);
        Iterator indexIter = this.indexSelectors.iterator();
        while (indexIter.hasNext()) {
            RuntimeIndexSelector runtimeSelector;
            List contents;
            IndexSelector selector = (IndexSelector)indexIter.next();
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContentsAsString(paths)).isEmpty()) continue;
            return contents;
        }
        return Collections.EMPTY_LIST;
    }

    public InputStream getFileContent(String path) {
        ArgCheck.isNotNull(path);
        Iterator indexIter = this.indexSelectors.iterator();
        while (indexIter.hasNext()) {
            RuntimeIndexSelector runtimeSelector;
            InputStream contents;
            IndexSelector selector = (IndexSelector)indexIter.next();
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContent(path)) == null) continue;
            return contents;
        }
        return null;
    }

    public File getFile(String path) {
        ArgCheck.isNotNull(path);
        Iterator indexIter = this.indexSelectors.iterator();
        while (indexIter.hasNext()) {
            RuntimeIndexSelector runtimeSelector;
            File file;
            IndexSelector selector = (IndexSelector)indexIter.next();
            if (!(selector instanceof RuntimeIndexSelector) || (file = (runtimeSelector = (RuntimeIndexSelector)selector).getFile(path)) == null) continue;
            return file;
        }
        return null;
    }

    public String getFileContentAsString(String path) {
        ArgCheck.isNotNull(path);
        Iterator indexIter = this.indexSelectors.iterator();
        while (indexIter.hasNext()) {
            RuntimeIndexSelector runtimeSelector;
            String contents;
            IndexSelector selector = (IndexSelector)indexIter.next();
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContentAsString(path)) == null) continue;
            return contents;
        }
        return null;
    }

    public long getFileSize(String path) {
        ArgCheck.isNotNull(path);
        Iterator indexIter = this.indexSelectors.iterator();
        while (indexIter.hasNext()) {
            RuntimeIndexSelector runtimeSelector;
            long length;
            IndexSelector selector = (IndexSelector)indexIter.next();
            if (!(selector instanceof RuntimeIndexSelector) || (length = (runtimeSelector = (RuntimeIndexSelector)selector).getFileSize(path)) == 0L) continue;
            return length;
        }
        return 0L;
    }

    public Collection getFileRecords(String filePath) {
        HashSet fileRecords = new HashSet();
        Iterator indexIter = this.indexSelectors.iterator();
        while (indexIter.hasNext()) {
            IndexSelector selector = (IndexSelector)indexIter.next();
            if (!(selector instanceof RuntimeIndexSelector)) continue;
            RuntimeIndexSelector runtimeSelector = (RuntimeIndexSelector)selector;
            fileRecords.addAll(runtimeSelector.getFileRecords(filePath));
        }
        return fileRecords;
    }

    public InputStream getFileContent(String path, String[] tokens, String[] tokenReplacements) {
        ArgCheck.isNotNull(path);
        Iterator indexIter = this.indexSelectors.iterator();
        while (indexIter.hasNext()) {
            RuntimeIndexSelector runtimeSelector;
            InputStream contents;
            IndexSelector selector = (IndexSelector)indexIter.next();
            if (!(selector instanceof RuntimeIndexSelector) || (contents = (runtimeSelector = (RuntimeIndexSelector)selector).getFileContent(path, tokens, tokenReplacements)) == null) continue;
            return contents;
        }
        return null;
    }

    public List getIndexSelectors() {
        return this.indexSelectors;
    }
}

