/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.container;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.EObjectFinder;
import com.metamatrix.modeler.core.container.ObjectManager;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSetImpl;
import com.metamatrix.modeler.internal.core.util.AbstractFinder;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DefaultEObjectFinder
extends AbstractFinder
implements EObjectFinder {
    private final ContainerImpl container;

    public DefaultEObjectFinder(ContainerImpl container) {
        this.container = container;
    }

    public Object find(Object key) {
        if (key instanceof URI) {
            return this.getResourceSet().getEObject((URI)key, true);
        }
        if (key instanceof String) {
            Object obj;
            int index;
            String id = (String)key;
            if (StringUtil.startsWithIgnoreCase(id, "mmuuid")) {
                try {
                    return this.findByObjectID(IDGenerator.getInstance().stringToObject(id.toLowerCase()), true);
                }
                catch (InvalidIDException e2) {
                    throw new ModelerCoreRuntimeException(e2.getMessage());
                }
            }
            if (id.indexOf("#mmuuid") != -1 && (index = id.indexOf("#")) != 0 && (obj = this.find(id.substring(index + 1))) != null) {
                String namespaceUri = id.substring(0, index);
                try {
                    String uri;
                    ModelResource model = ModelUtil.getModel(obj);
                    if (model != null && (uri = model.getModelAnnotation().getNamespaceUri()) != null && uri.equals(namespaceUri)) {
                        return obj;
                    }
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log(4, theException, theException.getLocalizedMessage());
                }
            }
        } else if (key instanceof ObjectID) {
            return this.findByObjectID((ObjectID)key, true);
        }
        throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Invalid_key_object_in_Finder.find_method____6") + key);
    }

    public Object findKey(Object object) {
        if (object instanceof EObject) {
            return ((EObject)object).getObjectId();
        }
        return null;
    }

    protected ResourceSet getResourceSet() {
        return this.container.getResourceSet();
    }

    protected ObjectManager getObjectManager() {
        return this.container.getObjectManager();
    }

    protected Object findByObjectID(ObjectID objectID, boolean searchExternalResourceSets) {
        Object result = this.getObjectManager().findEObject(objectID);
        if (result == null && searchExternalResourceSets && this.getResourceSet() instanceof EmfResourceSetImpl) {
            ResourceSet[] externalResourceSets = ((EmfResourceSetImpl)this.getResourceSet()).getExternalResourceSets();
            for (int i2 = 0; i2 != externalResourceSets.length; ++i2) {
                ResourceSet resourceSet = externalResourceSets[i2];
                if (resourceSet instanceof Container) {
                    result = ((Container)resourceSet).getEObjectFinder().find(objectID);
                }
                if (result != null) break;
            }
        }
        return result;
    }
}

