/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.container;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.RunnableState;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.Registry;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.DuplicateResourceException;
import com.metamatrix.modeler.core.container.EObjectFinder;
import com.metamatrix.modeler.core.container.ObjectManager;
import com.metamatrix.modeler.core.container.ResourceDescriptor;
import com.metamatrix.modeler.core.container.ResourceFinder;
import com.metamatrix.modeler.core.transaction.UndoableListener;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.transaction.UnitOfWorkProvider;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.internal.core.container.ContainerEditingDomain;
import com.metamatrix.modeler.internal.core.container.DefaultEObjectFinder;
import com.metamatrix.modeler.internal.core.container.DefaultResourceFinder;
import com.metamatrix.modeler.internal.core.container.ObjectManagerImpl;
import com.metamatrix.modeler.internal.core.container.ResourceAction;
import com.metamatrix.modeler.internal.core.container.ResourceDescriptorImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSetImpl;
import com.metamatrix.modeler.internal.core.transaction.UnitOfWorkImpl;
import com.metamatrix.modeler.internal.core.transaction.UnitOfWorkProviderImpl;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;

public class ContainerImpl
implements Container,
IEditingDomainProvider {
    private static final ResourceSet[] EMPTY_RESOURCE_SET_ARRAY = new ResourceSet[0];
    public static final int UNSTARTED = 0;
    public static final int STARTING = 1;
    public static final int STARTED = 2;
    public static final int STOPPING = 3;
    public static final int STOPPED = 4;
    public static final int FAILED = 5;
    private UnitOfWorkProvider emfTransactionProvider;
    private ResourceSet resourceSet;
    private MetamodelRegistry metamodelRegistry;
    private MultiStatus status;
    private final ObjectManager objectManager = new ObjectManagerImpl(this);
    private DatatypeManager datatypeManager;
    private Map options;
    private RunnableState state;
    private String name;
    private ChangeNotifier changeNotifier;
    private EObjectFinder finder;
    private ResourceFinder resourceFinder;
    private EditingDomain editingDomain;

    public ContainerImpl() {
        this.initializeDefaults();
    }

    public static ResourceAction getOrCreateResource(ResourceSet resourceSet, URI uri) throws ModelerCoreException {
        ArgCheck.isNotNull(uri);
        Resource existingResource = resourceSet.getResource(uri, false);
        if (existingResource != null) {
            return new ResourceAction(existingResource, false);
        }
        if (!uri.isFile()) {
            Object[] params = new Object[]{URI.decode(uri.toString())};
            String msg = ModelerCore.Util.getString("ContainerImpl.URI_is_not_a_file_and_cannot_be_openned_as_a_resource", params);
            throw new ModelerCoreException(msg);
        }
        File file = new File(uri.toFileString());
        if (file.canRead() && file.exists() && file.length() != 0L) {
            try {
                return new ResourceAction(resourceSet.getResource(uri, true), false);
            }
            catch (DuplicateResourceException dre) {
                throw dre;
            }
            catch (Throwable t2) {
                Object[] params = new Object[]{URI.decode(uri.toString())};
                String msg = ModelerCore.Util.getString("ContainerImpl.Unable_to_open_the_resource", params);
                throw new ModelerCoreException(t2, msg);
            }
        }
        try {
            Resource newResource = resourceSet.createResource(uri);
            return new ResourceAction(newResource, true);
        }
        catch (DuplicateResourceException dre) {
            throw dre;
        }
        catch (Throwable t3) {
            Object[] params = new Object[]{URI.decode(uri.toString())};
            String msg = ModelerCore.Util.getString("ContainerImpl.Unable_to_create_the_resource", params);
            throw new ModelerCoreException(t3, msg);
        }
    }

    public Resource getOrCreateResource(URI uri) throws ModelerCoreException {
        ResourceAction action = ContainerImpl.getOrCreateResource(this, uri);
        return action.getResource();
    }

    public boolean isStarted() {
        return this.state.isState(2);
    }

    public boolean isStopped() {
        return this.state.isState(4);
    }

    public void addUndoableEditListener(UndoableListener listener) {
        this.emfTransactionProvider.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableListener listener) {
        this.emfTransactionProvider.removeUndoableEditListener(listener);
    }

    protected boolean isValidName(String potentialName) {
        return true;
    }

    protected void performShutdown() throws ModelerCoreException {
    }

    public void setChangeNotifier(ChangeNotifier notifier) {
        ArgCheck.isNotNull(notifier);
        this.verifySetIsAllowed(this.changeNotifier);
        this.changeNotifier = notifier;
    }

    public void setName(String newName) {
        this.verifySetIsAllowed(this.name);
        if (!this.isValidName(newName)) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("ContainerImpl.The_name___2") + newName + ModelerCore.Util.getString("ContainerImpl.__is_not_valid_3"));
        }
        String oldName = this.name;
        this.name = newName;
        this.updateRegistry(oldName);
    }

    protected void setState(int state) {
        this.state.setState(state);
    }

    public final void shutdown() throws ModelerCoreException {
        if (this.state.isState(4)) {
            return;
        }
        this.state.setState(3);
        try {
            this.performShutdown();
            this.state.setState(4);
        }
        catch (ModelerCoreException e2) {
            this.state.setState(5);
            throw e2;
        }
    }

    public final void start() throws ModelerCoreException {
        if (this.state.isState(2)) {
            return;
        }
        this.state.setState(1);
        try {
            this.performStart();
            this.state.setState(2);
        }
        catch (ModelerCoreException e2) {
            this.state.setState(5);
            throw e2;
        }
    }

    public String toString() {
        return this.getName();
    }

    protected void updateRegistry(String oldName) {
        Registry registry = ModelerCore.getRegistry();
        registry.register(this.getName(), this);
        if (oldName != null && registry.lookup(oldName) == this) {
            registry.unregister(oldName);
        }
    }

    protected void verifySetIsAllowed(Object property) {
        if (property != null) {
            if (this.state.isInTransition()) {
                throw new IllegalStateException(ModelerCore.Util.getString("ContainerImpl.Unable_to_set_the_name_while_the_container_is_in_transition_4"));
            }
            if (this.state.isRunning()) {
                throw new IllegalStateException(ModelerCore.Util.getString("ContainerImpl.Unable_to_set_the_name_on_a_running_container_5"));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    protected int getState() {
        return this.state.getState();
    }

    public XAResource getXAResource() {
        return null;
    }

    protected void initializeDefaults() {
        this.state = new RunnableState();
    }

    public ObjectManager getObjectManager() {
        return this.objectManager;
    }

    protected EObjectFinder createDefaultEObjectFinder() {
        return new DefaultEObjectFinder(this);
    }

    protected ResourceFinder createDefaultResourceFinder() {
        return new DefaultResourceFinder(this);
    }

    protected EditingDomain createDefaultEditingDomain() {
        ComposedAdapterFactory adapterFactory = (ComposedAdapterFactory)ModelerCore.getMetamodels().getEmfAdapterFactory();
        Assertion.isNotNull(this.getEmfTransactionProvider());
        BasicCommandStack commandStack = new BasicCommandStack();
        return new ContainerEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, this);
    }

    protected ChangeNotifier createDefaultChangeNotifier() {
        return new ChangeNotifier();
    }

    public ChangeNotifier getChangeNotifier() {
        if (this.changeNotifier == null) {
            this.setChangeNotifier(this.createDefaultChangeNotifier());
        }
        return this.changeNotifier;
    }

    public EObjectFinder getEObjectFinder() {
        if (this.finder == null) {
            this.setEObjectFinder(this.createDefaultEObjectFinder());
        }
        return this.finder;
    }

    public ResourceFinder getResourceFinder() {
        if (this.resourceFinder == null) {
            this.setResourceFinder(this.createDefaultResourceFinder());
        }
        return this.resourceFinder;
    }

    public void setEObjectFinder(EObjectFinder finder) {
        ArgCheck.isNotNull(finder);
        this.verifySetIsAllowed(this.finder);
        this.finder = finder;
    }

    public void setResourceFinder(ResourceFinder finder) {
        ArgCheck.isNotNull(finder);
        this.verifySetIsAllowed(this.resourceFinder);
        this.resourceFinder = finder;
    }

    public UnitOfWorkProvider getEmfTransactionProvider() {
        if (!this.isStarted()) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_7"));
        }
        return this.emfTransactionProvider;
    }

    protected void setEmfTransactionProvider(UnitOfWorkProvider emfTransactionProvider) {
        if (emfTransactionProvider == null) {
            ArgCheck.isNotNull(emfTransactionProvider, ModelerCore.Util.getString("ContainerImpl.The_UnitOfWorkProvider_may_not_be_null_8"));
        }
        this.emfTransactionProvider = emfTransactionProvider;
    }

    protected void setEditingDomain(EditingDomain editingDomain) {
        if (editingDomain == null) {
            ArgCheck.isNotNull(editingDomain, ModelerCore.Util.getString("ContainerImpl.The_EditingDomain_reference_may_not_be_null_1"));
        }
        this.editingDomain = editingDomain;
    }

    public IDGenerator getIDGenerator() {
        return IDGenerator.getInstance();
    }

    public final ResourceSet getResourceSet() {
        if (!this.isStarted()) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_9"));
        }
        return this.resourceSet;
    }

    public MetamodelRegistry getMetamodelRegistry() {
        if (!this.isStarted()) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_10"));
        }
        return this.metamodelRegistry;
    }

    public void setMetamodelRegistry(MetamodelRegistry metamodelRegistry) {
        if (metamodelRegistry == null) {
            ArgCheck.isNotNull(metamodelRegistry, ModelerCore.Util.getString("ContainerImpl.The_reference_to_the_MetamodelRegistry_may_not_be_null_11"));
        }
        this.metamodelRegistry = metamodelRegistry;
    }

    public DatatypeManager getDatatypeManager() {
        if (this.datatypeManager == null) {
            this.datatypeManager = ModelerCore.getBuiltInTypesManager();
        }
        return this.datatypeManager;
    }

    public void setDatatypeManager(DatatypeManager datatypeManager) {
        ArgCheck.isNotNull(datatypeManager);
        this.datatypeManager = datatypeManager;
    }

    public Resource createResource(URI uri) {
        return this.resourceSet.createResource(uri);
    }

    public EList getAdapterFactories() {
        return this.resourceSet.getAdapterFactories();
    }

    public TreeIterator getAllContents() {
        return this.resourceSet.getAllContents();
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        EObject result = null;
        if (uri != null && uri.fragment() != null) {
            String uriFragment = uri.fragment();
            URI resourceUri = uri.trimFragment();
            int beginIndex = uriFragment.indexOf("mmuuid");
            if (beginIndex != -1 && (beginIndex = beginIndex + "mmuuid".length() + 1) < uriFragment.length()) {
                String uuidStringWithoutProtocol = uriFragment.substring(beginIndex);
                try {
                    ObjectID uuid = UUID.stringToObject(uuidStringWithoutProtocol);
                    result = (EObject)this.getEObjectFinder().find(uuid);
                    if (result == null) {
                        result = this.getEObjectFromExternalResourceSets(uri, false);
                    }
                    if (result != null) {
                        Resource resource = this.resourceSet.getResource(resourceUri, false);
                        Resource resultantResource = result.eResource();
                        if (resource != null && !resource.equals(resultantResource)) {
                            result = null;
                        }
                    }
                }
                catch (InvalidIDException e2) {
                    ModelerCore.Util.log(4, e2, e2.getMessage());
                }
            }
        }
        if (result != null) {
            return result;
        }
        return this.resourceSet.getEObject(uri, loadOnDemand);
    }

    private EObject getEObjectFromExternalResourceSets(URI uri, boolean loadOnDemand) {
        EObject result = null;
        if (this.resourceSet instanceof EmfResourceSetImpl) {
            ResourceSet rsrcSet;
            ResourceSet[] externalResourceSets = ((EmfResourceSetImpl)this.resourceSet).getExternalResourceSets();
            for (int i2 = 0; i2 != externalResourceSets.length && (result = (rsrcSet = externalResourceSets[i2]).getEObject(uri, loadOnDemand)) == null; ++i2) {
            }
        }
        return result;
    }

    public Map getLoadOptions() {
        return this.resourceSet.getLoadOptions();
    }

    public EPackage.Registry getPackageRegistry() {
        return this.resourceSet.getPackageRegistry();
    }

    public void setPackageRegistry(EPackage.Registry packageRegistry) {
        this.resourceSet.setPackageRegistry(packageRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(URI uri, boolean loadOnDemand) {
        boolean created;
        Resource resource;
        block18: {
            if (uri == null) {
                ArgCheck.isNotNull(uri, ModelerCore.Util.getString("ContainerImpl.The_URI_to_load_may_not_be_null_12"));
            }
            if (!this.isStarted()) {
                throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("ContainerImpl.Container_must_be_started_prior_to_use_13"));
            }
            UnitOfWork txn = this.getEmfTransactionProvider().getCurrent();
            boolean startedTxn = false;
            if (!txn.isStarted()) {
                try {
                    txn.begin();
                }
                catch (ModelerCoreException e2) {
                    ModelerCore.Util.log(4, e2, e2.getMessage());
                }
                startedTxn = true;
            }
            resource = null;
            created = false;
            try {
                this.log(ModelerCore.Util.getString("ContainerImpl.>>_ContainerImpl.delegatedGetResource__URI___14") + uri + ", loadOnDemand= " + loadOnDemand);
                if (this.metamodelRegistry != null && this.metamodelRegistry.containsURI(uri)) {
                    resource = this.metamodelRegistry.getResourceSet().getResource(uri, loadOnDemand);
                    this.log(ModelerCore.Util.getString("ContainerImpl.>>_Returning_Resource_in_the_MetamodelRegistry_with_URI___16") + uri + "\"");
                }
                created = this.resourceSet.getResource(uri, false) == null;
                resource = this.resourceSet.getResource(uri, loadOnDemand);
                Object var8_8 = null;
                if (!startedTxn) break block18;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (startedTxn) {
                    try {
                        if (resource != null) {
                            txn.commit();
                        } else {
                            txn.rollback();
                        }
                    }
                    catch (ModelerCoreException e3) {
                        throw new ModelerCoreRuntimeException(e3);
                    }
                }
                if (resource != null && created) {
                    resource.setModified(false);
                }
                throw throwable;
            }
            try {
                if (resource != null) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (ModelerCoreException e3) {
                throw new ModelerCoreRuntimeException(e3);
            }
        }
        if (resource != null && created) {
            resource.setModified(false);
        }
        return resource;
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        return this.resourceSet.getResourceFactoryRegistry();
    }

    public EList getResources() {
        return this.resourceSet.getResources();
    }

    public URIConverter getURIConverter() {
        return this.resourceSet.getURIConverter();
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        this.resourceSet.setResourceFactoryRegistry(resourceFactoryRegistry);
    }

    public void setURIConverter(URIConverter converter) {
        this.resourceSet.setURIConverter(converter);
    }

    public EList eAdapters() {
        return this.resourceSet.eAdapters();
    }

    public boolean eDeliver() {
        return this.resourceSet.eDeliver();
    }

    public void eNotify(Notification notification) {
        this.resourceSet.eNotify(notification);
    }

    public void eSetDeliver(boolean deliver) {
        this.resourceSet.eSetDeliver(deliver);
    }

    public EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.setEditingDomain(this.createDefaultEditingDomain());
        }
        return this.editingDomain;
    }

    protected void performStart() throws ModelerCoreException {
        MetamodelRegistry registry;
        this.setState(1);
        this.resourceSet = new EmfResourceSetImpl(this);
        final INotifyChangedListener objectChangeListner = this.getObjectManager().getObjectChangeListner();
        this.resourceSet.eAdapters().add(new EContentAdapter(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                UnitOfWorkImpl txn = (UnitOfWorkImpl)ContainerImpl.this.getEmfTransactionProvider().getCurrent();
                try {
                    if (txn.isStarted() || txn.isRollingBack()) {
                        txn.processNotification(msg);
                    } else {
                        this.notifyForClosedUoW(txn, msg);
                    }
                }
                catch (ModelerCoreException e2) {
                    ModelerCore.Util.log(e2);
                }
                if (objectChangeListner != null) {
                    objectChangeListner.notifyChanged(msg);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void notifyForClosedUoW(UnitOfWorkImpl txn, Notification msg) {
                block12: {
                    notifier = msg.getNotifier();
                    if (notifier instanceof EObject) {
                        uri = ((EObject)notifier).eClass().getEPackage().getNsURI();
                        descriptor = ModelerCore.getMetamodels().getMetamodelDescriptor(uri);
                        if (descriptor != null && !descriptor.requiresProxies()) {
                            try {
                                try {
                                    txn.begin();
                                    txn.setSource(this);
                                    txn.processNotification(msg);
                                    var8_6 = null;
                                    if (txn.isStarted() == false) return;
                                }
                                catch (ModelerCoreException e) {
                                    ModelerCore.Util.log(4, e, e.getMessage());
                                    var8_7 = null;
                                    if (txn.isStarted()) {
                                        try {
                                            txn.commit();
                                        }
                                        catch (ModelerCoreException e1) {
                                            ModelerCore.Util.log(4, e1, e1.getMessage());
                                        }
                                    }
                                    break block12;
                                }
                            }
                            catch (Throwable var7_13) {
                                var8_8 = null;
                                if (txn.isStarted() == false) throw var7_13;
                                ** try [egrp 2[TRYBLOCK] [4 : 121->128)] { 
lbl31:
                                // 1 sources

                                txn.commit();
                                throw var7_13;
lbl33:
                                // 1 sources

                                catch (ModelerCoreException e1) {
                                    ModelerCore.Util.log(4, e1, e1.getMessage());
                                }
                                throw var7_13;
                            }
                            ** try [egrp 2[TRYBLOCK] [4 : 121->128)] { 
lbl38:
                            // 1 sources

                            txn.commit();
                            return;
lbl40:
                            // 1 sources

                            catch (ModelerCoreException e1) {
                                ModelerCore.Util.log(4, e1, e1.getMessage());
                            }
                            return;
                        }
                    }
                }
                if (ModelerCore.DEBUG_NOTIFICATIONS == false) return;
                ModelerCore.Util.log(1, ModelerCore.Util.getString("ContainerImpl.Could_not_process_notification_for_closed_txn_1"));
            }
        });
        this.resourceSet.setURIConverter(new URIConverterImpl());
        this.initializeIDGenerator();
        this.emfTransactionProvider = new UnitOfWorkProviderImpl(this.resourceSet);
        this.metamodelRegistry = registry = ModelerCore.getMetamodelRegistry();
        this.setState(2);
    }

    protected boolean isReadOnly(Resource resource) {
        File f2;
        return resource != null && resource.getURI().isFile() && (f2 = new File(resource.getURI().toFileString())).exists() && !f2.canWrite();
    }

    private void initializeIDGenerator() {
        IDGenerator idGen = IDGenerator.getInstance();
        idGen.addBuiltInFactories();
    }

    private void log(String msg) {
        if (ModelerCore.DEBUG) {
            ModelerCore.Util.log(msg);
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void addResourceDescriptor(ResourceDescriptor resourceDescriptor) throws ModelerCoreException {
        ResourceDescriptorImpl.register(resourceDescriptor, this.resourceSet);
    }

    public void addExternalResourceSet(ResourceSet rsrcSet) {
        ArgCheck.isNotNull(rsrcSet);
        if (this.resourceSet instanceof EmfResourceSetImpl) {
            ((EmfResourceSetImpl)this.resourceSet).addExternalResourceSet(rsrcSet);
        }
    }

    public ResourceSet[] getExternalResourceSets() {
        if (this.resourceSet instanceof EmfResourceSetImpl) {
            return ((EmfResourceSetImpl)this.resourceSet).getExternalResourceSets();
        }
        return EMPTY_RESOURCE_SET_ARRAY;
    }

    public Map getOptions() {
        return this.options == null ? Collections.EMPTY_MAP : this.options;
    }

    public void setOptions(Map options) {
        this.verifySetIsAllowed(this.options);
        this.options = options;
    }
}

