/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.builder;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.builder.ResourceValidator;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.Validator;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class XmiResourceValidator
implements ResourceValidator {
    public boolean isValidatorForObject(Object obj) {
        if (obj instanceof IResource) {
            return this.isValidatorForResource((IResource)obj);
        }
        return obj instanceof EmfResource;
    }

    public void validate(IProgressMonitor monitor, Object obj, ValidationContext context) throws ModelerCoreException {
        EmfResource eResource;
        IProgressMonitor progressMonitor;
        if (!this.isValidatorForObject(obj)) {
            Object[] params = new Object[]{this.getClass().getName(), obj != null ? obj.getClass().getName() : null};
            String msg = ModelerCore.Util.getString("XmiResourceValidator.validator_cannot_be_used_to_validate_the_object", params);
            throw new ModelerCoreException(msg);
        }
        IProgressMonitor iProgressMonitor = progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (obj instanceof IResource) {
            IResource iResource = (IResource)obj;
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            ModelResource mResource = workspace.findModelResource(iResource);
            if (mResource != null) {
                Resource eResource2 = mResource.getEmfResource();
                this.validate(progressMonitor, eResource2, iResource, context);
            }
        } else if (obj instanceof EmfResource && (eResource = (EmfResource)obj).isLoaded()) {
            try {
                Validator.validate(monitor, eResource, context);
            }
            catch (Throwable e2) {
                String msg = ModelerCore.Util.getString("ModelBuilder.Error_validating_model_resource_2", eResource);
                ModelerCore.Util.log(4, e2, msg);
            }
        }
    }

    public void addMarkers(ValidationContext context, IResource iResource) throws ModelerCoreException {
        if (context != null && context.hasResults()) {
            List results = context.getValidationResults();
            try {
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    ValidationResult result = (ValidationResult)iter.next();
                    if (result == null || !result.hasProblems()) continue;
                    ValidationProblem[] problems = result.getProblems();
                    String rsltLocationPath = result.getLocationPath();
                    String rsltLocationUri = result.getLocationUri();
                    String targetUri = result.getTargetUri();
                    for (int probCnt = 0; probCnt < problems.length; ++probCnt) {
                        String probURI;
                        String probLocPath = problems[probCnt].getLocation();
                        if (probLocPath == null) {
                            probLocPath = rsltLocationPath;
                        }
                        if ((probURI = problems[probCnt].getURI()) == null) {
                            probURI = rsltLocationUri;
                        }
                        this.createProblemMarker(probLocPath, probURI, targetUri, problems[probCnt], iResource);
                    }
                    if (!result.isFatalResource()) continue;
                    return;
                }
            }
            catch (CoreException err) {
                throw new ModelerCoreException(err);
            }
        }
    }

    public boolean isValidatorForResource(IResource iResource) {
        return ModelUtil.isModelFile(iResource) && !ModelUtil.isXsdFile(iResource);
    }

    public void validate(IProgressMonitor progressMonitor, Resource resource, IResource iResource, ValidationContext context) throws ModelerCoreException {
        IProgressMonitor monitor;
        IProgressMonitor iProgressMonitor = monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        if (!(resource instanceof EmfResource)) {
            String msg = ModelerCore.Util.getString("XmiResourceValidator.XmiResourceValidator_may_only_be_used_to_validate_instances_of_EmfResource_1");
            throw new ModelerCoreException(msg);
        }
        if (iResource == null) {
            String msg = ModelerCore.Util.getString("XmiResourceValidator.IResource_may_not_be_null_during_validation_2");
            throw new ModelerCoreException(msg);
        }
        if (!this.isValidatorForResource(iResource)) {
            String msg = ModelerCore.Util.getString("XmiResourceValidator.Unexpected_IResource_type_encountered_during_EMF_Resource_Validation_1");
            throw new ModelerCoreException(msg);
        }
        EmfResource emfResource = (EmfResource)resource;
        if (emfResource.isLoaded()) {
            try {
                Validator.validate(monitor, emfResource, context);
            }
            catch (Throwable e2) {
                String msg = ModelerCore.Util.getString("ModelBuilder.Error_validating_model_resource_2", emfResource);
                ModelerCore.Util.log(4, e2, msg);
            }
        }
    }

    public void validationStarted(Collection resources, ValidationContext context) {
    }

    public void validationEnded(ValidationContext context) {
    }

    private void createProblemMarker(String locationPath, String locationUri, String targetUri, ValidationProblem problem, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("location", locationPath);
        marker.setAttribute("com.metamatrix.modeler.core.markerURI", locationUri);
        marker.setAttribute("com.metamatrix.modeler.core.targetMarkerURI", targetUri);
        marker.setAttribute("message", problem.getMessage());
        this.setMarkerSeverity(marker, problem);
    }

    private void setMarkerSeverity(IMarker marker, ValidationProblem problem) throws CoreException {
        switch (problem.getSeverity()) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                return;
            }
        }
    }
}

