/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.builder;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Stopwatch;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.builder.ResourceValidator;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.DuplicateResourceException;
import com.metamatrix.modeler.core.index.ResourceIndexer;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.index.ModelIndexer;
import com.metamatrix.modeler.internal.core.index.ModelSearchIndexer;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelBuildUtil {
    public static final int MONITOR_TASK_NAME_MAX_LENGTH = 200;
    public static final String TASK_NAME_TRUNCTATION_SUFFIX = ModelerCore.Util.getString("ModelBuildUtil.taskNameTruncationSuffix");
    public static final String MONITOR_RESOURCE_VALIDATION_MSG = ModelerCore.Util.getString("ModelBuildUtil.Validating_Resource__1");
    public static final String MONITOR_OBJECT_VALIDATION_MSG = ModelerCore.Util.getString("ModelBuildUtil.Validating__2");
    private static Collection VALIDATORS;
    private static Collection INDEXERS;

    public static void buildResources(IProgressMonitor monitor, Collection iResources, Container container, boolean validateInContext) {
        List modifiedResources = ModelBuildUtil.getModifiedResources();
        ModelBuildUtil.indexResources(monitor, iResources);
        ModelBuildUtil.setModifiedResources(modifiedResources);
        ModelBuildUtil.validateResources(monitor, iResources, container, validateInContext);
        ModelBuildUtil.setModifiedResources(modifiedResources);
    }

    public static ValidationContext createValidationContext() {
        ValidationContext context = null;
        Plugin corePlugin = ModelerCore.getPlugin();
        context = corePlugin != null && !ModelerCore.ignoreValidationPreferencesOnBuild() ? new ValidationContext(corePlugin.getPluginPreferences()) : new ValidationContext();
        return context;
    }

    public static void validateResources(IProgressMonitor monitor, Resource[] eResources, ValidationContext context) {
        ArgCheck.isNotNull(eResources);
        ArgCheck.isNotNull(context);
        IProgressMonitor progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        context.setResourcesToValidate(eResources);
        for (int i2 = 0; i2 < eResources.length; ++i2) {
            ModelBuildUtil.validateResource(progresssMonitor, eResources[i2], context);
        }
    }

    public static void validateResource(IProgressMonitor monitor, Resource eResource, ValidationContext context) {
        ArgCheck.isNotNull(eResource);
        ArgCheck.isNotNull(context);
        Iterator validateIter = VALIDATORS.iterator();
        while (validateIter.hasNext()) {
            ResourceValidator validator = (ResourceValidator)validateIter.next();
            ModelBuildUtil.validateResource(monitor, eResource, validator, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateResource(IProgressMonitor monitor, Resource eResource, ResourceValidator validator, ValidationContext context) {
        IProgressMonitor progresssMonitor;
        ArgCheck.isNotNull(eResource);
        ArgCheck.isNotNull(validator);
        ArgCheck.isNotNull(context);
        boolean debugTimingEnabled = ModelerCore.Util.isDebugEnabled("modelValidationTiming");
        IProgressMonitor iProgressMonitor = progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (monitor.isCanceled() || !validator.isValidatorForObject(eResource)) {
            return;
        }
        monitor.setTaskName(MONITOR_RESOURCE_VALIDATION_MSG + eResource.getURI().lastSegment());
        boolean isModified = eResource.isModified();
        try {
            Stopwatch totalWatch = new Stopwatch();
            totalWatch.start();
            validator.validate(progresssMonitor, eResource, context);
            totalWatch.stop();
            if (debugTimingEnabled) {
                Stopwatch.logTimedMessage(" ModelBuildUtil.validateResource():  " + eResource, totalWatch.getTotalDuration());
            }
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(e2);
        }
        finally {
            eResource.setModified(isModified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateResources(IProgressMonitor monitor, Collection iResources, Container container, boolean validateInContext) {
        IProgressMonitor progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        ValidationContext context = ModelBuildUtil.createValidationContext();
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        try {
            Resource[] resourcesInScope = ModelBuildUtil.getWorkspaceResourcesInScope(workspace);
            context.setResourcesInScope(resourcesInScope);
        }
        catch (CoreException theException) {
            ModelerCore.Util.log(theException);
        }
        if (validateInContext && iResources != null) {
            ArrayList<Resource> temp = new ArrayList<Resource>();
            Iterator itr = iResources.iterator();
            while (itr.hasNext()) {
                IResource iResource = (IResource)itr.next();
                if (!ModelUtil.isModelFile(iResource)) continue;
                try {
                    ModelResource modelResource = ModelerCore.getModelEditor().findModelResource((IFile)iResource);
                    if (modelResource == null) continue;
                    temp.add(modelResource.getEmfResource());
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log(theException);
                }
            }
            context.setResourcesToValidate(temp.toArray(new Resource[temp.size()]));
        }
        context.setResourceContainer(container);
        Iterator validateIter = VALIDATORS.iterator();
        while (validateIter.hasNext()) {
            ResourceValidator validator = (ResourceValidator)validateIter.next();
            validator.validationStarted(iResources, context);
            try {
                Iterator rsourceIter = iResources.iterator();
                while (rsourceIter.hasNext()) {
                    IResource resource = (IResource)rsourceIter.next();
                    ModelBuildUtil.validateResource(progresssMonitor, resource, validator, context);
                }
            }
            finally {
                validator.validationEnded(context);
            }
        }
        context.clearState();
    }

    private static Resource[] getWorkspaceResourcesInScope(ModelWorkspace workspace) throws CoreException {
        Resource[] wsEmfResources = workspace.getEmfResources();
        ArrayList<Resource> resourcesInScope = new ArrayList<Resource>(Arrays.asList(wsEmfResources));
        ModelBuildUtil.updateResource(resourcesInScope);
        return resourcesInScope.toArray(new Resource[resourcesInScope.size()]);
    }

    private static void updateResource(Collection resourcesInScope) {
        Resource[] systemVdbResources = ModelerCore.getSystemVdbResources();
        for (int idx = 0; idx < systemVdbResources.length; ++idx) {
            if (systemVdbResources[idx] instanceof EmfResource) {
                ObjectID objectID = ((EmfResource)systemVdbResources[idx]).getUuid();
                try {
                    Resource resrc = ModelerCore.getModelContainer().getResourceFinder().findByUUID(objectID, false);
                    if (resrc == null || resourcesInScope.contains(resrc)) continue;
                    resourcesInScope.add(systemVdbResources[idx]);
                }
                catch (CoreException err) {
                    ModelerCore.Util.log(err);
                }
                continue;
            }
            resourcesInScope.add(systemVdbResources[idx]);
        }
    }

    private static void initValidators() {
        String id = "com.metamatrix.modeler.core.resourceValidator";
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.resourceValidator");
        VALIDATORS = new ArrayList(extensions.length);
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            String element = "class";
            String attribute = "name";
            try {
                Object instance = PluginUtilities.createExecutableExtension(extension, "class", "name");
                if (instance instanceof ResourceValidator) {
                    VALIDATORS.add(instance);
                    continue;
                }
                String message = ModelerCore.Util.getString("ModelBuildUtil.Extension_class_not_instance_of_ResourceValidator_1");
                ModelerCore.Util.log(message);
                continue;
            }
            catch (CoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
    }

    public static void validateResource(IProgressMonitor monitor, IResource iResource, ResourceValidator validator, ValidationContext context) {
        IProgressMonitor progresssMonitor;
        boolean debugTimingEnabled = ModelerCore.Util.isDebugEnabled("modelValidationTiming");
        IProgressMonitor iProgressMonitor = progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (progresssMonitor.isCanceled() || !validator.isValidatorForObject(iResource)) {
            return;
        }
        progresssMonitor.setTaskName(MONITOR_RESOURCE_VALIDATION_MSG + iResource.getFullPath());
        Object duplicateOfModel = null;
        try {
            duplicateOfModel = iResource.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
        }
        catch (CoreException err) {
            // empty catch block
        }
        try {
            if (iResource.exists()) {
                iResource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(e2);
        }
        if (duplicateOfModel == null) {
            try {
                ModelWorkspace workspace = ModelerCore.getModelWorkspace();
                ModelResource mResource = workspace.findModelResource(iResource);
                Object resource = null;
                if (!ModelUtil.isVdbArchiveFile(iResource)) {
                    try {
                        if (mResource != null && mResource.getEmfResource() != null) {
                            resource = mResource.getEmfResource();
                        } else if (resource == null && iResource.getRawLocation() != null) {
                            URI uri = URI.createFileURI(((Object)iResource.getRawLocation()).toString());
                            resource = ModelerCore.getModelContainer().getResource(uri, true);
                            if (resource != null) {
                                resource.setModified(false);
                            }
                        }
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                IResource objToValidate = resource != null ? resource : iResource;
                Stopwatch totalWatch = new Stopwatch();
                totalWatch.start();
                validator.validate(progresssMonitor, objToValidate, context);
                totalWatch.stop();
                if (debugTimingEnabled) {
                    Stopwatch.logTimedMessage(" ModelBuildUtil.validateResource():  " + objToValidate, totalWatch.getTotalDuration());
                }
                validator.addMarkers(context, iResource);
                context.clearResults();
            }
            catch (ModelerCoreException e4) {
                Throwable underlyingException = e4.getException();
                if (underlyingException instanceof DuplicateResourceException) {
                    try {
                        duplicateOfModel = iResource.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
                    }
                    catch (CoreException err) {
                        ModelerCore.Util.log(err);
                    }
                }
                ModelerCore.Util.log(e4);
            }
        }
        if (duplicateOfModel != null) {
            try {
                Object[] params = new Object[]{duplicateOfModel};
                String msg = ModelerCore.Util.getString("ModelBuildUtil.ModelDuplicateOf_0", params);
                IMarker marker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("location", duplicateOfModel);
                marker.setAttribute("com.metamatrix.modeler.core.markerURI", null);
                marker.setAttribute("com.metamatrix.modeler.core.targetMarkerURI", null);
                marker.setAttribute("message", msg);
            }
            catch (CoreException e5) {
                ModelerCore.Util.log(e5);
            }
        }
    }

    public static void indexResources(IProgressMonitor monitor, Collection resources) {
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        Iterator indexerIter = INDEXERS.iterator();
        while (indexerIter.hasNext()) {
            ResourceIndexer indexer = (ResourceIndexer)indexerIter.next();
            ModelBuildUtil.indexResources(monitor, resources, indexer);
        }
    }

    private static void initIndexers() {
        String id = "com.metamatrix.modeler.core.resourceIndexer";
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.resourceIndexer");
        INDEXERS = new ArrayList(extensions.length);
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            String element = "class";
            String attribute = "name";
            try {
                Object instance = PluginUtilities.createExecutableExtension(extension, "class", "name");
                if (instance instanceof ResourceIndexer) {
                    INDEXERS.add(instance);
                    continue;
                }
                String message = ModelerCore.Util.getString("ModelBuildUtil.Extension_class_not_instance_of_IIndexer_1");
                ModelerCore.Util.log(message);
                continue;
            }
            catch (CoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
    }

    public static void createModelIndexes(IProgressMonitor monitor, Collection resources) {
        ModelIndexer modelIndexer = new ModelIndexer();
        ModelBuildUtil.indexResources(monitor, resources, modelIndexer);
    }

    public static void createSearchIndexes(IProgressMonitor monitor, Collection resources) {
        ModelSearchIndexer searchIndexer = new ModelSearchIndexer();
        ModelBuildUtil.indexResources(monitor, resources, searchIndexer);
    }

    public static void indexResources(IProgressMonitor monitor, Collection resources, ResourceIndexer indexer) {
        Iterator rsourceIter = resources.iterator();
        while (rsourceIter.hasNext()) {
            IResource resource = (IResource)rsourceIter.next();
            ModelBuildUtil.indexResource(monitor, resource, indexer);
            if (monitor == null) continue;
            monitor.worked(1);
        }
    }

    public static void indexResource(IProgressMonitor monitor, IResource iResource, ResourceIndexer indexer) {
        boolean debugTimingEnabled = ModelerCore.Util.isDebugEnabled("modelValidationTiming");
        IProgressMonitor iProgressMonitor = monitor = monitor != null ? monitor : new NullProgressMonitor();
        if (monitor.isCanceled()) {
            return;
        }
        String sTask = ModelerCore.Util.getString("ModelBuildUtil.Creating_{0}_for_{1}_1", indexer.getIndexType(), iResource.getFullPath());
        monitor.setTaskName(sTask);
        try {
            Stopwatch totalWatch = new Stopwatch();
            totalWatch.start();
            indexer.indexResource(iResource, false, true);
            totalWatch.stop();
            if (debugTimingEnabled) {
                Stopwatch.logTimedMessage(" ModelBuildUtil.indexResource():  " + iResource, totalWatch.getTotalDuration());
            }
        }
        catch (Throwable e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelBuilder.Error_indexing_model_resource_3", iResource.getFullPath()));
        }
    }

    public static List getModifiedResources() {
        try {
            return ModelBuildUtil.getModifiedResources(ModelerCore.getModelContainer().getResources());
        }
        catch (CoreException coreException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static List getModifiedResources(List eResources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (eResources != null) {
            Iterator iter = eResources.iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                if (!resource.isModified()) continue;
                result.add(resource);
            }
        }
        return result;
    }

    public static void setModifiedResources(List modifiedResources) {
        try {
            Container container = ModelerCore.getModelContainer();
            Iterator iter = container.getResources().iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                if (modifiedResources != null && modifiedResources.contains(resource)) {
                    resource.setModified(true);
                    continue;
                }
                resource.setModified(false);
            }
        }
        catch (CoreException theException) {
            ModelerCore.Util.log(4, theException, theException.getMessage());
        }
    }

    static {
        ModelBuildUtil.initValidators();
        ModelBuildUtil.initIndexers();
    }
}

