/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ValidationDescriptor;
import com.metamatrix.modeler.core.ValidationPreferences;
import com.metamatrix.modeler.internal.core.EclipseConfigurationBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class ValidationPreferencesImpl
implements ValidationPreferences {
    private static char DELIMITER = (char)46;
    private static final List validationDescriptors = EclipseConfigurationBuilder.readValidationDescriptors();
    private static final Set optionNames = ValidationPreferencesImpl.getOptionNames(validationDescriptors);

    private static Set getOptionNames(List descriptors) {
        HashSet<String> rv = new HashSet<String>();
        Iterator itor = descriptors.iterator();
        while (itor.hasNext()) {
            ValidationDescriptor vdesc = (ValidationDescriptor)itor.next();
            String name = ValidationPreferencesImpl.getFullName(vdesc);
            rv.add(name);
        }
        return rv;
    }

    private static String getFullName(ValidationDescriptor vdesc) {
        String descID = vdesc.getExtensionID();
        String descName = vdesc.getPreferenceName();
        return descID + DELIMITER + descName;
    }

    public ValidationPreferencesImpl() {
        List descriptors = this.getValidationDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            Preferences preferences = ModelerCore.getPlugin().getPluginPreferences();
            int size = descriptors.size();
            HashMap<ValidationDescriptor, String> changeMap = new HashMap<ValidationDescriptor, String>(size);
            for (int i2 = 0; i2 < size; ++i2) {
                ValidationDescriptor descriptor = (ValidationDescriptor)descriptors.get(i2);
                String value = this.getCurrentPreferenceValue(preferences, descriptor);
                if (StringUtil.isEmpty(value)) {
                    value = descriptor.getDefaultOption();
                }
                changeMap.put(descriptor, value);
            }
            this.setOptions(changeMap);
        }
    }

    private String getCurrentPreferenceValue(Preferences thePreferences, ValidationDescriptor theDescriptor) {
        return thePreferences.getString(ValidationPreferencesImpl.getFullName(theDescriptor));
    }

    public List getValidationDescriptors() {
        return validationDescriptors;
    }

    public void setOptions(Map newOptions) {
        Preferences preferences = ModelerCore.getPlugin().getPluginPreferences();
        Iterator keyIter = newOptions.keySet().iterator();
        while (keyIter.hasNext()) {
            Object value;
            ValidationDescriptor key = (ValidationDescriptor)keyIter.next();
            String name = ValidationPreferencesImpl.getFullName(key);
            if (!optionNames.contains(name) || (value = newOptions.get(key)) == null) continue;
            preferences.setValue(name, this.getValidOption((String)value));
        }
        ModelerCore.getPlugin().savePluginPreferences();
    }

    public Map getOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        Plugin plugin = ModelerCore.getPlugin();
        if (plugin != null) {
            Preferences preferences = plugin.getPluginPreferences();
            String[] propertyNames = preferences.propertyNames();
            for (int i2 = 0; i2 < propertyNames.length; ++i2) {
                String propertyName = propertyNames[i2];
                if (!optionNames.contains(propertyName)) continue;
                String value = preferences.getString(propertyName).trim();
                options.put(propertyName, value);
            }
        }
        return options;
    }

    private String getValidOption(String value) {
        if (value.equalsIgnoreCase("error") || value.equalsIgnoreCase("ignore") || value.equalsIgnoreCase("info") || value.equalsIgnoreCase("warning")) {
            return value;
        }
        return "ignore";
    }
}

