/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.modeler.core.ExtensionDescriptor;
import com.metamatrix.modeler.internal.core.ExtensionDescriptorImpl;

public class ExtensionMultiDescriptorImpl
extends ExtensionDescriptorImpl
implements ExtensionDescriptor {
    private ObjectVector children = new ObjectVector();

    public ExtensionMultiDescriptorImpl(Object id, String className, ClassLoader classLoader) {
        super(id, className, classLoader);
    }

    public ExtensionDescriptor[] getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return EMPTY_ARRAY;
        }
        Object[] result = new ExtensionDescriptor[this.children.size()];
        this.children.copyInto(result);
        return result;
    }

    public boolean isMultiDescriptor() {
        return true;
    }

    public ExtensionDescriptor getChildDescriptor(Object id) {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ExtensionDescriptor descriptor = (ExtensionDescriptor)this.children.elementAt(i2);
            Object descriptorId = descriptor.getId();
            if (descriptorId == null || !descriptorId.equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public void addDescriptor(ExtensionDescriptor descriptor) {
        Object descriptorId;
        if (this.children == null) {
            this.children = new ObjectVector();
        }
        if ((descriptorId = descriptor.getId()) != null && this.getChildDescriptor(descriptorId) != null) {
            this.children.remove(this.getChildDescriptor(descriptorId));
        }
        this.children.add(descriptor);
    }
}

