/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.modeler.core.ExtensionDescriptor;
import com.metamatrix.modeler.core.ModelerCore;

public class ExtensionDescriptorImpl
implements ExtensionDescriptor {
    protected static final ExtensionDescriptor[] EMPTY_ARRAY = new ExtensionDescriptor[0];
    protected Object id;
    protected DescriptorClassLoader extensionClassLoader;

    public ExtensionDescriptorImpl(Object id, String className, ClassLoader classLoader) {
        if (id == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_ID_reference_may_not_be_null_1"));
        }
        this.id = id;
        if (className != null && classLoader != null) {
            this.extensionClassLoader = new DescriptorClassLoader(className, classLoader);
        }
    }

    public Object getId() {
        return this.id;
    }

    public String getClassName() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getClassName() : null;
    }

    public Class getExtensionClass() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getLoadedClass() : null;
    }

    public Object getExtensionClassInstance() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getClassInstance() : null;
    }

    public Object getNewExtensionClassInstance() {
        return this.extensionClassLoader != null ? this.extensionClassLoader.getNewClassInstance() : null;
    }

    public ExtensionDescriptor[] getChildren() {
        return EMPTY_ARRAY;
    }

    public boolean isMultiDescriptor() {
        return false;
    }

    public ExtensionDescriptor getChildDescriptor(Object id) {
        return null;
    }

    private class DescriptorClassLoader {
        private final String className;
        private final ClassLoader classLoader;
        private boolean loadClassFailure;
        private boolean newInstanceFailure;
        private Class loadedClass;
        private Object classInstance;

        public DescriptorClassLoader(String className, ClassLoader classLoader) {
            if (className == null) {
                throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_class_name_string_may_not_be_null_1"));
            }
            if (className.length() == 0) {
                throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_class_name_string_may_not_be_zero_length_3"));
            }
            if (classLoader == null) {
                throw new IllegalArgumentException(ModelerCore.Util.getString("ExtensionDescriptorImpl.The_ClassLoader_reference_may_not_be_null_2"));
            }
            this.className = className;
            this.classLoader = classLoader;
            this.loadClassFailure = false;
            this.newInstanceFailure = false;
            this.loadedClass = null;
            this.classInstance = null;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescriptorClassLoader)) {
                return false;
            }
            DescriptorClassLoader that = (DescriptorClassLoader)obj;
            if (this.className.equals(that.className) && this.classLoader.equals(that.classLoader)) {
                return true;
            }
            return super.equals(obj);
        }

        public Class getLoadedClass() {
            if (!this.loadClassFailure && this.loadedClass == null) {
                try {
                    this.loadedClass = this.classLoader.loadClass(this.className);
                    this.loadClassFailure = false;
                }
                catch (ClassNotFoundException e2) {
                    ModelerCore.Util.log(4, ModelerCore.Util.getString("ExtensionDescriptorImpl.Unable_to_load_class_using_classLoader_4", this.className, this.classLoader));
                    this.loadedClass = null;
                    this.loadClassFailure = true;
                }
            }
            return this.loadedClass;
        }

        public Object getClassInstance() {
            if (!this.newInstanceFailure && this.classInstance == null && this.getLoadedClass() != null) {
                try {
                    this.classInstance = this.getLoadedClass().newInstance();
                    this.newInstanceFailure = false;
                }
                catch (InstantiationException e2) {
                    ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_5", this.loadedClass, e2.getMessage()));
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
                catch (IllegalAccessException e3) {
                    ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_6", this.loadedClass, e3.getMessage()));
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
            }
            return this.classInstance;
        }

        public Object getNewClassInstance() {
            Object newClassInstance = null;
            if (!this.newInstanceFailure && this.getLoadedClass() != null) {
                try {
                    newClassInstance = this.getLoadedClass().newInstance();
                    this.newInstanceFailure = false;
                }
                catch (InstantiationException e2) {
                    ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_5", this.loadedClass, e2.getMessage()));
                    this.newInstanceFailure = true;
                }
                catch (IllegalAccessException e3) {
                    ModelerCore.Util.log(4, e3, ModelerCore.Util.getString("ExtensionDescriptorImpl.Creating_an_instance_of_6", this.loadedClass, e3.getMessage()));
                    this.newInstanceFailure = true;
                }
            }
            return newClassInstance;
        }

        public String toString() {
            Object[] params = new Object[]{this.className, this.classLoader, new Boolean(this.loadedClass != null)};
            return ModelerCore.Util.getString(ModelerCore.Util.getString("ExtensionDescriptorImpl.ExtensionDescriptor___className,_classLoade,_isLoaded_7", params));
        }
    }
}

