/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ExtensionDescriptor;
import com.metamatrix.modeler.core.ExternalResourceDescriptor;
import com.metamatrix.modeler.core.MappingAdapterDescriptor;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.Configuration;
import com.metamatrix.modeler.internal.core.ExtensionDescriptorImpl;
import com.metamatrix.modeler.internal.core.ExternalResourceDescriptorImpl;
import com.metamatrix.modeler.internal.core.ExternalResourceSetDescriptorImpl;
import com.metamatrix.modeler.internal.core.MappingAdapterDescriptorImpl;
import com.metamatrix.modeler.internal.core.MetamodelDescriptorImpl;
import com.metamatrix.modeler.internal.core.MetamodelRootClassDescriptorImpl;
import com.metamatrix.modeler.internal.core.ValidationDescriptorImpl;
import com.metamatrix.modeler.internal.core.container.ResourceDescriptorImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class EclipseConfigurationBuilder {
    public static void build(Configuration config) {
        boolean addAspects = true;
        List descriptors = EclipseConfigurationBuilder.readMetamodelDescriptors(true);
        config.getMetamodelDescriptors().addAll(descriptors);
        List resourceDescriptors = EclipseConfigurationBuilder.readResourceDescriptors();
        config.getResourceDescriptors().addAll(resourceDescriptors);
        List validationDescriptors = EclipseConfigurationBuilder.readValidationDescriptors();
        config.getValidationDescriptors().addAll(validationDescriptors);
        List associationProviderDescriptors = EclipseConfigurationBuilder.readAssociationProviderDescriptors();
        config.getAssociationProviderDescriptors().addAll(associationProviderDescriptors);
        List modelObjectResolverDescriptors = EclipseConfigurationBuilder.readModelObjectResolverDescriptors();
        config.getMappingAdapterDescriptors().addAll(modelObjectResolverDescriptors);
        List datatypeManagerDescriptors = EclipseConfigurationBuilder.readDatatypeManagerDescriptors();
        config.getDatatypeManagerDescriptors().addAll(datatypeManagerDescriptors);
        List externalResourceDescriptors = EclipseConfigurationBuilder.readExternalResourceDescriptors();
        config.getExternalResourceDescriptors().addAll(externalResourceDescriptors);
        List externalResourceSetDescriptors = EclipseConfigurationBuilder.readExternalResourceSetDescriptors();
        config.getExternalResourceSetDescriptors().addAll(externalResourceSetDescriptors);
        List invocationFactoryHelperDescriptors = EclipseConfigurationBuilder.readInvocationFactoryHelperDescriptors();
        config.getInvocationFactoryHelpers().addAll(invocationFactoryHelperDescriptors);
        List resourceLoadOptionDescriptors = EclipseConfigurationBuilder.readResourceLoadOptionDescriptors();
        config.getResourceLoadOptions().addAll(resourceLoadOptionDescriptors);
    }

    public static List readModelObjectResolverDescriptors() {
        ArrayList<MappingAdapterDescriptor> result = new ArrayList<MappingAdapterDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.eobjectMatcherFactory");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            MappingAdapterDescriptor descriptor = EclipseConfigurationBuilder.createModelObjectResolverDescriptor(extension);
            result.add(descriptor);
        }
        return result;
    }

    public static List readDatatypeManagerDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.datatypeManager");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createDatatypeManagerDescriptor(extension);
            result.add(descriptor);
        }
        return result;
    }

    public static List readExternalResourceSetDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.externalResourceSet");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createExternalResourceSetDescriptor(extension);
            result.add(descriptor);
        }
        return result;
    }

    public static List readExternalResourceDescriptors() {
        ArrayList<ExternalResourceDescriptor> result = new ArrayList<ExternalResourceDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.externalResource");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            ExternalResourceDescriptor descriptor = EclipseConfigurationBuilder.createExternalResourceDescriptor(extension);
            result.add(descriptor);
        }
        Collections.sort(result, new ExternalResourceDescriptorComparator());
        return result;
    }

    public static List readAssociationProviderDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.associationProvider");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createAssociationProviderDescriptor(extension);
            result.add(descriptor);
        }
        return result;
    }

    public static List readValidationDescriptors() {
        ArrayList result = new ArrayList();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.modelValidation");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            result.addAll(EclipseConfigurationBuilder.createValidationDescriptor(extension));
        }
        return result;
    }

    public static List readInvocationFactoryHelperDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.invocationFactoryHelper");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createInvocationFactoryHelperDescriptor(extension);
            result.add(descriptor);
        }
        return result;
    }

    public static List readResourceLoadOptionDescriptors() {
        ArrayList<ExtensionDescriptor> result = new ArrayList<ExtensionDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.resourceLoadOptions");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            ExtensionDescriptor descriptor = EclipseConfigurationBuilder.createResourceLoadOptionDescriptor(extension);
            result.add(descriptor);
        }
        return result;
    }

    public static List readResourceDescriptors() {
        ArrayList<ResourceDescriptorImpl> result = new ArrayList<ResourceDescriptorImpl>();
        IExtensionPoint resourceFactoryExtension = Platform.getExtensionRegistry().getExtensionPoint("com.metamatrix.modeler.core", "resourceFactory");
        if (resourceFactoryExtension == null) {
            String extensionPointID = "com.metamatrix.modeler.core.resourceFactory";
            Assertion.isNotNull(resourceFactoryExtension, ModelerCore.Util.getString("EclipseConfigurationBuilder.Extension_point_not_defined", "com.metamatrix.modeler.core.resourceFactory"));
        }
        IExtension[] factoryExtensions = resourceFactoryExtension.getExtensions();
        for (int i2 = 0; i2 < factoryExtensions.length; ++i2) {
            IExtension factoryExtension = factoryExtensions[i2];
            String factoryExtensionID = factoryExtension.getUniqueIdentifier();
            boolean error = false;
            ResourceDescriptorImpl descriptor = new ResourceDescriptorImpl(factoryExtensionID);
            List fileExtensions = descriptor.getExtensions();
            List protocols = descriptor.getProtocols();
            IConfigurationElement[] elements = factoryExtension.getConfigurationElements();
            for (int j2 = 0; j2 < elements.length; ++j2) {
                String value;
                IConfigurationElement iConfigurationElement = elements[j2];
                if (iConfigurationElement.getName().equals("fileExtension")) {
                    value = iConfigurationElement.getValue();
                    if (value != null && value.trim().length() != 0) {
                        fileExtensions.add(value);
                    } else if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(2, ModelerCore.Util.getString("EclipseConfigurationBuilder.Ignoring_null_or_zero-length_file_extension_value_on_extension", factoryExtensionID));
                    }
                }
                if (iConfigurationElement.getName().equals("protocol")) {
                    value = iConfigurationElement.getValue();
                    if (value != null && value.trim().length() != 0) {
                        protocols.add(value);
                    } else if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(2, ModelerCore.Util.getString("EclipseConfigurationBuilder.Ignoring_null_or_zero-length_protocol_value_on_extension", factoryExtensionID));
                    }
                }
                if (!iConfigurationElement.getName().equals("class")) continue;
                String className = iConfigurationElement.getAttribute("name");
                if (className != null && className.trim().length() != 0) {
                    ClassLoader loader = factoryExtension.getDeclaringPluginDescriptor().getPluginClassLoader();
                    descriptor.setResourceFactoryClass(className, loader);
                    continue;
                }
                if (!ModelerCore.DEBUG) continue;
                ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.A_class_name_must_be_specified_on_extension", factoryExtensionID));
                error = true;
            }
            if (error) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static List readMetamodelDescriptors(boolean addAspects) {
        ArrayList<MetamodelDescriptor> result = new ArrayList<MetamodelDescriptor>();
        IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.metamodel");
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            MetamodelDescriptor descriptor = EclipseConfigurationBuilder.createMetamodelDescriptor(extension);
            result.add(descriptor);
        }
        if (addAspects) {
            List aspectExtensions = EclipseConfigurationBuilder.getMetamodelAspectExtensions();
            Iterator iter = aspectExtensions.iterator();
            while (iter.hasNext()) {
                IExtension extension = (IExtension)iter.next();
                Iterator descIter = result.iterator();
                while (descIter.hasNext()) {
                    MetamodelDescriptor descriptor = (MetamodelDescriptor)descIter.next();
                    EclipseConfigurationBuilder.addMetamodelAspect(descriptor, extension);
                }
            }
        }
        return result;
    }

    public static ExtensionDescriptor createAssociationProviderDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.associationProvider".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.associationProvider".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.associationProvider", uniqueId));
        }
        ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            if (elemName == null || !elemName.equals("providerClass")) continue;
            className = elem.getAttribute("name");
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, pluginClassLoader);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, pluginClassLoader};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_id,_classname,_classloader}_1", params));
        }
        return descriptor;
    }

    public static MappingAdapterDescriptor createModelObjectResolverDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.eobjectMatcherFactory".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.eobjectMatcherFactory".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.eobjectMatcherFactory", uniqueId));
        }
        ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            if (elemName == null || !elemName.equals("class")) continue;
            className = elem.getAttribute("name");
        }
        MappingAdapterDescriptorImpl descriptor = new MappingAdapterDescriptorImpl(extensionId, className, pluginClassLoader);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, pluginClassLoader};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ModelObjectResolverDescriptorImpl_instance", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createDatatypeManagerDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.datatypeManager".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.datatypeManager".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.datatypeManager", uniqueId));
        }
        ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            if (elemName == null || !elemName.equals("class")) continue;
            className = elem.getAttribute("name");
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, pluginClassLoader);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, pluginClassLoader};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_1", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createInvocationFactoryHelperDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.invocationFactoryHelper".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.invocationFactoryHelper".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.invocationFactoryHelper", uniqueId));
        }
        ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            if (elemName == null || !elemName.equals("class")) continue;
            className = elem.getAttribute("name");
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, pluginClassLoader);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, pluginClassLoader};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_1", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createResourceLoadOptionDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.resourceLoadOptions".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.resourceLoadOptions".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.resourceLoadOptions", uniqueId));
        }
        ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            if (elemName == null || !elemName.equals("class")) continue;
            className = elem.getAttribute("name");
        }
        ExtensionDescriptorImpl descriptor = new ExtensionDescriptorImpl(extensionId, className, pluginClassLoader);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, pluginClassLoader};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExtensionDescriptorImpl_instance_1", params));
        }
        return descriptor;
    }

    public static ExtensionDescriptor createExternalResourceSetDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.externalResourceSet".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.externalResourceSet".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.externalResourceSet", uniqueId));
        }
        ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
        Properties properties = new Properties();
        String extensionId = extension.getSimpleIdentifier();
        String className = null;
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            if (elemName == null) continue;
            if (elemName.equals("class")) {
                className = elem.getAttribute("name");
                continue;
            }
            if (!elemName.equals("properties")) continue;
            String[] propNames = elem.getAttributeNames();
            for (int i2 = 0; i2 < propNames.length; ++i2) {
                String name = propNames[i2];
                String value = elem.getAttribute(name);
                properties.setProperty(name, value);
            }
        }
        ExternalResourceSetDescriptorImpl descriptor = new ExternalResourceSetDescriptorImpl(extensionId, className, pluginClassLoader);
        descriptor.setProperties(properties);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            Object[] params = new Object[]{extensionId, className, pluginClassLoader};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExternalResourceSetDescriptorImpl_instance__id,_classname,_classloader_1", params));
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Set_ExternalResourceSetDescriptorImpl_properties_to_2", properties));
        }
        return descriptor;
    }

    public static ExternalResourceDescriptor createExternalResourceDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.externalResource".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.externalResource".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.externalResource", uniqueId));
        }
        ExternalResourceDescriptorImpl descriptor = new ExternalResourceDescriptorImpl();
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ExternalResourceDescriptorImpl_instance_1"));
        }
        String pluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
        descriptor.setPluginID(pluginId);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_plugin_ID_to_2", pluginId));
        }
        descriptor.setExtensionID(extension.getSimpleIdentifier());
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_extension_ID_to_3", extension.getSimpleIdentifier()));
        }
        Properties properties = new Properties();
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            String elemValue = elem.getValue();
            if (elemName == null) continue;
            if (elemName.equals("resourceName") && elemValue != null) {
                descriptor.setResourceName(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_name_to_4", elemValue));
                continue;
            }
            if (elemName.equals("resourceUrl") && elemValue != null) {
                descriptor.setResourceUrl(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_URL_to_5", elemValue));
                continue;
            }
            if (elemName.equals("internalUri") && elemValue != null) {
                descriptor.setInternalUri(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_URI_to_6", elemValue));
                continue;
            }
            if (elemName.equals("priority") && elemValue != null) {
                descriptor.setPriority(Integer.parseInt(elemValue));
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_priority_to_7", elemValue));
                continue;
            }
            if (!elemName.equals("properties")) continue;
            String[] propNames = elem.getAttributeNames();
            for (int i2 = 0; i2 < propNames.length; ++i2) {
                String name = propNames[i2];
                String value = elem.getAttribute(name);
                properties.setProperty(name, value);
            }
            descriptor.setProperties(properties);
        }
        if (descriptor.getResourceUrl() == null || descriptor.getResourceUrl().length() == 0) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_the_external_resource_URL_was_not_defined_in_the_extension_1", extension.getSimpleIdentifier()));
        }
        if (descriptor.getResourceName() == null || descriptor.getResourceName().length() == 0) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_the_external_resource_name_was_not_defined_in_the_extension_2", extension.getSimpleIdentifier()));
        }
        String resourceURL = null;
        try {
            URL installURL = extension.getDeclaringPluginDescriptor().getPlugin().getDescriptor().getInstallURL();
            resourceURL = Platform.asLocalURL(new URL(installURL, descriptor.getResourceUrl())).getFile();
            if (resourceURL == null || resourceURL.length() == 0) {
                ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Unable_to_create_an_absolute_path_to_the_resource_1", descriptor.getResourceUrl()));
                if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_external_resource_URL_to_5", descriptor.getResourceUrl()));
                }
            } else {
                descriptor.setResourceUrl(resourceURL);
            }
        }
        catch (Throwable t2) {
            ModelerCore.Util.log(4, t2, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_creating_local_URL_for_2", descriptor.getResourceUrl()));
        }
        String tempDirPath = null;
        try {
            tempDirPath = extension.getDeclaringPluginDescriptor().getPlugin().getStateLocation().toOSString();
            if (tempDirPath == null || tempDirPath.length() == 0) {
                ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Unable_to_create_an_absolute_path_to_the_data_directory_for_resource_1", descriptor.getResourceUrl()));
                if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_temporary_directory_path_to_1", tempDirPath));
                }
            } else {
                descriptor.setTempDirectoryPath(tempDirPath);
            }
        }
        catch (Throwable t3) {
            ModelerCore.Util.log(4, ModelerCore.Util.getString("EclipseConfigurationBuilder.Error_creating_the_absolute_path_to_the_data_directory_for_resource_2", descriptor.getResourceUrl()));
        }
        return descriptor;
    }

    public static List createValidationDescriptor(IExtension extension) {
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.modelValidation".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.modelValidation".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.modelValidation", uniqueId));
        }
        if (ModelerCore.DEBUG_VALIDATION) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_ValidationDescriptorImpl_instance_1"));
        }
        if (ModelerCore.DEBUG_VALIDATION) {
            Object[] params = new Object[]{extension.getSimpleIdentifier()};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_extension_ID_to", params));
        }
        IConfigurationElement[] elems = extension.getConfigurationElements();
        ArrayList<ValidationDescriptorImpl> descriptors = new ArrayList<ValidationDescriptorImpl>(elems.length);
        for (int j2 = 0; j2 < elems.length; ++j2) {
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            if (elemName == null || !elemName.equals("preference")) continue;
            String prefName = elem.getAttribute("name");
            String prefLabel = elem.getAttribute("label");
            String prefCategory = elem.getAttribute("category");
            String prefToolTip = elem.getAttribute("toolTip");
            String defaultValue = elem.getAttribute("default");
            if (prefName == null) continue;
            ValidationDescriptorImpl descriptor = new ValidationDescriptorImpl();
            descriptor.setExtensionID(extension.getSimpleIdentifier());
            descriptor.setPrefernceName(prefName);
            descriptor.setPrefernceLabel(prefLabel);
            descriptor.setPrefernceCategory(prefCategory);
            descriptor.setPrefernceToolTip(prefToolTip);
            descriptor.setDefaultOption(defaultValue);
            if (ModelerCore.DEBUG_VALIDATION) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_NAME_to", new Object[]{prefName}));
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_LABEL_to", new Object[]{prefLabel}));
                if (prefCategory != null) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_CATEGORY_to", new Object[]{prefCategory}));
                }
                if (prefToolTip != null) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_TOOLTIP_to", new Object[]{prefToolTip}));
                }
                if (defaultValue != null) {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Set_the_DEFAULT_OPTION_to_1") + new Object[]{defaultValue});
                }
            }
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public static MetamodelDescriptor createMetamodelDescriptor(IExtension extension) {
        Object[] params;
        String uniqueId;
        if (extension == null) {
            ArgCheck.isNotNull(extension, ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_reference_may_not_be_null_1"));
        }
        if (!"com.metamatrix.modeler.core.metamodel".equals(uniqueId = extension.getExtensionPointUniqueIdentifier())) {
            ArgCheck.isTrue("com.metamatrix.modeler.core.metamodel".equals(uniqueId), ModelerCore.Util.getString("EclipseConfigurationBuilder.The_IExtension_must_be_an_extension_for_the_point", "com.metamatrix.modeler.core.metamodel", uniqueId));
        }
        ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
        Properties properties = new Properties();
        MetamodelDescriptorImpl descriptor = new MetamodelDescriptorImpl();
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Created_new_MetamodelDescriptorImpl_instance_1"));
        }
        String pluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
        descriptor.setPluginID(pluginId);
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            params = new Object[]{pluginId};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_plugin_ID_to", params));
        }
        descriptor.setExtensionID(extension.getSimpleIdentifier());
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            params = new Object[]{extension.getSimpleIdentifier()};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_extension_ID_to", params));
        }
        descriptor.setName(extension.getLabel());
        if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
            params = new Object[]{extension.getLabel()};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_name_to", params));
        }
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            String className;
            Object[] params2;
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            String elemValue = elem.getValue();
            if (elemName == null) continue;
            if (elemName.equals("uri") && elemValue != null) {
                descriptor.setURI(elemValue);
                if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                    params2 = new Object[]{elemValue};
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_URI_to", params2));
                }
            }
            if (elemName.equals("alternateUri") && elemValue != null) {
                descriptor.addAlternateURI(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                params2 = new Object[]{elemValue};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Adding_alternate_URI_1", params2));
                continue;
            }
            if (elemName.equals("internalUri") && elemValue != null) {
                descriptor.setInternalURI(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                params2 = new Object[]{elemValue};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_internal_URI_to", params2));
                continue;
            }
            if (elemName.equals("namespacePrefix") && elemValue != null) {
                descriptor.setNamespacePrefix(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                params2 = new Object[]{elemValue};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_namespace_prefix_to", params2));
                continue;
            }
            if (elemName.equals("resource") && elemValue != null) {
                descriptor.setResourceURL(elemValue, pluginClassLoader);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                params2 = new Object[]{elemValue, pluginClassLoader};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_resource_URL_to,_and_the_resource_ClassLoader_to", params2));
                continue;
            }
            if (elemName.equals("factoryClass")) {
                className = elem.getAttribute("name");
                descriptor.setEFactoryClassLoader(className, pluginClassLoader);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                Object[] params3 = new Object[]{className, pluginClassLoader};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_EFactory_class_name_to,_and_the_ClassLoader_to", params3));
                continue;
            }
            if (elemName.equals("packageClass")) {
                className = elem.getAttribute("name");
                descriptor.setEPackageClassLoader(className, pluginClassLoader);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                Object[] params4 = new Object[]{className, pluginClassLoader};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_EPackage_class_name_to,_and_the_ClassLoader_to", params4));
                continue;
            }
            if (elemName.equals("adapterClass")) {
                className = elem.getAttribute("name");
                descriptor.setAdapterFactoryClassLoader(className, pluginClassLoader);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                Object[] params5 = new Object[]{className, pluginClassLoader};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Set_the_AdapterFactory_class_name_to,_and_the_ClassLoader_to", params5));
                continue;
            }
            if (elemName.equals("allowableModelType") && elemValue != null) {
                descriptor.addAllowableModelType(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                params2 = new Object[]{elemValue};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Adding_model_type_1", params2));
                continue;
            }
            if (elemName.equals("fileExtension") && elemValue != null) {
                descriptor.setFileExtension(elemValue);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                params2 = new Object[]{elemValue};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Setting_file_extension_to_1", params2));
                continue;
            }
            if (elemName.equals("rootEntityClass")) {
                className = elem.getAttribute("name");
                String maxOccurs = elem.getAttribute("maxOccurs");
                MetamodelRootClassDescriptorImpl rootDescriptor = new MetamodelRootClassDescriptorImpl(uniqueId, className, pluginClassLoader);
                rootDescriptor.setMaxOccurs(maxOccurs);
                descriptor.addRootClassDescriptor(rootDescriptor);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                Object[] params6 = new Object[]{className, pluginClassLoader};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Added_root_entity_class_name,_and_ClassLoader_1", params6));
                continue;
            }
            if (elemName.equals("properties")) {
                String[] propNames = elem.getAttributeNames();
                for (int i2 = 0; i2 < propNames.length; ++i2) {
                    String name = propNames[i2];
                    String value = elem.getAttribute(name);
                    properties.setProperty(name, value);
                }
                descriptor.setProperties(properties);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                Object[] params7 = new Object[]{properties};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.Set_metamodel_properties_to_2", params7));
                continue;
            }
            if (!elemName.equals("initializers")) continue;
            IConfigurationElement[] initializers = elem.getChildren();
            for (int i3 = 0; i3 < initializers.length; ++i3) {
                IConfigurationElement initializer = initializers[i3];
                String initializerTagName = initializer.getName();
                if (!initializerTagName.equals("initializer")) continue;
                String name = initializer.getAttribute("name");
                String desc = initializer.getAttribute("description");
                String className2 = initializer.getAttribute("class");
                descriptor.addModelInitializer(name, desc, className2, pluginClassLoader);
            }
        }
        return descriptor;
    }

    private static List getMetamodelAspectExtensions() {
        ArrayList extensions = new ArrayList();
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.umlDiagramAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.itemProviderAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.dependencyAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.validationAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.featureConstraintAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.sqlAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.relationshipAspect"), extensions);
        EclipseConfigurationBuilder.addExtensionsToList(PluginUtilities.getExtensions("com.metamatrix.modeler.core.importAspect"), extensions);
        return extensions;
    }

    private static void addExtensionsToList(IExtension[] extensions, List extensionList) {
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IExtension extension = extensions[i2];
            if (extensionList.contains(extension)) continue;
            extensionList.add(extension);
        }
    }

    private static void addMetamodelAspect(MetamodelDescriptor descriptor, IExtension extension) {
        if (EclipseConfigurationBuilder.validMetamodelAspect(descriptor, extension)) {
            ClassLoader pluginClassLoader = extension.getDeclaringPluginDescriptor().getPluginClassLoader();
            String uniqueExtensionPointID = extension.getExtensionPointUniqueIdentifier();
            IConfigurationElement[] elems = extension.getConfigurationElements();
            for (int j2 = 0; j2 < elems.length; ++j2) {
                IConfigurationElement elem = elems[j2];
                String elemName = elem.getName();
                if (!elemName.equals("factoryClass")) continue;
                String className = elem.getAttribute("name");
                ((MetamodelDescriptorImpl)descriptor).addMetamodelAspectClassLoader(uniqueExtensionPointID, className, pluginClassLoader);
                if (!ModelerCore.DEBUG_MODELER_CORE_INIT) continue;
                Object[] params = new Object[]{className, pluginClassLoader, uniqueExtensionPointID};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Added_the_MetamodelAspect,_ClassLoader,_extension_point_ID", params));
            }
        }
    }

    private static boolean validMetamodelAspect(MetamodelDescriptor descriptor, IExtension extension) {
        if (descriptor == null || extension == null) {
            return false;
        }
        String uniqueExtensionPointID = extension.getExtensionPointUniqueIdentifier();
        if (!(uniqueExtensionPointID.equals("com.metamatrix.modeler.core.umlDiagramAspect") || uniqueExtensionPointID.equals("com.metamatrix.modeler.core.itemProviderAspect") || uniqueExtensionPointID.equals("com.metamatrix.modeler.core.dependencyAspect") || uniqueExtensionPointID.equals("com.metamatrix.modeler.core.validationAspect") || uniqueExtensionPointID.equals("com.metamatrix.modeler.core.sqlAspect") || uniqueExtensionPointID.equals("com.metamatrix.modeler.core.relationshipAspect") || uniqueExtensionPointID.equals("com.metamatrix.modeler.core.importAspect") || uniqueExtensionPointID.equals("com.metamatrix.modeler.core.featureConstraintAspect"))) {
            return false;
        }
        IConfigurationElement[] elems = extension.getConfigurationElements();
        for (int j2 = 0; j2 < elems.length; ++j2) {
            String aspectMetamodelID;
            IConfigurationElement elem = elems[j2];
            String elemName = elem.getName();
            String elemValue = elem.getValue();
            if (!elemName.equals("metamodelExtensionID") || elemValue == null || (aspectMetamodelID = elemValue) == null || !aspectMetamodelID.equals(descriptor.getExtensionID())) continue;
            if (ModelerCore.DEBUG_MODELER_CORE_INIT) {
                Object[] params = new Object[]{descriptor.getExtensionID(), uniqueExtensionPointID};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EclipseConfigurationBuilder.DEBUG.__Found_valid_MetamodelAspect_IExtension_for_the_metamodel.__The_extension_point_ID", params));
            }
            return true;
        }
        return false;
    }

    private static class ExternalResourceDescriptorComparator
    implements Comparator {
        private ExternalResourceDescriptorComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            int value2;
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return 1;
            }
            if (obj1 != null && obj2 == null) {
                return -1;
            }
            ExternalResourceDescriptor descriptor1 = (ExternalResourceDescriptor)obj1;
            ExternalResourceDescriptor descriptor2 = (ExternalResourceDescriptor)obj2;
            int value1 = descriptor1.getPriority();
            if (value1 < (value2 = descriptor2.getPriority())) {
                return 1;
            }
            if (value1 > value2) {
                return -1;
            }
            return 0;
        }
    }
}

