/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StringNameValidator {
    private static final char UNDERSCORE_CHARACTER = '_';
    public static final char DEFAULT_REPLACEMENT_CHARACTER = '_';
    public static final int MAXIMUM_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_MAXIMUM_LENGTH = 255;
    public static final int DEFAULT_MINIMUM_LENGTH = 1;
    public static final boolean DEFAULT_CASE_SENSITIVE_NAME_COMPARISON = false;
    private static final Integer INTEGER_ONE = new Integer(1);
    private final int maximumLength;
    private final int minimumLength;
    private final boolean caseSensitive;
    private final char replacementCharacter;
    private final char[] invalidCharacters;

    public StringNameValidator(int minLength, int maxLength, boolean caseSensitive, char replacementCharacter, char[] invalidCharacters) {
        this.minimumLength = minLength < 0 ? 1 : minLength;
        this.maximumLength = maxLength < 0 ? Integer.MAX_VALUE : maxLength;
        this.caseSensitive = caseSensitive;
        this.replacementCharacter = replacementCharacter;
        this.invalidCharacters = invalidCharacters;
        if (this.minimumLength > this.maximumLength) {
            String msg = ModelerCore.Util.getString("StringNameValidator.The_minimum_length_may_not_exceed_the_maximum_length");
            throw new IllegalArgumentException(msg);
        }
    }

    public StringNameValidator(boolean caseSensitive) {
        this(1, 255, caseSensitive, '_', null);
    }

    public StringNameValidator(char[] invalidCharacters) {
        this(1, 255, false, '_', invalidCharacters);
    }

    public StringNameValidator(int maxLength, char[] invalidCharacters) {
        this(1, maxLength, false, '_', invalidCharacters);
    }

    public StringNameValidator(int minLength, int maxLength, char[] invalidCharacters) {
        this(minLength, maxLength, false, '_', invalidCharacters);
    }

    public StringNameValidator(int minLength, int maxLength, boolean caseSensitive, char replacementCharacter) {
        this(minLength, maxLength, caseSensitive, replacementCharacter, null);
    }

    public StringNameValidator(int minLength, int maxLength, boolean caseSensitive) {
        this(minLength, maxLength, caseSensitive, '_', null);
    }

    public StringNameValidator(int minLength, int maxLength) {
        this(minLength, maxLength, false, '_', null);
    }

    public StringNameValidator(int maxLength) {
        this(1, maxLength, false, '_', null);
    }

    public StringNameValidator() {
        this(1, 255, false, '_', null);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public char getReplacementCharacter() {
        return this.replacementCharacter;
    }

    public char[] getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public String checkNameLength(String name) {
        ArgCheck.isNotNull(name);
        int strLength = name.length();
        if (strLength < this.getMinimumLength()) {
            Object[] params = new Object[]{new Integer(this.getMinimumLength())};
            String msg = ModelerCore.Util.getString("StringNameValidator.MinLengthFailure", params);
            return msg;
        }
        if (strLength > this.getMaximumLength()) {
            Object[] params = new Object[]{new Integer(strLength), new Integer(this.getMaximumLength())};
            String msg = ModelerCore.Util.getString("StringNameValidator.The_name_length_({0})_is_longer_than_allowed_({1})", params);
            return msg;
        }
        return null;
    }

    public String checkNameCharacters(String name) {
        ArgCheck.isNotNull(name);
        StringCharacterIterator charIter = new StringCharacterIterator(name);
        char c2 = charIter.first();
        int index = 1;
        if (c2 != '\uffff') {
            if (!Character.isLetter(c2)) {
                Object[] params = new Object[]{new Character(c2)};
                String msg = ModelerCore.Util.getString("StringNameValidator.The_first_character_of_the_name_({0})_must_be_an_alphabetic_character", params);
                return msg;
            }
            if (!this.isValidCharacter(c2)) {
                Object[] params = new Object[]{new Character(c2)};
                String msg = ModelerCore.Util.getString("StringNameValidator.The_first_character_of_the_name_({0})_is_not_a_valid_character", params);
                return msg;
            }
            c2 = charIter.next();
            ++index;
        }
        while (c2 != '\uffff') {
            if (!Character.isUnicodeIdentifierPart(c2) && !Character.isLetterOrDigit(c2) && c2 != '_') {
                Object[] params = new Object[]{new Character(c2), new Integer(index)};
                String msg = ModelerCore.Util.getString("StringNameValidator.The_character___{0}___(at_position_{1})_is_not_allowed;_only_alphabetic,_digit_or_underscore", params);
                return msg;
            }
            if (!this.isValidCharacter(c2)) {
                Object[] params = new Object[]{new Character(c2), new Integer(index)};
                String msg = ModelerCore.Util.getString("StringNameValidator.The_character___{0}___(at_position_{1})_is_not_a_valid_character", params);
                return msg;
            }
            c2 = charIter.next();
            ++index;
        }
        return null;
    }

    protected boolean isValidCharacter(char c2) {
        if (this.getInvalidCharacters() == null) {
            return true;
        }
        for (int i2 = 0; i2 < this.getInvalidCharacters().length; ++i2) {
            if (this.getInvalidCharacters()[i2] != c2) continue;
            return false;
        }
        return true;
    }

    public boolean isValidName(String name) {
        String reasonInvalid = this.checkValidName(name);
        return reasonInvalid == null;
    }

    public String checkValidName(String name) {
        if (name == null) {
            String msg = ModelerCore.Util.getString("StringNameValidator.The_name_may_not_be_null");
            return msg;
        }
        String lengthMsg = this.checkNameLength(name);
        if (lengthMsg != null) {
            return lengthMsg;
        }
        String contentMsg = this.checkNameCharacters(name);
        if (contentMsg != null) {
            return contentMsg;
        }
        return null;
    }

    public String checkUniqueness(String name, EObject eObject, List siblings, int nameFeatureID) {
        ArgCheck.isNotNull(name);
        ArgCheck.isNotNull(eObject);
        ArgCheck.isNotNull(siblings);
        String eObjUri = eObject.eClass().getEPackage().getNsURI();
        Iterator iter = siblings.iterator();
        int matchCntr = 0;
        while (iter.hasNext()) {
            String siblingName;
            EStructuralFeature eFeature;
            EClass siblingClass;
            String siblingURI;
            EObject sibling = (EObject)iter.next();
            if (sibling == eObject || !eObjUri.equals(siblingURI = (siblingClass = sibling.eClass()).getEPackage().getNsURI()) || (eFeature = siblingClass.getEStructuralFeature(nameFeatureID)) == null || (siblingName = (String)sibling.eGet(eFeature)) == null || (!this.isCaseSensitive() || !siblingName.equals(name)) && (this.isCaseSensitive() || !siblingName.equalsIgnoreCase(name))) continue;
            ++matchCntr;
        }
        if (matchCntr != 0) {
            Object[] params = new Object[]{name, new Integer(matchCntr)};
            String msg = ModelerCore.Util.getString("StringNameValidator.The_name_{0}_is_the_same_as_{1}_other_objects_under_the_same_parent", (Object)params);
            return msg;
        }
        return null;
    }

    public Map getDuplicateNamesMap(List siblings, int nameFeatureID) {
        ArgCheck.isNotNull(siblings);
        Map siblingNameMap = this.getSiblingsNameFeatureMap(siblings, nameFeatureID);
        HashMap<EObject, Integer> objectCountMap = new HashMap<EObject, Integer>();
        ArrayList siblingEObjects = new ArrayList(siblingNameMap.keySet());
        int siblingSize = siblingEObjects.size();
        for (int i2 = 0; i2 < siblingSize; ++i2) {
            EObject siblingA = (EObject)siblingEObjects.get(i2);
            String siblingNameA = (String)siblingNameMap.get(siblingA);
            for (int j2 = i2 + 1; j2 < siblingSize; ++j2) {
                EObject siblingB = (EObject)siblingEObjects.get(j2);
                String siblingNameB = (String)siblingNameMap.get(siblingB);
                if ((!this.isCaseSensitive() || !siblingNameA.equals(siblingNameB)) && (this.isCaseSensitive() || !siblingNameA.equalsIgnoreCase(siblingNameB))) continue;
                Integer matchCnt1 = (Integer)objectCountMap.get(siblingA);
                Integer matchCnt2 = (Integer)objectCountMap.get(siblingB);
                matchCnt1 = matchCnt1 == null ? INTEGER_ONE : new Integer(matchCnt1 + 1);
                matchCnt2 = matchCnt2 == null ? INTEGER_ONE : new Integer(matchCnt2 + 1);
                objectCountMap.put(siblingA, matchCnt1);
                objectCountMap.put(siblingB, matchCnt2);
            }
        }
        return objectCountMap;
    }

    private Map getSiblingsNameFeatureMap(List siblings, int nameFeatureID) {
        int siblingSize = siblings.size();
        HashMap<EObject, String> siblingNameMap = new HashMap<EObject, String>();
        for (int i2 = 0; i2 < siblingSize; ++i2) {
            String siblingName;
            Object featureValue;
            EObject siblingEObject = (EObject)siblings.get(i2);
            EClass siblingClass = siblingEObject.eClass();
            EStructuralFeature eFeature = siblingClass.getEStructuralFeature(nameFeatureID);
            if (eFeature == null || (featureValue = siblingEObject.eGet(eFeature)) == null || !(featureValue instanceof String) || (siblingName = (String)featureValue) == null) continue;
            siblingNameMap.put(siblingEObject, siblingName);
        }
        return siblingNameMap;
    }

    public Map getDuplicateNamesMap(List features) {
        ArgCheck.isNotNull(features);
        HashMap<EStructuralFeature, Integer> objectCountMap = new HashMap<EStructuralFeature, Integer>();
        int featuresSize = features.size();
        for (int i2 = 0; i2 < featuresSize; ++i2) {
            EStructuralFeature eFeature1 = (EStructuralFeature)features.get(i2);
            if (eFeature1 == null) continue;
            String featureName1 = eFeature1.getName();
            for (int j2 = i2 + 1; j2 < featuresSize; ++j2) {
                String featureName2;
                EStructuralFeature eFeature2 = (EStructuralFeature)features.get(j2);
                if (eFeature2 == null || (featureName2 = eFeature2.getName()) == null || (!this.isCaseSensitive() || !featureName1.equals(featureName2)) && (this.isCaseSensitive() || !featureName1.equalsIgnoreCase(featureName2))) continue;
                Integer matchCnt1 = (Integer)objectCountMap.get(eFeature1);
                Integer matchCnt2 = (Integer)objectCountMap.get(eFeature2);
                matchCnt1 = matchCnt1 == null ? INTEGER_ONE : new Integer(matchCnt1 + 1);
                matchCnt2 = matchCnt2 == null ? INTEGER_ONE : new Integer(matchCnt2 + 1);
                objectCountMap.put(eFeature1, matchCnt1);
                objectCountMap.put(eFeature2, matchCnt2);
            }
        }
        return objectCountMap;
    }

    public String createValidName(String name) {
        return this.createValidName(name, false);
    }

    public String createValidName(String name, boolean performValidityCheck) {
        ArgCheck.isNotNull(name);
        if (performValidityCheck && this.isValidName(name)) {
            return null;
        }
        StringBuffer newName = new StringBuffer(name);
        boolean changed = false;
        int length = newName.length();
        int maxLength = this.getMaximumLength();
        int index = 0;
        while (index < length) {
            char c2 = newName.charAt(index);
            if (index == 0) {
                if (!Character.isLetter(c2) || !this.isValidCharacter(c2)) {
                    newName.deleteCharAt(index);
                    --length;
                    changed = true;
                    continue;
                }
                ++index;
                continue;
            }
            if (maxLength > 0 && length > maxLength) {
                length = maxLength;
                newName = new StringBuffer(newName.substring(0, maxLength));
                changed = true;
            }
            if (!Character.isLetterOrDigit(c2) && c2 != '_' || !this.isValidCharacter(c2)) {
                newName.setCharAt(index, this.getReplacementCharacter());
                ++index;
                changed = true;
                continue;
            }
            ++index;
        }
        if (changed) {
            if (newName.length() == 0) {
                newName.append('x');
            }
            return newName.toString();
        }
        return null;
    }

    public String createValidUniqueName(String name, Collection existingNames) {
        String result = null;
        String validName = this.createValidName(name);
        if (validName == null) {
            validName = name;
            result = null;
        } else {
            result = validName;
        }
        String uniqueName = this.createUniqueName(validName, existingNames);
        if (uniqueName != null) {
            result = uniqueName;
        }
        return result;
    }

    public String createUniqueName(String name, Collection existingNames) {
        String existingName;
        Iterator iter;
        ArgCheck.isNotNull(name);
        if (existingNames == null || existingNames.isEmpty()) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        if (this.isCaseSensitive()) {
            iter = existingNames.iterator();
            while (iter.hasNext()) {
                existingName = (String)iter.next();
                names.add(existingName);
            }
        } else {
            iter = existingNames.iterator();
            while (iter.hasNext()) {
                existingName = (String)iter.next();
                if (existingName == null) continue;
                names.add(existingName.toUpperCase());
            }
        }
        int roomForCounterChars = Math.max(0, this.getMaximumLength() - name.length());
        int counterToStartRemoving = (int)Math.pow(10.0, roomForCounterChars) - 1;
        String theName = name;
        boolean changed = false;
        int counter = 0;
        while (true) {
            String workingName;
            String string = workingName = this.isCaseSensitive() ? theName : theName.toUpperCase();
            if (!names.contains(workingName)) {
                if (changed) {
                    return theName;
                }
                return null;
            }
            int length = name.length();
            if (++counter > counterToStartRemoving) {
                int numCharsToRemove = 0;
                numCharsToRemove = counter - counterToStartRemoving < 10 ? 1 : (counter - counterToStartRemoving < 100 ? 2 : (counter - counterToStartRemoving < 1000 ? 3 : (counter - counterToStartRemoving < 10000 ? 4 : (counter - counterToStartRemoving < 100000 ? 5 : length + 1))));
                if (length > numCharsToRemove) {
                    theName = name.substring(0, length - numCharsToRemove) + counter;
                    changed = true;
                    continue;
                }
                Object[] params = new Object[]{name};
                String msg = ModelerCore.Util.getString("StringNameValidator.Unable_to_make_the_name_{0}_unique_within_the_limits_of_the_maximum_length", params);
                throw new ModelerCoreRuntimeException(msg);
            }
            changed = true;
            theName = name + counter;
        }
    }
}

