/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StringLengthRule
implements StructuralFeatureValidationRule {
    private int maxStringLength = 255;
    private final int featureID;

    public StringLengthRule(int maxStringLength, int featureID) {
        this.maxStringLength = maxStringLength;
        this.featureID = featureID;
    }

    public StringLengthRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (value == null) {
            return;
        }
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (!(value instanceof String) || value == null) {
            return;
        }
        String name = (String)value;
        ValidationResultImpl result = new ValidationResultImpl(eObject);
        CoreValidationRulesUtil.validateStringLength(result, this.maxStringLength, name);
        context.addResult(result);
    }
}

