/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceInScopeValidationRule
implements StructuralFeatureValidationRule {
    public void validate(EStructuralFeature theStructuralFeature, EObject theObject, Object theValue, ValidationContext theContext) {
        if (theStructuralFeature instanceof EReference && theValue != null) {
            if (theValue instanceof EObject) {
                this.validateReferenceValue(theStructuralFeature, theObject, (EObject)theValue, theContext);
            } else if (theValue instanceof Collection) {
                Collection theValues = (Collection)theValue;
                Iterator iter = theValues.iterator();
                while (iter.hasNext()) {
                    EObject value = (EObject)iter.next();
                    this.validateReferenceValue(theStructuralFeature, theObject, value, theContext);
                }
            }
        }
    }

    private void validateReferenceValue(EStructuralFeature theStructuralFeature, EObject theObject, EObject theValue, ValidationContext theContext) {
        if (theValue != null) {
            Resource resource = theValue.eResource();
            if (resource != null && theObject.eResource().equals(resource)) {
                return;
            }
            if (resource == null && theValue.eIsProxy()) {
                Container container = ModelerCore.getContainer(theObject);
                URI valueURI = ((InternalEObject)theValue).eProxyURI().trimFragment();
                if (valueURI.isRelative() && valueURI.hasRelativePath()) {
                    URI objectURI = theObject.eResource().getURI();
                    URI resolvedURI = valueURI.resolve(objectURI);
                    resource = container.getResource(resolvedURI, false);
                }
                if (resource == null) {
                    resource = ModelerCore.getModelEditor().findResource(container, theValue);
                }
            }
            if (EcorePackage.eINSTANCE.getEPackage_EFactoryInstance() == theStructuralFeature) {
                return;
            }
            if (resource == null) {
                String uri = theValue.eIsProxy() ? ((InternalEObject)theValue).eProxyURI().trimFragment().toString() : theValue.toString();
                String msg = ModelerCore.Util.getString(I18nUtil.getPropertyPrefix(this) + "unresolvedReference", uri);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                ValidationResultImpl result = new ValidationResultImpl(theObject);
                result.addProblem(problem);
                theContext.addResult(result);
            } else {
                if (WorkspaceResourceFinderUtil.isGlobalResource(resource.getURI().toString())) {
                    return;
                }
                Resource[] validResources = theContext.getResourcesInScope();
                if (validResources.length > 0) {
                    boolean valid = false;
                    for (int i2 = 0; i2 < validResources.length; ++i2) {
                        if (!validResources[i2].equals(resource)) continue;
                        valid = true;
                        break;
                    }
                    if (!valid) {
                        String wsUri = WorkspaceResourceFinderUtil.getWorkspaceUri(resource);
                        String uri = wsUri != null ? wsUri : resource.getURI().toString();
                        String msg = ModelerCore.Util.getString(I18nUtil.getPropertyPrefix(this) + "resourceOutOfScope", uri);
                        ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                        ValidationResultImpl result = new ValidationResultImpl(theObject);
                        result.addProblem(problem);
                        theContext.addResult(result);
                    }
                }
            }
        }
    }
}

