/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.validation.ResourceValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;

public class EmfResourceValidationRule
implements ResourceValidationRule {
    public void validate(Resource resource, ValidationContext context) {
        ArgCheck.isNotNull(resource);
        ArgCheck.isNotNull(context);
        if (resource instanceof XSDResourceImpl) {
            return;
        }
        ModelContents contents = new ModelContents(resource);
        ModelAnnotation annotation = contents.getModelAnnotation();
        if (annotation != null) {
            ValidationResultImpl result = new ValidationResultImpl(annotation);
            EList errors = resource.getErrors();
            HashSet<String> messages = new HashSet<String>();
            if (!errors.isEmpty()) {
                Iterator errIter = errors.iterator();
                while (errIter.hasNext()) {
                    Resource.Diagnostic errDiagnostic = (Resource.Diagnostic)errIter.next();
                    String diagMessage = errDiagnostic.getMessage();
                    if (messages.contains(diagMessage)) continue;
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, errDiagnostic.getMessage());
                    result.addProblem(problem);
                    messages.add(diagMessage);
                }
            } else {
                EList warnings = resource.getWarnings();
                Iterator warnIter = warnings.iterator();
                while (warnIter.hasNext()) {
                    Resource.Diagnostic warnDiagnostic = (Resource.Diagnostic)warnIter.next();
                    String diagMessage = warnDiagnostic.getMessage();
                    if (messages.contains(diagMessage)) continue;
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, warnDiagnostic.getMessage());
                    result.addProblem(problem);
                    messages.add(diagMessage);
                }
            }
            if (result.hasProblems()) {
                context.addResult(result);
            }
        }
    }
}

