/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelStatisticsVisitor;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class PrimaryMetamodelStatisticsVisitor
extends ModelStatisticsVisitor {
    private final Map resourceToPrimaryMetamodelUri = new HashMap();
    private static final String NO_PACKAGE_FOUND_URI = "";

    public boolean visit(EObject object) throws ModelerCoreException {
        Resource resource;
        if (object != null && (resource = object.eResource()) != null) {
            String metamodelUri;
            String primaryMetamodelUri = (String)this.resourceToPrimaryMetamodelUri.get(resource);
            if (primaryMetamodelUri == null) {
                ModelAnnotation modelAnn;
                if (resource instanceof EmfResource && (modelAnn = ((EmfResource)resource).getModelAnnotation()) != null) {
                    primaryMetamodelUri = modelAnn.getPrimaryMetamodelUri();
                }
                if (primaryMetamodelUri == null) {
                    primaryMetamodelUri = NO_PACKAGE_FOUND_URI;
                }
                this.resourceToPrimaryMetamodelUri.put(resource, primaryMetamodelUri);
            }
            if (primaryMetamodelUri != NO_PACKAGE_FOUND_URI && !primaryMetamodelUri.equals(metamodelUri = object.eClass().getEPackage().getNsURI())) {
                return true;
            }
        }
        return super.visit(object);
    }

    public void clear() {
        super.clear();
        this.resourceToPrimaryMetamodelUri.clear();
    }
}

