/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.INewModelObjectHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public abstract class NewModelObjectHelperManager {
    private static final String ID = "com.metamatrix.modeler.core.newModelObjectHelper";
    private static final String CLASS = "class";
    private static final String CLASSNAME = "name";
    private static List helpersCache;
    private static boolean helpersLoaded;

    public static INewModelObjectHelper[] getHelpers(Object newObject) {
        ArgCheck.isNotNull(newObject);
        HashSet<INewModelObjectHelper> helpers = new HashSet<INewModelObjectHelper>();
        if (!helpersLoaded) {
            NewModelObjectHelperManager.loadHelperExtensions();
        }
        if (helpersCache != null) {
            INewModelObjectHelper nextHelper = null;
            Iterator iter = helpersCache.iterator();
            while (iter.hasNext()) {
                nextHelper = (INewModelObjectHelper)iter.next();
                if (!nextHelper.canHelpCreate(newObject)) continue;
                helpers.add(nextHelper);
            }
        }
        return helpers.toArray(new INewModelObjectHelper[helpers.size()]);
    }

    private static void loadHelperExtensions() {
        helpersCache = new ArrayList();
        helpersLoaded = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i2 = 0; i2 < extensions.length; ++i2) {
            IConfigurationElement[] elements = extensions[i2].getConfigurationElements();
            try {
                for (int j2 = 0; j2 < elements.length; ++j2) {
                    Object helper;
                    if (!elements[j2].getName().equals(CLASS) || !((helper = elements[j2].createExecutableExtension(CLASSNAME)) instanceof INewModelObjectHelper)) continue;
                    helpersCache.add(helper);
                }
                continue;
            }
            catch (Exception e2) {
                String message = ModelerCore.Util.getString("NewModelObjectHelperManager.loadHelperExtensionsErrorMessage", extensions[i2].getUniqueIdentifier());
                ModelerCore.Util.log(4, e2, message);
            }
        }
    }

    public static boolean helpCreate(Object newObject, Map properties) throws ModelerCoreException {
        ArgCheck.isNotNull(newObject);
        boolean canUndo = true;
        INewModelObjectHelper[] helpers = NewModelObjectHelperManager.getHelpers(newObject);
        boolean undoHelp = true;
        for (int i2 = 0; i2 < helpers.length; ++i2) {
            undoHelp = helpers[i2].helpCreate(newObject, properties);
            if (undoHelp || !canUndo) continue;
            canUndo = false;
        }
        return canUndo;
    }

    static {
        helpersLoaded = false;
    }
}

