/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelStatistics;
import com.metamatrix.modeler.core.util.ModelVisitor;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelStatisticsVisitor
implements ModelVisitor {
    private final ModelStatistics stats = new ModelStatistics();

    public ModelStatistics getModelStatistics() {
        return this.stats;
    }

    public Set getEClassesFound() {
        return this.stats.getEClasses();
    }

    public int getCount(EClass metaclass) {
        return this.stats.getCount(metaclass);
    }

    public int getResourceCount() {
        return this.stats.getResourceCount();
    }

    public void clear() {
        this.stats.clear();
    }

    public boolean visit(EObject object) throws ModelerCoreException {
        if (object == null) {
            return false;
        }
        EClass metaclass = object.eClass();
        this.stats.add(metaclass, 1);
        return true;
    }

    public boolean visit(Resource resource) throws ModelerCoreException {
        if (resource == null) {
            return false;
        }
        this.stats.addResourceCount(1);
        return true;
    }
}

