/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class SqlStringConverter {
    public static final int UUID_STRING_LENGTH = 43;
    private static final List SYSTEM_RESOURCES = Arrays.asList(ModelerCore.getSystemVdbResources());

    public static String convertUUIDsToFullNames(String uuidString, Collection eResources) {
        if (StringUtil.isEmpty(uuidString)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int index = uuidString.indexOf("mmuuid");
        if (index == -1) {
            return uuidString;
        }
        sb.append(uuidString.substring(0, index));
        while (index != -1) {
            String id = null;
            try {
                id = uuidString.substring(index, index + 43);
                ObjectID uuid = IDGenerator.getInstance().stringToObject(id, "mmuuid");
                EObject obj = SqlStringConverter.findEObjectInResourceSet(((Object)uuid).toString(), eResources);
                if (obj != null) {
                    SqlAspect aspect = AspectManager.getSqlAspect(obj);
                    String name = null;
                    if (aspect != null && !StringUtil.isEmpty(name = index > 0 && uuidString.charAt(index - 1) == '.' ? aspect.getName(obj) : aspect.getFullName(obj))) {
                        sb.append(name);
                    }
                } else {
                    sb.append(id);
                    String msg = ModelerCore.Util.getString("SqlStringConverter.unable_to_find_eobject_with_uuid", id);
                    ModelerCore.Util.log(4, msg);
                }
                int nextIndex = uuidString.indexOf("mmuuid", index + 43);
                if (nextIndex == -1) {
                    sb.append(uuidString.substring(index + 43));
                    break;
                }
                sb.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
            catch (InvalidIDException e2) {
                ModelerCore.Util.log(e2);
                sb.append(id);
                int nextIndex = uuidString.indexOf("mmuuid", index + 43);
                sb.append(uuidString.substring(index + 43, nextIndex));
                index = nextIndex;
            }
        }
        return sb.toString();
    }

    private static EObject findEObjectInResourceSet(String uuid, Collection eResources) {
        Iterator iter = eResources.iterator();
        while (iter.hasNext()) {
            EObject eObj;
            Resource resource = (Resource)iter.next();
            if (!(resource instanceof EmfResource)) continue;
            if (!resource.isLoaded()) {
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException e2) {
                    ModelerCore.Util.log(4, e2.getLocalizedMessage());
                }
            }
            if ((eObj = resource.getEObject(uuid)) == null) continue;
            return eObj;
        }
        return SqlStringConverter.findEobjectInSystemResources(uuid);
    }

    private static EObject findEobjectInSystemResources(String uuid) {
        Iterator iter = SYSTEM_RESOURCES.iterator();
        while (iter.hasNext()) {
            EObject eObj;
            Resource resource = (Resource)iter.next();
            if (!(resource instanceof EmfResource) || (eObj = resource.getEObject(uuid)) == null) continue;
            return eObj;
        }
        return null;
    }
}

