/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.refactor.ResourceStatus;
import com.metamatrix.modeler.core.search.runtime.ResourceImportRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;

public class ResourceStatusList {
    Collection statusList;
    Collection problemList;
    Collection resourceList;
    Collection importedResourceList;
    int highestSeverity = 0;

    public ResourceStatusList(Collection c2) {
        this(c2, 4);
    }

    public ResourceStatusList(Collection c2, int readOnlySeverity) {
        this.statusList = new ArrayList(c2.size());
        this.problemList = new ArrayList(c2.size());
        this.resourceList = new ArrayList(c2.size());
        this.importedResourceList = new ArrayList(c2.size());
        Iterator iter = c2.iterator();
        while (iter.hasNext()) {
            Object o2 = iter.next();
            IResource resource = null;
            if (o2 instanceof IResource) {
                resource = (IResource)o2;
                if (o2 instanceof IFile) {
                    this.importedResourceList.add(o2);
                }
            } else if (o2 instanceof ResourceImportRecord) {
                ResourceImportRecord record = (ResourceImportRecord)o2;
                Path path = new Path(record.getPath());
                resource = ModelerCore.getWorkspace().getRoot().getFile(path);
                path = new Path(record.getImportedPath());
                this.importedResourceList.add(ModelerCore.getWorkspace().getRoot().getFile(path));
            }
            if (resource == null) continue;
            this.resourceList.add(resource);
            ResourceStatus status = new ResourceStatus(readOnlySeverity, resource);
            this.statusList.add(status);
            if (status.isOK()) continue;
            this.problemList.add(status);
            if (status.getSeverity() <= this.highestSeverity) continue;
            this.highestSeverity = status.getSeverity();
        }
    }

    public Collection getStatusList() {
        return this.statusList;
    }

    public Collection getResourceList() {
        return this.resourceList;
    }

    public Collection getImportedResourceList() {
        return this.importedResourceList;
    }

    public Collection getProblems() {
        return this.problemList;
    }

    public int getHighestSeverity() {
        return this.highestSeverity;
    }
}

