/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Status;

public class ResourceStatus
extends Status {
    private static final int RESOURCE_OKAY = 2000;
    private static final int RESOURCE_READONLY = 2001;
    private static final int RESOURCE_PROJECT_CLOSED = 2002;
    private static final String PID = "com.metamatrix.modeler.core";
    private IResource resource;

    public ResourceStatus(IResource resource) {
        this(4, resource);
    }

    public ResourceStatus(int readOnlySeverity, IResource resource) {
        super(0, PID, 2000, "", null);
        this.resource = resource;
        if (ModelUtil.isIResourceReadOnly(resource)) {
            this.setSeverity(readOnlySeverity);
            this.setMessage(ModelerCore.Util.getString("ResourceStatus.read_only_resource", resource.getFullPath()));
            this.setCode(2001);
        } else if (!resource.getProject().isOpen()) {
            this.setSeverity(4);
            this.setMessage(ModelerCore.Util.getString("ResourceStatus.closed_project", resource.getFullPath()));
            this.setCode(2002);
        }
    }

    public IResource getResource() {
        return this.resource;
    }
}

