/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.refactor.ModelResourceCollectorVisitor;
import com.metamatrix.modeler.core.refactor.ResourceRefactorCommand;
import com.metamatrix.modeler.core.workspace.ModelResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ResourceMoveCommand
extends ResourceRefactorCommand {
    public static final int ERROR_MISSING_CONTAINER = 1101;
    public static final int ERROR_MOVING_PROJECT = 1102;
    public static final int ERROR_PROJECT_NATURE = 1103;
    public static final int EXCEPTION_PROJECT_NATURE = 1104;
    public static final int ERROR_SUBFOLDER_MOVE = 1105;
    public static final int ERROR_READONLY_RESOURCES = 1106;
    public static final int EXCEPTION_DURING_MOVE = 1107;
    public static final int EXCEPTION_REBUILDING_MODEL_IMPORTS = 1108;
    public static final int ERROR_SAME_CONTAINER = 1109;
    public static final int ERROR_ALREADY_EXISTS_IN_CONTAINER = 1110;
    public static final int ERROR_PROJECT_CLOSED = 1111;
    private IContainer destination;
    private IStatus currentStatus;
    private IPath pathAfterMove;
    private Map pathMap;
    private Map undoMap;

    public ResourceMoveCommand() {
        super(ModelerCore.Util.getString("ResourceMoveCommand.label"));
    }

    public void setDestination(IContainer destination) {
        this.destination = destination;
    }

    private void checkStatus() {
        if (this.destination == null) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.No_destination_has_been_selected");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1101, msg, null);
            return;
        }
        if (this.getResource() instanceof IProject) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Cannot_move_project");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1102, msg, null);
            return;
        }
        if (this.destination instanceof IProject && !((IProject)this.destination).isOpen()) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Cannot_move_to_closed_project");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1111, msg, null);
            return;
        }
        try {
            if (this.destination.getProject().getNature("com.metamatrix.modeler.core.modelNature") == null) {
                String msg = ModelerCore.Util.getString("ResourceMoveCommand.Cannot_move_to_non_model_project");
                this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1103, msg, null);
                return;
            }
        }
        catch (CoreException e2) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Cannot_determine_project_nature");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1104, msg, e2);
            return;
        }
        if (this.getResource().getParent().equals(this.destination)) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Same_container");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1109, msg, null);
            return;
        }
        if (this.getResource() instanceof IFolder && this.isSubfolder()) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Cannot_move_folder_inside_itself");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1105, msg, null);
            return;
        }
        if (this.destinationChildNameClash()) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Same_name_in_container");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 1110, msg, null);
            return;
        }
        Object[] params = new Object[]{this.getResource().toString()};
        String msg = ModelerCore.Util.getString("ResourceMoveCommand.Ready_to_move", params);
        this.currentStatus = new Status(0, "com.metamatrix.modeler.core", 1000, msg, null);
    }

    protected IStatus getCanExecuteStatus() {
        this.checkStatus();
        return this.currentStatus;
    }

    private boolean isSubfolder() {
        boolean result = false;
        String destinationPath = ((Object)this.destination.getFullPath()).toString();
        if (destinationPath.equals(((Object)this.getResource().getFullPath()).toString())) {
            result = true;
        } else {
            String moveTargetPath = ((Object)this.getResource().getFullPath()).toString() + '/';
            result = destinationPath.startsWith(moveTargetPath);
        }
        return result;
    }

    protected IStatus modifyResource(IResource resource, IProgressMonitor monitor) {
        this.pathMap = new HashMap();
        this.undoMap = new HashMap();
        return this.modifyResource(resource, this.destination, this.pathMap, this.undoMap, monitor);
    }

    private IStatus modifyResource(IResource resource, IContainer targetContainer, Map preToPostPathMap, Map postToPrePathMap, IProgressMonitor monitor) {
        IResource[] resources = new IResource[]{resource};
        try {
            IStatus result;
            resource.getLocation();
            ModelResourceCollectorVisitor preMoveVisitor = new ModelResourceCollectorVisitor();
            resource.accept(preMoveVisitor);
            ArrayList<String> preMoveList = new ArrayList<String>(preMoveVisitor.getResources().size());
            Iterator iter = preMoveVisitor.getResources().iterator();
            while (iter.hasNext()) {
                preMoveList.add(((Object)((IResource)iter.next()).getFullPath().makeAbsolute()).toString());
            }
            this.unloadModelResources(resource);
            ModelerCore.getWorkspace().move(resources, targetContainer.getFullPath(), true, monitor);
            String newPathName = ((Object)targetContainer.getFullPath()).toString() + '/' + resource.getName();
            this.pathAfterMove = new Path(newPathName);
            IResource movedResource = resource.getWorkspace().getRoot().findMember(this.pathAfterMove);
            super.setModifiedResource(movedResource);
            ModelResourceCollectorVisitor postMoveVisitor = new ModelResourceCollectorVisitor();
            movedResource.accept(postMoveVisitor);
            ArrayList<String> postMoveList = new ArrayList<String>(postMoveVisitor.getResources().size());
            Iterator iter2 = postMoveVisitor.getResources().iterator();
            while (iter2.hasNext()) {
                postMoveList.add(((Object)((IResource)iter2.next()).getFullPath().makeAbsolute()).toString());
            }
            preToPostPathMap.clear();
            postToPrePathMap.clear();
            if (preMoveList.size() == postMoveList.size()) {
                Iterator preIter = preMoveList.iterator();
                Iterator postIter = postMoveList.iterator();
                while (preIter.hasNext()) {
                    Object pre = preIter.next();
                    Object post = postIter.next();
                    preToPostPathMap.put(pre, post);
                    postToPrePathMap.put(post, pre);
                }
            }
            if ((result = this.refactorModifiedResources(monitor, this.getModifiedResource(), preToPostPathMap)) != null && result.getSeverity() == 4) {
                return result;
            }
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Move_succeeded");
            return new Status(0, "com.metamatrix.modeler.core", 1001, msg, null);
        }
        catch (CoreException e2) {
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Move_failed");
            return new Status(4, "com.metamatrix.modeler.core", 1107, msg, e2);
        }
    }

    protected IStatus refactorModifiedResources(IProgressMonitor monitor, IResource resource, Map refactoredPaths) {
        ArrayList<Status> errorList = new ArrayList<Status>();
        int severity = 0;
        try {
            String msg;
            ModelResource mResource;
            IFile iFile;
            ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
            resource.accept(visitor);
            Iterator iter = visitor.getResources().iterator();
            while (iter.hasNext()) {
                iFile = (IFile)iter.next();
                mResource = ModelerCore.getModelEditor().findModelResource(iFile);
                if (mResource == null) {
                    mResource = ModelerCore.create(iFile);
                }
                if (mResource != null) {
                    mResource.save(null, false);
                    super.buildIndexes(monitor, iFile);
                    continue;
                }
                if (severity < 2) {
                    severity = 2;
                }
                msg = ModelerCore.Util.getString("ResourceRefactorCommand.Model_resource_not_in_ws", iFile.getName());
                errorList.add(new Status(2, "com.metamatrix.modeler.core", 1101, msg, null));
            }
            iter = visitor.getResources().iterator();
            while (iter.hasNext()) {
                iFile = (IFile)iter.next();
                mResource = ModelerCore.getModelEditor().findModelResource(iFile);
                if (mResource != null) {
                    super.rebuildImports(mResource, monitor, refactoredPaths);
                    mResource.save(null, false);
                    mResource.close();
                    continue;
                }
                if (severity < 2) {
                    severity = 2;
                }
                msg = ModelerCore.Util.getString("ResourceRefactorCommand.Rebuild_model_imports_complete");
                errorList.add(new Status(2, "com.metamatrix.modeler.core", 1101, msg, null));
            }
        }
        catch (Exception e2) {
            severity = 4;
            String msg = ModelerCore.Util.getString("ResourceMoveCommand.Exception_refactoring_external_references_for_resource_0_1", resource);
            errorList.add(new Status(4, "com.metamatrix.modeler.core", 1102, msg, e2));
        }
        String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Execution_complete");
        return new MultiStatus("com.metamatrix.modeler.core", 1103, errorList.toArray(EMPTY_ISTATUS), msg, null);
    }

    protected IStatus undoResourceModification(IProgressMonitor monitor) {
        IContainer targetContainer = super.getResource().getParent();
        return this.modifyResource(super.getModifiedResource(), targetContainer, this.pathMap, this.undoMap, monitor);
    }

    protected IStatus redoResourceModification(IProgressMonitor monitor) {
        IContainer targetContainer = this.destination;
        return this.modifyResource(super.getResource(), targetContainer, this.pathMap, this.undoMap, monitor);
    }

    public String getLabel() {
        return ModelerCore.Util.getString("ResourceMoveCommand.move_label", this.getResource().getName());
    }

    public String getDescription() {
        Object[] params = new Object[]{this.getResource().getName(), this.destination.getFullPath()};
        return ModelerCore.Util.getString("ResourceMoveCommand.move_description", params);
    }

    private boolean destinationChildNameClash() {
        String destinationPath = ((Object)this.destination.getFullPath()).toString();
        String proposedPath = destinationPath + '/' + this.getResource().getName();
        IWorkspaceRoot workspaceRoot = this.getResource().getWorkspace().getRoot();
        boolean result = workspaceRoot.findMember(proposedPath) != null;
        return result;
    }

    protected Map getMovedResourcePathMap(boolean isUndo) {
        if (isUndo) {
            return this.undoMap;
        }
        return this.pathMap;
    }
}

