/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.metamodels.core.util.ModelImportComparator;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.ResourceFinder;
import com.metamatrix.modeler.core.refactor.ExternalReferenceVisitor;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommandHelper;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class OrganizeImportCommandHelperNonXsd
extends OrganizeImportCommandHelper {
    protected OrganizeImportCommandHelperNonXsd() {
    }

    protected IStatus execute(IProgressMonitor monitor) {
        return this.process(monitor);
    }

    private IStatus process(IProgressMonitor monitor) {
        LinkedList problems = new LinkedList();
        Resource eResource = this.getResource();
        ModelAnnotation modelAnnot = this.getModelAnnotation(eResource);
        this.modelImports.clear();
        HashSet newImports = new HashSet(this.modelImports.size());
        this.buildAllImportsForExternalRef(eResource, problems, newImports, monitor);
        this.modelImports.addAll(newImports);
        this.updateImport(modelAnnot);
        IStatus resultStatus = this.createFinalStatus(problems);
        return resultStatus;
    }

    private void clearExistingImports(ModelAnnotation modelAnnot) {
        ArrayList existingImportList = new ArrayList(modelAnnot.getModelImports());
        try {
            ModelerCore.getModelEditor().removeValue(modelAnnot, existingImportList, modelAnnot.getModelImports());
        }
        catch (ModelerCoreException err) {
            ModelerCore.Util.log(err);
        }
    }

    private void updateImport(ModelAnnotation modelAnnot) {
        if (modelAnnot != null) {
            this.clearExistingImports(modelAnnot);
            Iterator iterator = new ArrayList(modelAnnot.getModelImports()).iterator();
            while (iterator.hasNext()) {
                ModelImport modelImport = (ModelImport)iterator.next();
                modelImport.setModel(null);
            }
            Collections.sort(this.modelImports, new ModelImportComparator());
            Iterator newIter = new ArrayList(this.modelImports).iterator();
            while (newIter.hasNext()) {
                ModelImport modelImport = (ModelImport)newIter.next();
                try {
                    ModelerCore.getModelEditor().addValue(modelAnnot, modelImport, modelAnnot.getModelImports());
                }
                catch (ModelerCoreException e1) {
                    ModelerCore.Util.log(e1);
                }
            }
            this.getResource().setModified(true);
        }
    }

    private void buildAllImportsForExternalRef(Resource eResource, List problems, Set newImports, IProgressMonitor monitor) {
        ExternalReferenceVisitor visitor = this.processExternalResourcesReferences(eResource, problems);
        Collection externRefList = visitor.getExternalReferences();
        ModelAnnotation modelAnnot = this.getModelAnnotation(eResource);
        HashSet<String> existingImportLocations = new HashSet<String>(modelAnnot.getModelImports().size());
        Iterator iterator = modelAnnot.getModelImports().iterator();
        while (iterator.hasNext()) {
            ModelImport existingImport = (ModelImport)iterator.next();
            existingImportLocations.add(existingImport.getModelLocation());
        }
        Iterator iter = externRefList.iterator();
        while (iter.hasNext()) {
            ExternalReferenceVisitor.ExternalReferences externalRefs = (ExternalReferenceVisitor.ExternalReferences)iter.next();
            URI externalUri = externalRefs.getResourceUri();
            Assertion.isNotNull(externalUri);
            if (externalUri.equals(eResource.getURI())) continue;
            try {
                ModelImport modelImport = this.createModelImport(eResource, externalRefs, problems, monitor);
                if (modelImport == null) continue;
                if (!this.containsImport(newImports, modelImport)) {
                    newImports.add(modelImport);
                }
                if (existingImportLocations.contains(modelImport.getModelLocation())) continue;
                this.adjustReferences(eResource, externalRefs, modelImport);
                eResource.setModified(true);
            }
            catch (Throwable t2) {
                Object[] params = new Object[]{URI.decode(externalUri.toString())};
                String msg = ModelerCore.Util.getString("OrganizeImportCommand.Error_while_building_import", params);
                problems.add(new Status(4, "com.metamatrix.modeler.core", 1009, msg, t2));
            }
        }
    }

    private boolean containsImport(Collection importCollection, ModelImport modelImport) {
        String modelImportUUID = modelImport.getUuid();
        String modelImportLoc = modelImport.getModelLocation();
        Iterator i2 = importCollection.iterator();
        while (i2.hasNext()) {
            ModelImport mi = (ModelImport)i2.next();
            if (modelImportUUID != null && modelImportUUID.equals(mi.getUuid())) {
                return true;
            }
            if (modelImportLoc == null || !modelImportLoc.equals(mi.getModelLocation())) continue;
            return true;
        }
        return false;
    }

    private ExternalReferenceVisitor processExternalResourcesReferences(Resource eResource, List problems) {
        ExternalReferenceVisitor visitor = new ExternalReferenceVisitor(eResource);
        visitor.setIncludeDiagramReferences(this.includeDiagramReferences);
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        try {
            processor.walk(this.getResource(), 2);
        }
        catch (ModelerCoreException e2) {
            Object[] params = new Object[]{this.getResource().getURI(), e2.getLocalizedMessage()};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.Error_while_organizing_imports", params);
            problems.add(new Status(4, "com.metamatrix.modeler.core", 1002, msg, e2));
        }
        catch (Throwable t2) {
            Object[] params = new Object[]{this.getResource().getURI(), t2.getLocalizedMessage()};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.Unknown_error_while_organizing_imports", params);
            problems.add(new Status(4, "com.metamatrix.modeler.core", 1003, msg, t2));
        }
        return visitor;
    }

    private IStatus createFinalStatus(List problems) {
        IStatus resultStatus = null;
        if (problems.isEmpty()) {
            int code = 1004;
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.complete");
            Status status = new Status(0, "com.metamatrix.modeler.core", 1004, msg, null);
            resultStatus = status;
        } else {
            resultStatus = problems.size() == 1 ? (IStatus)problems.get(0) : this.createFinalResultStatus(problems);
        }
        return resultStatus;
    }

    private IStatus createFinalResultStatus(List problems) {
        MultiStatus resultStatus = null;
        int numErrors = 0;
        int numWarnings = 0;
        Iterator problemIter = problems.iterator();
        while (problemIter.hasNext()) {
            IStatus aStatus = (IStatus)problemIter.next();
            if (aStatus.getSeverity() == 2) {
                ++numWarnings;
                continue;
            }
            if (aStatus.getSeverity() != 4) continue;
            ++numErrors;
        }
        IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
        if (numWarnings != 0 && numErrors == 0) {
            int code = 1005;
            Object[] params = new Object[]{new Integer(numWarnings)};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.warnings", params);
            resultStatus = new MultiStatus("com.metamatrix.modeler.core", 1005, statusArray, msg, null);
        } else if (numWarnings == 0 && numErrors != 0) {
            int code = 1006;
            Object[] params = new Object[]{new Integer(numErrors)};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.errors", params);
            resultStatus = new MultiStatus("com.metamatrix.modeler.core", 1006, statusArray, msg, null);
        } else if (numWarnings != 0 && numErrors != 0) {
            int code = 1007;
            Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.warnings_and_errors", params);
            resultStatus = new MultiStatus("com.metamatrix.modeler.core", 1007, statusArray, msg, null);
        } else {
            int code = 1008;
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.no_warnings_or_errors");
            resultStatus = new MultiStatus("com.metamatrix.modeler.core", 1008, statusArray, msg, null);
        }
        return resultStatus;
    }

    private ModelImport createModelImport(Resource eResource, ExternalReferenceVisitor.ExternalReferences externalRefs, List problems, IProgressMonitor monitor) {
        ModelImport existingImport;
        URI uri = externalRefs.getResourceUri();
        Resource theResource = externalRefs.getResource();
        ResourceSet eResourceSet = eResource.getResourceSet();
        if (theResource == null) {
            boolean loadOnDemand = false;
            theResource = eResourceSet.getResource(uri, false);
        }
        if (theResource == null) {
            Collection refs = externalRefs.getReferencedObjects();
            theResource = this.getHelper().findResourceWithObject(refs, problems, this.handler);
        }
        if (theResource == null || this.resourceMightBeRefactored(theResource, uri)) {
            theResource = this.getHelper().findRefactoredResource(eResource, uri, monitor, problems);
        }
        if ((existingImport = ModelerCore.getModelEditor().findModelImport((EmfResource)eResource, theResource)) != null) {
            ModelerCore.getModelEditor().updateModelImport(existingImport, theResource);
            return existingImport;
        }
        if (theResource != null) {
            try {
                return ModelerCore.getModelEditor().createModelImport((EmfResource)eResource, theResource);
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        return null;
    }

    private boolean resourceMightBeRefactored(Resource theResource, URI uri) {
        if (uri.isFile()) {
            if (!new File(theResource.getURI().toFileString()).exists()) {
                return false;
            }
            IResource resource = WorkspaceResourceFinderUtil.findIResource(theResource);
            if (resource == null || !resource.exists()) {
                return true;
            }
        }
        return false;
    }

    protected void setRefactoredPaths(Map paths) {
        this.getHelper().setRefactoredPaths(paths);
    }

    private ModelAnnotation getModelAnnotation(Resource resource) {
        if (resource instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)resource;
            return emfResource.getModelAnnotation();
        }
        return null;
    }

    private void adjustReferences(Resource eResource, ExternalReferenceVisitor.ExternalReferences externalRefs, ModelImport modelImport) {
        Resource importedResource = null;
        Container cntr = ModelerCore.getContainer(eResource);
        if (cntr != null) {
            ResourceFinder finder = cntr.getResourceFinder();
            String modelLocation = modelImport.getModelLocation();
            if (modelImport.eResource() == null && !StringUtil.isEmpty(modelLocation)) {
                URI modelLocationURI;
                URI baseLocationURI = eResource.getURI();
                URI uRI = modelLocationURI = baseLocationURI.isFile() ? URI.createURI(modelLocation, false) : URI.createURI(modelLocation);
                if (baseLocationURI.isHierarchical() && !baseLocationURI.isRelative() && modelLocationURI.isRelative()) {
                    modelLocationURI = modelLocationURI.resolve(baseLocationURI);
                }
                importedResource = finder.findByURI(modelLocationURI, true);
            }
            if (importedResource == null) {
                importedResource = finder.findByImport(modelImport, false);
            }
            if (importedResource != null) {
                Collection refs = externalRefs.getReferencedObjects();
                URI uri = importedResource.getURI();
                Iterator iter = refs.iterator();
                while (iter.hasNext()) {
                    InternalEObject iobj;
                    Object obj = iter.next();
                    if (!(obj instanceof InternalEObject) || !(iobj = (InternalEObject)obj).eIsProxy()) continue;
                    URI existingUri = iobj.eProxyURI();
                    String frag = existingUri.fragment();
                    URI newUri = uri.appendFragment(frag);
                    iobj.eSetProxyURI(newUri);
                }
            }
        }
    }
}

