/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.metamodel.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class AbstractNameFinder
implements ModelVisitor {
    protected final String nameToMatch;
    protected Collection matchingEObjects;
    protected boolean isPartialName;

    public AbstractNameFinder(String nameToMatch, boolean isPartialName) {
        ArgCheck.isNotEmpty(nameToMatch);
        this.nameToMatch = nameToMatch.toUpperCase();
        this.isPartialName = isPartialName;
        this.matchingEObjects = new HashSet();
    }

    public boolean visit(Resource resource) throws ModelerCoreException {
        return true;
    }

    public boolean visit(EObject eObject) throws ModelerCoreException {
        return !(!this.isPartialName ? !this.matchingEObjects.isEmpty() : this.matchingEObjects.contains(eObject));
    }

    protected boolean foundMatch(String fullName, EObject eObject) {
        if (this.isPartialName) {
            if (fullName.endsWith(this.nameToMatch)) {
                this.matchingEObjects.add(eObject);
                return true;
            }
        } else if (this.nameToMatch.equals(fullName)) {
            this.matchingEObjects.add(eObject);
            return true;
        }
        return false;
    }

    protected boolean isParent(String parentName) {
        if (!this.isPartialName && this.nameToMatch.startsWith(parentName)) {
            return true;
        }
        return this.isPartialName;
    }

    public Collection getMatchingEObjects() {
        return this.matchingEObjects;
    }
}

