/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.metamodel.core.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.ResourceFinder;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class UnresolvedModelImportRule
implements ObjectValidationRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$ModelImport;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf(class$com$metamatrix$metamodels$core$ModelImport == null ? (class$com$metamatrix$metamodels$core$ModelImport = UnresolvedModelImportRule.class$("com.metamatrix.metamodels.core.ModelImport")) : class$com$metamatrix$metamodels$core$ModelImport, eObject);
        ModelImport modelImport = (ModelImport)eObject;
        String location = modelImport.getModelLocation();
        Resource resource = eObject.eResource();
        if (resource == null || location == null) {
            ValidationResultImpl result = new ValidationResultImpl(eObject, resource);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("UnresolvedModelImportRule.0"));
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
        Container container = context.getResourceContainer();
        if (container != null) {
            URI uri;
            ResourceFinder finder = container.getResourceFinder();
            if (finder.isBuiltInResource(uri = URI.createURI(location))) {
                return;
            }
            Resource importResource = finder.findByImport(modelImport, true);
            if (importResource == null) {
                ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
                String msg = ModelerCore.Util.getString("UnresolvedModelImportRule.The_model_import_cannot_be_resolved", location);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                context.addResult(result);
                return;
            }
            URI resourceURI = resource.getURI();
            URI importURI = importResource.getURI();
            if (resourceURI.isFile() && importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                if (!location.equals(URI.decode(importURI.toString()))) {
                    ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
                    String msg = ModelerCore.Util.getString("UnresolvedModelImportRule.The_model_import_cannot_be_resolved", location);
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                    result.addProblem(problem);
                    context.addResult(result);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

