/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.metamodel.aspect.sql;

import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAnnotationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlForeignKeyAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlModelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTransformationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlVdbAspect;
import org.eclipse.emf.ecore.EObject;

public class SqlAspectHelper {
    public static SqlAspect getSqlAspect(EObject eObject) {
        return AspectManager.getSqlAspect(eObject);
    }

    public static boolean isColumn(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlColumnAspect;
    }

    public static boolean isTable(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlTableAspect;
    }

    public static boolean isXmlDocument(EObject eObject) {
        return SqlAspectHelper.isValidTreeTransformationTarget(eObject);
    }

    public static boolean isXmlFragment(EObject eObject) {
        return SqlAspectHelper.isValidTreeTransformationTarget(eObject);
    }

    public static boolean isUpdatableGroup(EObject eObject) {
        SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect(eObject);
        if (sqlAspect != null) {
            if (sqlAspect instanceof SqlTableAspect) {
                SqlTableAspect tableAspect = (SqlTableAspect)sqlAspect;
                return tableAspect.supportsUpdate(eObject);
            }
            if (sqlAspect instanceof SqlProcedureAspect) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidSqlTransformationTarget(EObject eObject) {
        boolean isValid = false;
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        if (aspect != null) {
            if (aspect instanceof SqlTableAspect) {
                isValid = ((SqlTableAspect)aspect).isMappable(eObject, 1);
            } else if (aspect instanceof SqlProcedureAspect) {
                isValid = ((SqlProcedureAspect)aspect).isMappable(eObject, 1);
            }
        }
        return isValid;
    }

    public static boolean isValidTreeTransformationTarget(EObject eObject) {
        boolean isValid = false;
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        if (aspect != null && aspect instanceof SqlTableAspect) {
            isValid = ((SqlTableAspect)aspect).isMappable(eObject, 2);
        }
        return isValid;
    }

    public static boolean isValidTransformationTarget(EObject eObject) {
        boolean isValid = SqlAspectHelper.isValidSqlTransformationTarget(eObject);
        if (!isValid) {
            isValid = SqlAspectHelper.isValidTreeTransformationTarget(eObject);
        }
        return isValid;
    }

    public static boolean isColumnSet(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlColumnSetAspect;
    }

    public static boolean isForeignKey(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlForeignKeyAspect;
    }

    public static boolean isTransformation(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlTransformationAspect;
    }

    public static boolean isDatatype(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlDatatypeAspect;
    }

    public static boolean isAnnotation(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlAnnotationAspect;
    }

    public static boolean isVdb(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlVdbAspect;
    }

    public static boolean isProcedure(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlProcedureAspect;
    }

    public static boolean isProcedureParameter(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlProcedureParameterAspect;
    }

    public static boolean isProcedureResultSet(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlColumnSetAspect && ((SqlColumnSetAspect)aspect).isRecordType('C');
    }

    public static boolean isModel(EObject eObject) {
        SqlAspect aspect = SqlAspectHelper.getSqlAspect(eObject);
        return aspect != null && aspect instanceof SqlModelAspect;
    }
}

