/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.aspects.DeclarativeTransactionManager;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.interceptor.InvocationFactoryHelper;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.core.util.Stopwatch;
import com.metamatrix.core.util.StringUtilities;
import com.metamatrix.modeler.core.ExtensionDescriptor;
import com.metamatrix.modeler.core.ExternalResourceDescriptor;
import com.metamatrix.modeler.core.ExternalResourceSet;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.Metamodels;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.Registry;
import com.metamatrix.modeler.core.TransformationPreferences;
import com.metamatrix.modeler.core.ValidationPreferences;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.ResourceDescriptor;
import com.metamatrix.modeler.core.metamodel.ResourceLoadOptionContributor;
import com.metamatrix.modeler.core.search.MetadataSearch;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.types.DatatypeManagerLifecycle;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.Configuration;
import com.metamatrix.modeler.internal.core.EclipseConfigurationBuilder;
import com.metamatrix.modeler.internal.core.ExternalResourceLoader;
import com.metamatrix.modeler.internal.core.ModelEditorImpl;
import com.metamatrix.modeler.internal.core.TransformationPreferencesImpl;
import com.metamatrix.modeler.internal.core.ValidationPreferencesImpl;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceIndexSelectorFactory;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistry;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRegistryImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelsImpl;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSet;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSetImpl;
import com.metamatrix.modeler.internal.core.search.MetadataSearchImpl;
import com.metamatrix.modeler.internal.core.util.FlatRegistry;
import com.metamatrix.modeler.internal.core.util.StartupLogger;
import com.metamatrix.modeler.internal.core.util.WorkspaceUriPathConverter;
import com.metamatrix.modeler.internal.core.validation.ValidationRuleManager;
import com.metamatrix.modeler.internal.core.workspace.ModelStatusImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManagerSaveParticipant;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ModelerCore
extends Plugin
implements DeclarativeTransactionManager {
    private static final String MINIMUM_JAVA_VERSION = "1.4.1";
    public static final String PLUGIN_ID = "com.metamatrix.modeler.core";
    public static final String BUILDER_ID = "com.metamatrix.modeler.core.modelBuilder";
    public static final String NATURE_ID = "com.metamatrix.modeler.core.modelNature";
    public static final String[] NATURES = new String[]{"com.metamatrix.modeler.core.modelNature"};
    public static final String MODEL_FILE_EXTENSION = ".xmi";
    public static final String DECLATIVE_TXN = "Declarative Transaction";
    public static final String XSD_FILE_EXTENSION = ".xsd";
    public static final String VDB_FILE_EXTENSION = ".vdb";
    public static final String MARKER_PROBLEM_DECORATOR_TEXT = "com.metamatrix.modeler.core.problemDecoratorText";
    public static final String MARKER_URI_PROPERTY = "com.metamatrix.modeler.core.markerURI";
    public static final String TARGET_MARKER_URI_PROPERTY = "com.metamatrix.modeler.core.targetMarkerURI";
    public static final String XML_SCHEMA_GENERAL_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_MAGIC_SCHEMA_GENERAL_URI = "http://www.w3.org/2001/MagicXMLSchema";
    public static final String XML_SCHEMA_INSTANCE_GENERAL_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_XSD_GENERAL_URI = "http://www.w3.org/2001/xml";
    public static String XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX = "platform:/plugin/org.eclipse.xsd_2.1.0/";
    public static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI;
    public static final String XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI;
    public static final String XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI;
    public static final QualifiedName DUPLICATE_MODEL_OF_IPATH_KEY;
    public static final String DELIMITER = ".";
    private static final String BUNDLE_NAME = "com.metamatrix.modeler.core.i18n";
    public static final PluginUtil Util;
    private static Plugin MODELER_CORE_PLUGIN;
    private static Container defaultModelContainer;
    private static final Object CONTAINER_LOCK;
    private static final String DEFAULT_CONTAINER_NAME = "Modeler Container";
    private static Container externalResourceContainer;
    private static final String EXTERNAL_RESOURCE_CONTAINER_NAME = "External Resource Container";
    private static Metamodels metamodels;
    private static ResourceSet[] externalResourceSets;
    private static InvocationFactoryHelper[] invocationFactoryHelpers;
    private static ModelEditor modelEditor;
    private static ValidationPreferences validationPreferences;
    private static TransformationPreferences transformationPreferences;
    private static Registry registry;
    private static MetamodelRegistry metamodelRegistry;
    private static final Object METAMODEL_REGISTRY_LOCK;
    private static final Configuration CONFIG;
    private static ValidationRuleManager validationRuleMgr;
    public static boolean DEBUG;
    public static boolean DEBUG_MODELER_CORE_INIT;
    public static boolean DEBUG_METAMODEL;
    public static boolean DEBUG_VALIDATION;
    public static boolean DEBUG_TRANSACTION;
    public static boolean DEBUG_TRANSACTION_INVOCATIONS;
    public static boolean DEBUG_MODEL_WORKSPACE;
    public static boolean DEBUG_MODEL_WORKSPACE_EVENT;
    public static boolean DEBUG_MODEL_WORKSPACE_SAVE;
    public static boolean DEBUG_PROJECT_BUILDER;
    public static boolean DEBUG_NOTIFICATIONS;
    public static boolean DEBUG_TEAM;
    public static boolean DEBUG_BRIDGE;
    public static boolean DEBUG_XML;
    public static boolean DEBUG_GEMINI;
    public static boolean DEBUG_QUERY_RESOLUTION;
    public static boolean DEBUG_VDB_EDITING_CONTEXT;
    private static boolean IGNORE_VALIDATION_PREFERNCES_ON_BUILD;
    private ISaveParticipant saveParticipant;
    private final HashMap writableInvocationMap = new HashMap();
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$SetCommand;

    public ModelerCore(IPluginDescriptor descriptor) {
        super(descriptor);
        MODELER_CORE_PLUGIN = this;
    }

    public static Plugin getPlugin() {
        return MODELER_CORE_PLUGIN;
    }

    public void startup() throws CoreException {
        super.startup();
        Stopwatch watch = new Stopwatch();
        watch.start();
        StartupLogger.log(" ModelerCore.startup() STARTED");
        BasicEObjectImpl.setObjectIDFactory(IDGenerator.getInstance().getFactory("mmuuid"));
        CorePlugin.setTransactionManager(this);
        try {
            ((PluginUtilImpl)Util).initializePlatformLogger(this);
        }
        catch (Throwable t2) {
            Util.log(4, Util.getString("ModelerCore.Error_encountered_initializing_the_platform_logger_1", t2.getMessage()));
        }
        Util.checkJre(MINIMUM_JAVA_VERSION);
        try {
            EclipseConfigurationBuilder.build(CONFIG);
        }
        catch (Throwable t3) {
            Util.log(4, Util.getString("ModelerCore.Error_encountered_building_the_Eclipse_configuration_2", t3.getMessage()));
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.saveParticipant = new ModelWorkspaceManagerSaveParticipant();
            workspace.addSaveParticipant(this, this.saveParticipant);
        }
        catch (Throwable t4) {
            Util.log(4, Util.getString("ModelerCore.Error_encountered_starting_ModelWorkspaceManager"));
        }
        ModelerCore.initializeXsdGlobalResourceSet();
        ModelerCore.loadModelContainer();
        ModelerCore.getValidationPreferences();
        watch.stop();
        StartupLogger.log(" ModelerCore.startup() FINISHED", watch.getTotalDuration());
    }

    public static void setIgnoreValidationPreferencesOnBuild(boolean ignorePrefs) {
        IGNORE_VALIDATION_PREFERNCES_ON_BUILD = ignorePrefs;
    }

    public static boolean ignoreValidationPreferencesOnBuild() {
        return IGNORE_VALIDATION_PREFERNCES_ON_BUILD;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static ModelEditor getModelEditor() {
        if (modelEditor == null) {
            modelEditor = new ModelEditorImpl();
        }
        return modelEditor;
    }

    public static ValidationPreferences getValidationPreferences() {
        if (validationPreferences == null) {
            validationPreferences = new ValidationPreferencesImpl();
        }
        return validationPreferences;
    }

    public static TransformationPreferences getTransformationPreferences() {
        if (transformationPreferences == null) {
            transformationPreferences = new TransformationPreferencesImpl();
        }
        return transformationPreferences;
    }

    public static synchronized Metamodels getMetamodels() {
        if (metamodels == null) {
            metamodels = new MetamodelsImpl();
        }
        return metamodels;
    }

    public static DatatypeManager getWorkspaceDatatypeManager() {
        DatatypeManager datatypeManager = null;
        try {
            Container modelContainer = ModelerCore.getModelContainer();
            if (modelContainer != null) {
                datatypeManager = modelContainer.getDatatypeManager();
            }
        }
        catch (CoreException e2) {
            throw new ModelerCoreRuntimeException(e2, Util.getString("ModelerCore.Error_creating_the_DatatypeManager_instance_1"));
        }
        return datatypeManager;
    }

    public static DatatypeManager getBuiltInTypesManager() {
        DatatypeManager builtInTypesManager = null;
        DatatypeManager wsDatatypeManager = ModelerCore.getWorkspaceDatatypeManager();
        if (wsDatatypeManager != null) {
            builtInTypesManager = wsDatatypeManager.getBuiltInTypeManager();
        }
        return builtInTypesManager;
    }

    public static DatatypeManager getDatatypeManager(EObject object) {
        return ModelerCore.getDatatypeManager(object, false);
    }

    public static DatatypeManager getDatatypeManager(EObject object, boolean defaultToWorkspaceMgr) {
        if (defaultToWorkspaceMgr && object == null) {
            return ModelerCore.getWorkspaceDatatypeManager();
        }
        ArgCheck.isNotNull(object);
        DatatypeManager result = null;
        Container container = ModelerCore.getContainer(object);
        if (container != null) {
            result = container.getDatatypeManager();
        }
        if (defaultToWorkspaceMgr && result == null) {
            result = ModelerCore.getWorkspaceDatatypeManager();
        }
        return result;
    }

    protected static DatatypeManager createDatatypeManager() {
        try {
            ModelerCore.getMetamodelRegistry();
        }
        catch (ModelerCoreException e2) {
            throw new ModelerCoreRuntimeException(e2, Util.getString("ModelerCore.Error_creating_the_DatatypeManager_instance_1"));
        }
        List desc = CONFIG.getDatatypeManagerDescriptors();
        if (desc.isEmpty()) {
            Util.log(4, Util.getString("ModelerCore.Error,_no_DatatypeManager_extensions_were_found_in_the_plugin_registry_1"));
        }
        DatatypeManager dtMgr = null;
        Iterator iter = desc.iterator();
        if (iter.hasNext()) {
            ExtensionDescriptor descriptor = (ExtensionDescriptor)iter.next();
            dtMgr = (DatatypeManager)descriptor.getNewExtensionClassInstance();
        }
        if (dtMgr == null) {
            Util.log(4, Util.getString("ModelerCore.Error_creating_new_instance_of_a_DatatypeManager_2"));
            throw new ModelerCoreRuntimeException(Util.getString("ModelerCore.Error_creating_the_DatatypeManager_instance_1"));
        }
        if (DEBUG) {
            Util.log(1, Util.getString("ModelerCore.DEBUG.Created_new_instance_of_a_DatatypeManager_1"));
        }
        return dtMgr;
    }

    public static Container getContainer(EObject obj) {
        if (obj == null) {
            return null;
        }
        Resource objResource = obj.eResource();
        if (objResource != null) {
            ResourceSet resourceSet = objResource.getResourceSet();
            if (resourceSet instanceof EmfResourceSet) {
                EmfResourceSet emfResourceSet = (EmfResourceSet)((Object)resourceSet);
                Container container = emfResourceSet.getContainer();
                return container;
            }
            if (resourceSet instanceof Container) {
                return (Container)resourceSet;
            }
            if (resourceSet == XSDSchemaImpl.getGlobalResourceSet()) {
                return defaultModelContainer;
            }
        }
        return null;
    }

    public static ModelWorkspace getModelWorkspace() {
        return ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
    }

    public static synchronized ValidationRuleManager getValidationRuleManager() {
        if (validationRuleMgr == null) {
            validationRuleMgr = new ValidationRuleManager();
        }
        return validationRuleMgr;
    }

    public static List getMappingAdapterDescriptors() {
        return CONFIG.getMappingAdapterDescriptors();
    }

    public static Container getContainer(Resource resource) {
        ResourceSet rs;
        ArgCheck.isNotNull(resource);
        if (resource instanceof EmfResource) {
            return ((EmfResource)resource).getContainer();
        }
        if (resource instanceof XSDResourceImpl && (rs = resource.getResourceSet()) instanceof EmfResourceSet) {
            return ((EmfResourceSet)((Object)rs)).getContainer();
        }
        return null;
    }

    public static Container getModelContainer() throws CoreException {
        return defaultModelContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadModelContainer() throws CoreException {
        if (defaultModelContainer == null) {
            Object object = CONTAINER_LOCK;
            synchronized (object) {
                if (defaultModelContainer != null) {
                    return;
                }
                defaultModelContainer = ModelerCore.createContainer(DEFAULT_CONTAINER_NAME);
            }
        }
    }

    public static void testLoadModelContainer() throws CoreException {
        ModelerCore.loadModelContainer();
    }

    public static Container createContainer(String containerName) throws CoreException {
        Container container = ModelerCore.createEmptyContainer(containerName);
        ModelerCore.addExternalResourceSets(container);
        if (MODELER_CORE_PLUGIN != null && container instanceof ContainerImpl) {
            ContainerImpl ci = (ContainerImpl)container;
            DatatypeManager datatypeManager = ModelerCore.createDatatypeManager();
            if (datatypeManager != null) {
                ci.setDatatypeManager(datatypeManager);
                if (datatypeManager instanceof DatatypeManagerLifecycle) {
                    ((DatatypeManagerLifecycle)((Object)datatypeManager)).initialize(ci);
                }
            }
        }
        container.setOptions(ModelerCore.getDefaultContainerOptions());
        return container;
    }

    private static Map getDefaultContainerOptions() {
        HashMap<String, XMLMapImpl> options = new HashMap<String, XMLMapImpl>();
        if (ModelerCore.getPlugin() != null && CONFIG != null) {
            XMLMapImpl xmlMap = new XMLMapImpl();
            Iterator iter = CONFIG.getResourceLoadOptions().iterator();
            while (iter.hasNext()) {
                ExtensionDescriptor descriptor = (ExtensionDescriptor)iter.next();
                ResourceLoadOptionContributor optionContributor = (ResourceLoadOptionContributor)descriptor.getExtensionClassInstance();
                if (optionContributor == null) continue;
                optionContributor.addMappings(xmlMap);
            }
            options.put("XML_MAP", xmlMap);
        }
        return options;
    }

    private static void initializeXsdGlobalResourceSet() {
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() STARTED");
        Stopwatch watch = new Stopwatch();
        watch.start(true);
        XSDSchemaImpl.getMagicSchemaForSchema(XML_SCHEMA_GENERAL_URI);
        watch.stop();
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() calling XSDSchemaImpl.getMagicSchemaForSchema()", watch.getTotalDuration());
        watch.start(true);
        XSDSchemaImpl.getSchemaForSchema(XML_SCHEMA_GENERAL_URI);
        watch.stop();
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() calling XSDSchemaImpl.getSchemaForSchema()", watch.getTotalDuration());
        watch.start(true);
        XSDSchemaImpl.getSchemaInstance(XML_SCHEMA_INSTANCE_GENERAL_URI);
        watch.stop();
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() calling XSDSchemaImpl.getSchemaInstance()", watch.getTotalDuration());
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() FINISHED");
    }

    private static synchronized Container getExternalResourceContainer() throws CoreException {
        if (externalResourceContainer == null) {
            externalResourceContainer = ModelerCore.createEmptyContainer(EXTERNAL_RESOURCE_CONTAINER_NAME);
            ModelerCore.loadExternalResources(externalResourceContainer);
        }
        return externalResourceContainer;
    }

    public static void loadExternalResources(Container container) {
        ExternalResourceLoader loader = new ExternalResourceLoader();
        List desc = CONFIG.getExternalResourceDescriptors();
        Iterator iter = desc.iterator();
        while (iter.hasNext()) {
            ExternalResourceDescriptor descriptor = (ExternalResourceDescriptor)iter.next();
            try {
                loader.load(descriptor, container);
            }
            catch (ModelerCoreException e2) {
                Util.log(4, e2, Util.getString("ModelerCore.Error_loading_external_resource_1"));
            }
        }
    }

    public static synchronized Resource[] getSystemVdbResources() {
        ObjectVector tmp = new ObjectVector();
        try {
            Container rsrcSet = ModelerCore.getExternalResourceContainer();
            if (rsrcSet != null) {
                Iterator iter = rsrcSet.getResources().iterator();
                while (iter.hasNext()) {
                    Resource rsrc = (Resource)iter.next();
                    if (rsrc == null || rsrc.getURI().lastSegment().indexOf("System") == -1) continue;
                    tmp.add(rsrc);
                }
            }
        }
        catch (CoreException e2) {
            Util.log(4, e2, e2.getMessage());
        }
        Object[] systemResources = new Resource[tmp.size()];
        tmp.copyInto(systemResources);
        return systemResources;
    }

    public static synchronized ResourceSet[] getExternalResourceSets() {
        if (externalResourceSets == null) {
            ObjectVector tmp = new ObjectVector();
            try {
                Container rsrcSet = ModelerCore.getExternalResourceContainer();
                if (rsrcSet != null) {
                    tmp.add(rsrcSet);
                }
            }
            catch (CoreException e2) {
                Util.log(4, e2, e2.getMessage());
            }
            List desc = CONFIG.getExternalResourceSetDescriptors();
            Iterator iter = desc.iterator();
            while (iter.hasNext()) {
                ResourceSet rsrcSet;
                ExtensionDescriptor descriptor = (ExtensionDescriptor)iter.next();
                ExternalResourceSet extRsrcSet = (ExternalResourceSet)descriptor.getExtensionClassInstance();
                if (extRsrcSet == null || (rsrcSet = extRsrcSet.getResourceSet()) == null) continue;
                tmp.add(rsrcSet);
            }
            externalResourceSets = new ResourceSet[tmp.size()];
            tmp.copyInto(externalResourceSets);
        }
        return externalResourceSets;
    }

    public static InvocationFactoryHelper[] getInvocationFactoryHelpers() {
        if (invocationFactoryHelpers == null || invocationFactoryHelpers.length == 0) {
            ObjectVector tmp = new ObjectVector();
            List desc = CONFIG.getInvocationFactoryHelpers();
            Iterator iter = desc.iterator();
            while (iter.hasNext()) {
                ExtensionDescriptor descriptor = (ExtensionDescriptor)iter.next();
                InvocationFactoryHelper helper = (InvocationFactoryHelper)descriptor.getExtensionClassInstance();
                if (helper == null) continue;
                tmp.add(helper);
            }
            invocationFactoryHelpers = new InvocationFactoryHelper[tmp.size()];
            tmp.copyInto(invocationFactoryHelpers);
        }
        return invocationFactoryHelpers;
    }

    public static void addExternalResourceSets(Container container) {
        ResourceSet[] extRsrcSets = ModelerCore.getExternalResourceSets();
        for (int i2 = 0; i2 < extRsrcSets.length; ++i2) {
            ResourceSet rsrcSet = extRsrcSets[i2];
            container.addExternalResourceSet(rsrcSet);
            if (!DEBUG) continue;
            Util.log(1, Util.getString("ModelerCore.DEBUG.Added_external_resource_set_to_the_container._1", rsrcSet));
        }
    }

    public static Container createEmptyContainer(String containerName) throws CoreException {
        ContainerImpl container = null;
        try {
            if (DEBUG_MODEL_WORKSPACE) {
                Util.log(1, Util.getString("ModelWorkspaceManager.DEBUG.Creating_the_model_container"));
            }
            container = new ContainerImpl();
            container.setName(containerName);
            container.setMetamodelRegistry(ModelerCore.getMetamodelRegistry());
            String name = container.getName();
            if (name != null && name.length() != 0) {
                ModelerCore.getRegistry().register(name, container);
            }
            container.start();
            ResourceSet resourceSet = container.getResourceSet();
            if (resourceSet instanceof EmfResourceSetImpl) {
                ((EmfResourceSetImpl)resourceSet).setUriPathConverter(new WorkspaceUriPathConverter());
            }
        }
        catch (ModelerCoreException e2) {
            throw new CoreException(new Status(4, PLUGIN_ID, 1, Util.getString("ModelerCore.Error_adding_resource_descriptors_to_the_container"), e2));
        }
        Iterator iter = CONFIG.getResourceDescriptors().iterator();
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        while (iter.hasNext()) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)iter.next();
            try {
                container.addResourceDescriptor(resourceDescriptor);
            }
            catch (ModelerCoreException e3) {
                IStatus status = e3.getStatus();
                errors.add(status);
            }
        }
        if (!errors.isEmpty()) {
            IStatus[] statuses = errors.toArray(new IStatus[errors.size()]);
            throw new CoreException(new MultiStatus(PLUGIN_ID, 0, statuses, Util.getString("ModelerCore.Error_adding_resource_descriptors_to_the_container"), null));
        }
        return container;
    }

    public static Configuration getConfiguration() {
        return CONFIG;
    }

    public static synchronized Registry getRegistry() {
        if (registry == null) {
            registry = new FlatRegistry();
        }
        return registry;
    }

    public static boolean isModelContainer(Container container) {
        return container == defaultModelContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetamodelRegistry getMetamodelRegistry() throws ModelerCoreException {
        Object object = METAMODEL_REGISTRY_LOCK;
        synchronized (object) {
            if (metamodelRegistry == null) {
                StartupLogger.log(" ModelerCore - getMetamodelRegistry() Create Registry STARTED");
                Stopwatch watch = new Stopwatch();
                watch.start(true);
                if (metamodelRegistry != null) {
                    return metamodelRegistry;
                }
                metamodelRegistry = new MetamodelRegistryImpl();
                if (DEBUG_METAMODEL) {
                    Util.log(1, Util.getString("ModelerCore.Registering_metamodel_descriptor(s)_in_the_MetamodelRegistry_1", CONFIG.getMetamodelDescriptors().size()));
                }
                Iterator iter = CONFIG.getMetamodelDescriptors().iterator();
                while (iter.hasNext()) {
                    MetamodelDescriptor descriptor = (MetamodelDescriptor)iter.next();
                    if (DEBUG_METAMODEL) {
                        Util.log(1, Util.getString("ModelerCore.Registering_metamodel", descriptor));
                    }
                    metamodelRegistry.register(descriptor);
                }
                List resourceDescriptors = CONFIG.getResourceDescriptors();
                if (DEBUG_METAMODEL) {
                    Util.log(1, Util.getString("ModelerCore.Registering_resource_descriptors", resourceDescriptors.size()));
                }
                metamodelRegistry.register(resourceDescriptors);
                metamodelRegistry.loadAll();
                watch.stop();
                StartupLogger.log(" ModelerCore - getMetamodelRegistry() Create Registry Finished", watch.getTotalDuration());
            }
        }
        return metamodelRegistry;
    }

    public static boolean startTxn(boolean isSignificant, String description, Object source) {
        return ModelerCore.startTxn(isSignificant, true, description, source);
    }

    public static boolean startTxn(boolean isSignificant, String description) {
        return ModelerCore.startTxn(isSignificant, description, null);
    }

    public static boolean startTxn(String description, Object source) {
        return ModelerCore.startTxn(true, true, description, source);
    }

    public static boolean startTxn(boolean isSignificant, boolean isUndoable, String description, Object source) {
        try {
            UnitOfWork uow = ModelerCore.getCurrentUoW();
            if (uow != null && uow.requiresStart()) {
                uow.begin();
                uow.setSignificant(isSignificant);
                uow.setDescription(description);
                uow.setSource(source);
                uow.setUndoable(isUndoable);
                return true;
            }
        }
        catch (ModelerCoreException e2) {
            return false;
        }
        return false;
    }

    public static void commitTxn() {
        try {
            UnitOfWork uow = ModelerCore.getCurrentUoW();
            if (uow != null) {
                uow.commit();
            }
        }
        catch (ModelerCoreException e2) {
            Util.log(4, e2, e2.getMessage());
        }
    }

    public static void rollbackTxn() {
        try {
            UnitOfWork uow = ModelerCore.getCurrentUoW();
            if (uow != null) {
                uow.rollback();
            }
        }
        catch (ModelerCoreException e2) {
            Util.log(4, e2, e2.getMessage());
        }
    }

    public static UnitOfWork getCurrentUoW() {
        if (defaultModelContainer != null) {
            try {
                return ModelerCore.getModelContainer().getEmfTransactionProvider().getCurrent();
            }
            catch (CoreException e2) {
                Util.log(4, e2, e2.getMessage());
                return null;
            }
        }
        return null;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        defaultModelContainer = null;
        registry = null;
        IStatus metamodelsProblem = null;
        if (metamodels instanceof MetamodelsImpl) {
            try {
                ((MetamodelsImpl)metamodels).shutdown();
            }
            catch (CoreException e2) {
                metamodelsProblem = e2.getStatus();
            }
        }
        metamodels = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeSaveParticipant(this);
        IStatus wsMgrProblem = null;
        try {
            ModelWorkspaceManager.shutdown();
        }
        catch (CoreException e3) {
            wsMgrProblem = e3.getStatus();
        }
        if (wsMgrProblem != null || metamodelsProblem != null) {
            String msg = Util.getString("ModelerCore.One_or_more_errors_shutting_down_ModelerCore_1");
            ModelStatusImpl multiStat = new ModelStatusImpl(1, msg);
            if (metamodelsProblem != null) {
                multiStat.add(metamodelsProblem);
            }
            if (wsMgrProblem != null) {
                multiStat.add(wsMgrProblem);
            }
            throw new ModelWorkspaceException(multiStat);
        }
    }

    public static ModelWorkspaceItem create(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        try {
            return ModelWorkspaceManager.getModelWorkspaceManager().getHandleFromMemento(handleIdentifier);
        }
        catch (ModelWorkspaceException e2) {
            return null;
        }
    }

    public static ModelResource create(IFile file) {
        return ModelWorkspaceManager.create(file, null);
    }

    public static ModelProject create(IProject project) {
        if (project == null || !ModelerCore.hasModelNature(project)) {
            return null;
        }
        ModelWorkspace modelWorkspace = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
        return modelWorkspace.getModelProject(project);
    }

    public static ModelWorkspaceItem create(IResource resource) {
        return ModelWorkspaceManager.create(resource, null);
    }

    public static ModelWorkspace create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
    }

    public static boolean hasModelNature(IProject project) {
        ArgCheck.isNotNull(project);
        try {
            return project.hasNature(NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isWritable(Method method) {
        if (this.writableInvocationMap.get(method) == null) {
            InvocationFactoryHelper[] helpers = ModelerCore.getInvocationFactoryHelpers();
            for (int i2 = 0; i2 < helpers.length; ++i2) {
                InvocationFactoryHelper next = helpers[i2];
                int writable = next.isWrite(method);
                if (writable == 2) {
                    this.writableInvocationMap.put(method, Boolean.FALSE);
                    return false;
                }
                if (writable != 1) continue;
                this.writableInvocationMap.put(method, Boolean.TRUE);
                return true;
            }
        } else {
            Boolean result = (Boolean)this.writableInvocationMap.get(method);
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object executeInTransaction(Method method, Object target, Object[] params) throws RuntimeException {
        ArgCheck.isNotNull(method);
        ArgCheck.isNotNull(params);
        ArgCheck.isNotNull(target);
        boolean startedTxn = ModelerCore.startTxn(null, this);
        boolean success = false;
        try {
            Object result;
            Command cmd;
            block18: {
                EStructuralFeature sf;
                EClassifier eType;
                CommandParameter param = this.createCommandParameter(method, target, params);
                if (param != null && param.getFeature() != null && (eType = (sf = (EStructuralFeature)param.getFeature()).getEType()) instanceof EEnum && sf.isMany()) {
                    Object newValue;
                    Object object = newValue = params.length == 2 ? params[1] : params[0];
                    if (newValue instanceof String) {
                        param = null;
                    }
                }
                ContainerImpl cntr = (ContainerImpl)defaultModelContainer;
                Command command = param == null || cntr == null ? null : (cmd = cntr.getEditingDomain().createCommand(class$org$eclipse$emf$edit$command$SetCommand == null ? (class$org$eclipse$emf$edit$command$SetCommand = ModelerCore.class$("org.eclipse.emf.edit.command.SetCommand")) : class$org$eclipse$emf$edit$command$SetCommand, param));
                if (cmd != null && param != null) break block18;
                result = null;
                try {
                    result = method.invoke(target, params);
                    success = true;
                    Object object = result;
                    return object;
                }
                catch (Exception e2) {
                    Object object;
                    block16: {
                        block17: {
                            String msg = Util.getString("ModelerCore.unexpected_declarative_txn_exception");
                            Util.log(4, e2, msg);
                            success = false;
                            object = result;
                            if (!startedTxn) break block16;
                            if (!success) break block17;
                            ModelerCore.commitTxn();
                            break block16;
                        }
                        ModelerCore.rollbackTxn();
                    }
                    return object;
                }
            }
            ModelerCore.getModelEditor().executeCommand((EObject)target, cmd);
            this.checkModelImports(target, params);
            result = cmd.getResult();
            if (result != null && result.size() == 1) {
                success = true;
                Object e3 = result.iterator().next();
                return e3;
            }
            success = true;
            Object object = result;
            return object;
            {
                catch (Exception e4) {
                    String msg = Util.getString("ModelerCore.unexpected_declarative_txn_exception");
                    Util.log(4, e4, msg);
                    Object var8_9 = null;
                    return var8_9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (startedTxn) {
                if (success) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void checkModelImports(Object invocationTarget, Object[] parms) throws Exception {
        try {
            for (int i2 = 0; i2 < parms.length; ++i2) {
                EObject target;
                Object parm = parms[i2];
                if (invocationTarget instanceof EObject && parm instanceof EObject && !(parm instanceof EStructuralFeature)) {
                    Resource valueResource;
                    target = (EObject)invocationTarget;
                    EObject value = (EObject)parm;
                    Resource targetResource = target.eResource();
                    if (targetResource == (valueResource = value.eResource()) || targetResource == null || !(targetResource instanceof EmfResource) || valueResource == null) continue;
                    EmfResource emfResource = (EmfResource)targetResource;
                    ModelerCore.getModelEditor().addModelImport(emfResource, valueResource);
                    continue;
                }
                if (!(invocationTarget instanceof EObject) || !(parm instanceof EmfResource) || parm instanceof EStructuralFeature) continue;
                target = (EObject)invocationTarget;
                List externalResources = this.externalResourceReferences(target);
                Iterator iter = externalResources.iterator();
                while (iter.hasNext()) {
                    Resource externalResource = (Resource)iter.next();
                    ModelerCore.getModelEditor().addModelImport((EmfResource)parm, externalResource);
                }
            }
        }
        catch (Exception e2) {
            String msg = Util.getString("ModelerCore.Unexpected_Exception_adding_model_imports_1");
            Util.log(4, e2, msg);
        }
    }

    private List externalResourceReferences(EObject target) {
        Resource targetResource = target.eResource();
        ArrayList<Resource> externalResources = new ArrayList<Resource>();
        TreeIterator iter = target.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            Iterator iter2 = eObject.eClass().getEAllReferences().iterator();
            while (iter2.hasNext()) {
                Resource valueResource;
                EReference eReference = (EReference)iter2.next();
                if (eReference.isContainment() || eReference.isContainer()) continue;
                Object value = eObject.eGet(eReference, false);
                if (eReference.isMany()) {
                    Iterator valueIter = ((List)value).iterator();
                    while (valueIter.hasNext()) {
                        Resource valueResource2;
                        Object valueInList = valueIter.next();
                        if (valueInList == null || !(valueInList instanceof EObject) || targetResource == (valueResource2 = ((EObject)valueInList).eResource()) || externalResources.contains(valueResource2)) continue;
                        externalResources.add(valueResource2);
                    }
                    continue;
                }
                if (value == null || !(value instanceof EObject) || targetResource == (valueResource = ((EObject)value).eResource()) || externalResources.contains(valueResource)) continue;
                externalResources.add(valueResource);
            }
        }
        return externalResources;
    }

    private CommandParameter createCommandParameter(Method method, Object target, Object[] params) {
        if (!(target instanceof EObject)) {
            return null;
        }
        EObject eTarget = (EObject)target;
        EStructuralFeature sf = null;
        for (int i2 = 0; i2 < params.length; ++i2) {
            Object temp = params[i2];
            if (!(temp instanceof EStructuralFeature)) continue;
            sf = (EStructuralFeature)temp;
            if (params.length != 2) continue;
            return new CommandParameter(target, (Object)sf, params[1]);
        }
        String sfName = method.getName().substring(3);
        String tempName = StringUtilities.lowerCaseFirstChar(sfName);
        sf = eTarget.eClass().getEStructuralFeature(tempName);
        if (sf == null) {
            sf = eTarget.eClass().getEStructuralFeature(sfName);
        }
        if (sf == null) {
            sf = this.complexSFSearch(sfName, eTarget);
        }
        if (sf == null) {
            return null;
        }
        return new CommandParameter((Object)eTarget, (Object)sf, params[0]);
    }

    private EStructuralFeature complexSFSearch(String sfName, EObject target) {
        String tmp = StringUtilities.getLastUpperCharToken(sfName);
        EStructuralFeature result = target.eClass().getEStructuralFeature(tmp);
        if (result == null) {
            result = target.eClass().getEStructuralFeature(StringUtilities.lowerCaseFirstChar(tmp));
        }
        while (!sfName.equals(tmp) && result == null) {
            tmp = StringUtilities.getLastUpperCharToken(sfName, tmp);
            result = target.eClass().getEStructuralFeature(tmp);
            if (result != null) continue;
            result = target.eClass().getEStructuralFeature(StringUtilities.lowerCaseFirstChar(tmp));
        }
        return result;
    }

    public static MetadataSearch createMetadataSearch() {
        ModelWorkspaceIndexSelectorFactory factory = new ModelWorkspaceIndexSelectorFactory();
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        return new MetadataSearchImpl(workspace, factory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX = XSDPlugin.INSTANCE.getBaseURL().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        XML_SCHEMA_ECLIPSE_PLATFORM_URI = XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX + "cache/www.w3.org/2001/XMLSchema.xsd";
        XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI = XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX + "cache/www.w3.org/2001/MagicXMLSchema.xsd";
        XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI = XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX + "cache/www.w3.org/2001/XMLSchema-instance.xsd";
        DUPLICATE_MODEL_OF_IPATH_KEY = new QualifiedName(PLUGIN_ID, "pathToDuplicateModel");
        Util = new PluginUtilImpl(PLUGIN_ID, BUNDLE_NAME, ResourceBundle.getBundle(BUNDLE_NAME));
        MODELER_CORE_PLUGIN = null;
        CONTAINER_LOCK = new Object();
        METAMODEL_REGISTRY_LOCK = new Object();
        CONFIG = new Configuration();
        DEBUG = false;
        DEBUG_MODELER_CORE_INIT = false;
        DEBUG_METAMODEL = false;
        DEBUG_VALIDATION = false;
        DEBUG_TRANSACTION = false;
        DEBUG_TRANSACTION_INVOCATIONS = false;
        DEBUG_MODEL_WORKSPACE = false;
        DEBUG_MODEL_WORKSPACE_EVENT = false;
        DEBUG_MODEL_WORKSPACE_SAVE = false;
        DEBUG_PROJECT_BUILDER = false;
        DEBUG_NOTIFICATIONS = false;
        DEBUG_TEAM = false;
        DEBUG_BRIDGE = false;
        DEBUG_XML = false;
        DEBUG_GEMINI = false;
        DEBUG_QUERY_RESOLUTION = false;
        DEBUG_VDB_EDITING_CONTEXT = false;
        IGNORE_VALIDATION_PREFERNCES_ON_BUILD = false;
    }

    public static class EXTENSION {
        public static final String METAMODEL_SERVICE_ID = "com.metamatrix.modeler.core.metamodelService";
        public static final String XMI_STREAM_READER_ID = "com.metamatrix.modeler.core.xmiStreamReader";
        public static final String XMI_STREAM_WRITER_ID = "com.metamatrix.modeler.core.xmiStreamWriter";
        public static final String XMI_RESOURCE_FACTORY_ID = "com.metamatrix.modeler.core.xmiResourceFactory";
        public static final String BUILDER_ID = "com.metamatrix.modeler.core.modelBuilder";
        public static final String NATURE_ID = "com.metamatrix.modeler.core.modelNature";
    }

    public static class EXTENSION_POINT {

        public static class REFERENCE_UPDATOR {
            public static final String ID = "referenceUpdator";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.referenceUpdator";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class RESOURCE_LOAD_OPTIONS {
            public static final String ID = "resourceLoadOptions";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.resourceLoadOptions";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class INVOCATION_FACTORY_HELPER {
            public static final String ID = "invocationFactoryHelper";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.invocationFactoryHelper";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class RESOURCE_INDEXER {
            public static final String ID = "resourceIndexer";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.resourceIndexer";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class RESOURCE_VALIDATOR {
            public static final String ID = "resourceValidator";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.resourceValidator";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class EXTERNAL_RESOURCE_SET {
            public static final String ID = "externalResourceSet";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.externalResourceSet";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class EXTERNAL_RESOURCE {
            public static final String ID = "externalResource";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.externalResource";

            public static class ATTRIBUTES {
                public static final String LOAD_IMMEDIATELY = "loadImmediately";
            }

            public static class ELEMENTS {
                public static final String RESOURCE_NAME = "resourceName";
                public static final String RESOURCE_URL = "resourceUrl";
                public static final String INTERNAL_URI = "internalUri";
                public static final String PRIORITY = "priority";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class DATATYPE_MANAGER {
            public static final String ID = "datatypeManager";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.datatypeManager";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class EOBJECT_MATCHER_FACTORY {
            public static final String ID = "eobjectMatcherFactory";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.eobjectMatcherFactory";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class IMPORT_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "importAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.importAspect";
        }

        public static class FEATURE_CONSTRAINT_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "featureConstraintAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.featureConstraintAspect";
        }

        public static class RELATIONSHIP_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "relationshipAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.relationshipAspect";
        }

        public static class SQL_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "sqlAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.sqlAspect";
        }

        public static class VALIDATION_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "validationAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.validationAspect";
        }

        public static class DEPENDENCY_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "dependencyAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.dependencyAspect";
        }

        public static class ITEM_PROVIDER_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "itemProviderAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.itemProviderAspect";
        }

        public static class UML_DIAGRAM_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "umlDiagramAspect";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.umlDiagramAspect";
        }

        public static class METAMODEL_ASPECT {
            protected static final String UML_DIAGRAM_ID = "umlDiagramAspect";
            protected static final String ITEM_PROVIDER_ID = "itemProviderAspect";
            protected static final String DEPENDENCY_ID = "dependencyAspect";
            protected static final String VALIDATION_ID = "validationAspect";
            protected static final String SQL_ID = "sqlAspect";
            protected static final String RELATIONSHIP_ID = "relationshipAspect";
            protected static final String FEATURE_CONSTRAINT_ID = "featureConstraintAspect";
            protected static final String IMPORT_ID = "importAspect";
            public static String[] ASPECT_IDS = new String[]{"umlDiagramAspect", "itemProviderAspect", "dependencyAspect", "validationAspect", "sqlAspect", "relationshipAspect", "featureConstraintAspect", "importAspect"};

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String METAMODEL_REF_ID = "metamodelExtensionID";
                public static final String FACTORY_CLASS = "factoryClass";
            }
        }

        public static class ASSOCIATION_PROVIDER {
            public static final String ID = "associationProvider";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.associationProvider";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String PROVIDER_CLASS = "providerClass";
            }
        }

        public static class STREAM_WRITER {
            public static final String ID = "streamWriter";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.streamWriter";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class STREAM_READER {
            public static final String ID = "streamReader";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.streamReader";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class VALIDATION {
            public static final String ID = "modelValidation";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.modelValidation";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
                public static final String LABEL = "label";
                public static final String TOOL_TIP = "toolTip";
                public static final String CATEGORY = "category";
                public static final String DEFAULT = "default";
            }

            public static class ELEMENTS {
                public static final String PREFERENCE = "preference";
            }
        }

        public static class RESOURCE_FACTORY {
            public static final String ID = "resourceFactory";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.resourceFactory";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String FILE_EXTENSION = "fileExtension";
                public static final String PROTOCOL = "protocol";
            }
        }

        public static class METAMODEL {
            public static final String ID = "metamodel";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.core.metamodel";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
                public static final String DESCRIPTION = "description";
                public static final String CLASS = "class";
                public static final String CREATE_AS_NEW_MODEL = "createAsNewModel";
                public static final String PARTICIPATORY_ONLY = "participatoryOnly";
                public static final String REQUIRES_PROXIES = "requiresProxies";
                public static final String ROOT_ENTITY_MAX_OCCURS = "maxOccurs";
                public static final String SUPPORTS_EXTENSION = "supportsExtension";
                public static final String SUPPORTS_DIAGRAMS = "supportsDiagrams";
            }

            public static class ELEMENTS {
                public static final String URI = "uri";
                public static final String ALTERNATE_URI = "alternateUri";
                public static final String INTERNAL_URI = "internalUri";
                public static final String NS_PREFIX = "namespacePrefix";
                public static final String RESOURCE = "resource";
                public static final String FACTORY_CLASS = "factoryClass";
                public static final String PACKAGE_CLASS = "packageClass";
                public static final String ADAPTER_CLASS = "adapterClass";
                public static final String ROOT_ENTITY_CLASS = "rootEntityClass";
                public static final String ALLOWABLE_MODEL_TYPE = "allowableModelType";
                public static final String PROPERTIES = "properties";
                public static final String FILE_EXTENSION = "fileExtension";
                public static final String INITIALIZERS = "initializers";
                public static final String INITIALIZER = "initializer";
            }
        }
    }

    public static interface ILicense {
        public static final String PRODUCT = "Modeler";
        public static final String PRODUCER_NAME = "MetaMatrix";
        public static final String VERSION = "5.0";
    }
}

