/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.function.util;

import com.metamatrix.metamodels.function.FunctionParameter;
import com.metamatrix.metamodels.function.ReturnParameter;
import com.metamatrix.metamodels.function.ScalarFunction;
import java.util.Iterator;

public class FunctionUtil {
    private FunctionUtil() {
    }

    public static String getSignature(ScalarFunction function) {
        String paramSig;
        String name = function.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append('(');
        boolean isFirst = true;
        Iterator iter = function.getInputParameters().iterator();
        while (iter.hasNext()) {
            FunctionParameter param = (FunctionParameter)iter.next();
            if (!isFirst) {
                sb.append(',');
            }
            paramSig = FunctionUtil.getSignature(param);
            sb.append(paramSig);
            isFirst = false;
        }
        sb.append(')');
        ReturnParameter returnParam = function.getReturnParameter();
        if (returnParam == null) {
            sb.append(':');
            sb.append("void");
        } else {
            sb.append(':');
            paramSig = FunctionUtil.getSignature(returnParam);
            sb.append(paramSig);
        }
        return sb.toString();
    }

    public static String getSignature(FunctionParameter param) {
        String type = param.getType();
        return type;
    }

    public static String getSignature(ReturnParameter param) {
        String type = param.getType();
        return type;
    }

    public static String getValidationSignature(ScalarFunction function) {
        String paramSig;
        String name = function.getInvocationClass();
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append('#');
        sb.append(function.getInvocationMethod());
        sb.append('(');
        boolean isFirst = true;
        Iterator iter = function.getInputParameters().iterator();
        while (iter.hasNext()) {
            FunctionParameter param = (FunctionParameter)iter.next();
            if (!isFirst) {
                sb.append(',');
            }
            paramSig = FunctionUtil.getValidationSignature(param);
            sb.append(paramSig);
            isFirst = false;
        }
        sb.append(')');
        ReturnParameter returnParam = function.getReturnParameter();
        if (returnParam == null) {
            sb.append(':');
            sb.append("void");
        } else {
            sb.append(':');
            paramSig = FunctionUtil.getValidationSignature(returnParam);
            sb.append(paramSig);
        }
        return sb.toString();
    }

    public static String getValidationSignature(FunctionParameter param) {
        String type = param.getType();
        return type;
    }

    public static String getValidationSignature(ReturnParameter param) {
        String type = param.getType();
        return type;
    }
}

