/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.core.impl;

import com.metamatrix.metamodels.core.CoreMetamodelPlugin;
import com.metamatrix.metamodels.core.CorePackage;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.metamodels.core.ModelType;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelImportImpl
extends EObjectImpl
implements ModelImport {
    public static final String copyright = "Copyright (c) 2000-2005 MetaMatrix Corporation.  All rights reserved.";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String PATH_EDEFAULT = null;
    protected static final String MODEL_LOCATION_EDEFAULT = null;
    protected String modelLocation = MODEL_LOCATION_EDEFAULT;
    protected static final String UUID_EDEFAULT = null;
    protected String uuid = UUID_EDEFAULT;
    protected static final ModelType MODEL_TYPE_EDEFAULT = ModelType.UNKNOWN_LITERAL;
    protected ModelType modelType = MODEL_TYPE_EDEFAULT;
    protected static final String PRIMARY_METAMODEL_URI_EDEFAULT = null;
    protected String primaryMetamodelUri = PRIMARY_METAMODEL_URI_EDEFAULT;
    protected static IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$ModelAnnotation;

    protected ModelImportImpl() {
    }

    protected EClass eStaticClass() {
        return CorePackage.eINSTANCE.getModelImport();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    public String getPath() {
        if (this.modelLocation != null) {
            if (this.modelLocation.startsWith("http") || this.modelLocation.startsWith("mtkplugin:") || this.modelLocation.startsWith("pathmap://UML2_METAMODELS/")) {
                return this.modelLocation;
            }
            if (workspaceRoot != null && this.eResource() != null) {
                IFile iFile;
                URI modelLocationURI;
                URI baseLocationURI = this.eResource().getURI();
                URI uRI = modelLocationURI = baseLocationURI.isFile() ? URI.createURI(this.modelLocation, false) : URI.createURI(this.modelLocation);
                if (baseLocationURI.isHierarchical() && !baseLocationURI.isRelative() && modelLocationURI.isRelative()) {
                    modelLocationURI = modelLocationURI.resolve(baseLocationURI);
                }
                if ((iFile = this.matchUriToIFile(modelLocationURI)) != null) {
                    return ((Object)iFile.getFullPath()).toString();
                }
            }
        }
        return null;
    }

    protected IFile matchUriToIFile(URI uri) {
        File f2;
        if (uri != null && uri.isFile() && (f2 = new File(URI.decode(uri.toFileString()))).exists()) {
            String modelPath = new Path(f2.getAbsolutePath()).toPortableString();
            IProject[] projects = workspaceRoot.getProjects();
            for (int i2 = 0; i2 != projects.length; ++i2) {
                IProject iProj = projects[i2];
                if (!iProj.isOpen() || !modelPath.startsWith(iProj.getLocation().toPortableString())) continue;
                ArrayList iFiles = new ArrayList();
                this.collectIFiles(iProj, iFiles);
                Iterator j2 = iFiles.iterator();
                while (j2.hasNext()) {
                    IFile iFile = (IFile)j2.next();
                    if (!modelPath.equals(iFile.getLocation().toPortableString())) continue;
                    return iFile;
                }
            }
        }
        return null;
    }

    protected void collectIFiles(IContainer iContainer, List result) {
        if (iContainer != null) {
            try {
                IResource[] iResources = iContainer.members();
                for (int i2 = 0; i2 != iResources.length; ++i2) {
                    IResource r2 = iResources[i2];
                    if (!r2.exists()) continue;
                    if (r2.getType() == 1) {
                        result.add(r2);
                        continue;
                    }
                    if (r2.getType() != 2) continue;
                    this.collectIFiles((IContainer)r2, result);
                }
            }
            catch (CoreException e2) {
                CoreMetamodelPlugin.Util.log(e2);
            }
        }
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    public void setModelLocation(String newModelLocation) {
        String oldModelLocation = this.modelLocation;
        this.modelLocation = newModelLocation;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldModelLocation, (Object)this.modelLocation));
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String newUuid) {
        String oldUuid = this.uuid;
        this.uuid = newUuid;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldUuid, (Object)this.uuid));
        }
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public void setModelType(ModelType newModelType) {
        ModelType oldModelType = this.modelType;
        ModelType modelType = this.modelType = newModelType == null ? MODEL_TYPE_EDEFAULT : newModelType;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldModelType, (Object)this.modelType));
        }
    }

    public String getPrimaryMetamodelUri() {
        return this.primaryMetamodelUri;
    }

    public void setPrimaryMetamodelUri(String newPrimaryMetamodelUri) {
        String oldPrimaryMetamodelUri = this.primaryMetamodelUri;
        this.primaryMetamodelUri = newPrimaryMetamodelUri;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPrimaryMetamodelUri, (Object)this.primaryMetamodelUri));
        }
    }

    public ModelAnnotation getModel() {
        if (this.eContainerFeatureID != 6) {
            return null;
        }
        return (ModelAnnotation)((Object)this.eContainer);
    }

    public void setModel(ModelAnnotation newModel) {
        if (newModel != this.eContainer || this.eContainerFeatureID != 6 && newModel != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newModel)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newModel != null) {
                msgs = ((InternalEObject)((Object)newModel)).eInverseAdd(this, 15, class$com$metamatrix$metamodels$core$ModelAnnotation == null ? (class$com$metamatrix$metamodels$core$ModelAnnotation = ModelImportImpl.class$("com.metamatrix.metamodels.core.ModelAnnotation")) : class$com$metamatrix$metamodels$core$ModelAnnotation, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)((Object)newModel), 6, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newModel, (Object)newModel));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 6: {
                    return this.eContainer.eInverseRemove(this, 15, class$com$metamatrix$metamodels$core$ModelAnnotation == null ? (class$com$metamatrix$metamodels$core$ModelAnnotation = ModelImportImpl.class$("com.metamatrix.metamodels.core.ModelAnnotation")) : class$com$metamatrix$metamodels$core$ModelAnnotation, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove(this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getPath();
            }
            case 2: {
                return this.getModelLocation();
            }
            case 3: {
                return this.getUuid();
            }
            case 4: {
                return this.getModelType();
            }
            case 5: {
                return this.getPrimaryMetamodelUri();
            }
            case 6: {
                return this.getModel();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setModelLocation((String)newValue);
                return;
            }
            case 3: {
                this.setUuid((String)newValue);
                return;
            }
            case 4: {
                this.setModelType((ModelType)newValue);
                return;
            }
            case 5: {
                this.setPrimaryMetamodelUri((String)newValue);
                return;
            }
            case 6: {
                this.setModel((ModelAnnotation)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setModelLocation(MODEL_LOCATION_EDEFAULT);
                return;
            }
            case 3: {
                this.setUuid(UUID_EDEFAULT);
                return;
            }
            case 4: {
                this.setModelType(MODEL_TYPE_EDEFAULT);
                return;
            }
            case 5: {
                this.setPrimaryMetamodelUri(PRIMARY_METAMODEL_URI_EDEFAULT);
                return;
            }
            case 6: {
                this.setModel(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return PATH_EDEFAULT == null ? this.getPath() != null : !PATH_EDEFAULT.equals(this.getPath());
            }
            case 2: {
                return MODEL_LOCATION_EDEFAULT == null ? this.modelLocation != null : !MODEL_LOCATION_EDEFAULT.equals(this.modelLocation);
            }
            case 3: {
                return UUID_EDEFAULT == null ? this.uuid != null : !UUID_EDEFAULT.equals(this.uuid);
            }
            case 4: {
                return this.modelType != MODEL_TYPE_EDEFAULT;
            }
            case 5: {
                return PRIMARY_METAMODEL_URI_EDEFAULT == null ? this.primaryMetamodelUri != null : !PRIMARY_METAMODEL_URI_EDEFAULT.equals(this.primaryMetamodelUri);
            }
            case 6: {
                return this.getModel() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", modelLocation: ");
        result.append(this.modelLocation);
        result.append(", uuid: ");
        result.append(this.uuid);
        result.append(", modelType: ");
        result.append(this.modelType);
        result.append(", primaryMetamodelUri: ");
        result.append(this.primaryMetamodelUri);
        result.append(')');
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

