/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.core.custom.impl;

import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.metamodels.core.impl.ModelAnnotationImpl;
import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class XsdModelAnnotationImpl
extends ModelAnnotationImpl
implements ModelAnnotation {
    protected Resource xsdResource;

    public XsdModelAnnotationImpl() {
    }

    public XsdModelAnnotationImpl(Resource xsdResource) {
        this.xsdResource = xsdResource;
    }

    public Resource getResource() {
        return this.xsdResource;
    }

    public void setResource(Resource xsdResource) {
        this.xsdResource = xsdResource;
    }

    public void setExtensionPackage(XPackage newExtensionPackage) {
        super.setExtensionPackage(newExtensionPackage);
        if (this.xsdResource != null) {
            EAttribute eAttrib;
            this.xsdResource.setModified(true);
            EObject schema = this.getSchema(this.xsdResource);
            if (schema != null && (eAttrib = this.getTargetNamespaceAttribute(schema)) != null) {
                Object origValue = schema.eGet(eAttrib);
                schema.eSet(eAttrib, null);
                schema.eSet(eAttrib, origValue);
            }
        }
    }

    private EObject getSchema(Resource resource) {
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            EClass eClass;
            Object root = iter.next();
            if (!(root instanceof EObject) || !(eClass = ((EObject)root).eClass()).getName().equalsIgnoreCase("XSDSchema")) continue;
            return (EObject)root;
        }
        return null;
    }

    private EAttribute getTargetNamespaceAttribute(EObject eObject) {
        EClass eClass = eObject.eClass();
        return (EAttribute)eClass.getEStructuralFeature("targetNamespace");
    }
}

