/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.platform.client.ServerAdminFactory;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class MMServerConnection
extends MMConnection {
    private static final String SERVER_NAME = "MetaMatrix Enterprise";
    ServerAdmin serverAdmin;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMServerConnection;
    static /* synthetic */ Class class$com$metamatrix$common$comm$api$ServerConnection;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$lang$String;

    public static MMServerConnection newInstance(ServerConnection serverConn, Properties info, String url) {
        if (AOP.useproxy()) {
            return (MMServerConnection)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$MMServerConnection == null ? (class$com$metamatrix$jdbc$MMServerConnection = MMServerConnection.class$("com.metamatrix.jdbc.MMServerConnection")) : class$com$metamatrix$jdbc$MMServerConnection), (Class[])new Class[]{class$com$metamatrix$common$comm$api$ServerConnection == null ? (class$com$metamatrix$common$comm$api$ServerConnection = MMServerConnection.class$("com.metamatrix.common.comm.api.ServerConnection")) : class$com$metamatrix$common$comm$api$ServerConnection, class$java$util$Properties == null ? (class$java$util$Properties = MMServerConnection.class$("java.util.Properties")) : class$java$util$Properties, class$java$lang$String == null ? (class$java$lang$String = MMServerConnection.class$("java.lang.String")) : class$java$lang$String}, (Object[])new Object[]{serverConn, info, url});
        }
        return new MMServerConnection(serverConn, info, url);
    }

    public MMServerConnection(ServerConnection serverConn, Properties info, String url) {
        super(serverConn, info, url);
    }

    public synchronized Admin getAdminAPI() throws SQLException {
        try {
            if (this.serverAdmin == null) {
                String serverUrl = MMServerConnection.getServerURL(this.getUrl());
                ServerAdminFactory factory = ServerAdminFactory.getInstance();
                this.serverAdmin = factory.createAdmin(this.getUserName(), this.getPassword().toCharArray(), serverUrl);
            }
        }
        catch (AdminException e2) {
            throw new SQLException(e2.getMessage());
        }
        catch (LogonException e3) {
            throw new SQLException(e3.getMessage());
        }
        return this.serverAdmin;
    }

    public synchronized void close() throws SQLException {
        super.close();
        if (this.serverAdmin != null) {
            this.serverAdmin.close();
        }
    }

    protected static String getServerURL(String jdbcURLString) {
        MMJDBCURL jdbcURL = new MMJDBCURL(jdbcURLString);
        return jdbcURL.getConnectionURL();
    }

    String getDatabaseName() {
        return SERVER_NAME;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return super.getMetaData(new MMDriver());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

