/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class JDBCLogger
implements Logger {
    static final String PLUGIN_ID = "JDBC";
    LogListener listener = null;
    int allowedSeverity = 0;
    int connectonId = 0;

    public JDBCLogger(int severity, LogListener listener, int connId) {
        this.allowedSeverity = severity;
        this.listener = listener;
        this.connectonId = connId;
    }

    long currentTime() {
        return System.currentTimeMillis();
    }

    String threadName() {
        return Thread.currentThread().getName();
    }

    int connectionId() {
        return this.connectonId;
    }

    private boolean allow(int level) {
        return this.converToJDBCLogLevel(level) <= this.allowedSeverity;
    }

    private int converToJDBCLogLevel(int messageLevel) {
        switch (messageLevel) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        return 0;
    }

    private int convertToIStatusLevel(int messageLevel) {
        switch (messageLevel) {
            case 1: 
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        return 1;
    }

    public void log(IStatus status) {
        throw new RuntimeException();
    }

    public void log(int severity, String message) {
        this.log(severity, null, message);
    }

    public void log(int severity, Throwable t2, String message) {
        if (message != null && this.allow(severity)) {
            Status status = new Status(this.convertToIStatusLevel(severity), PLUGIN_ID, this.connectionId(), message, t2);
            this.listener.logMessage(status, this.currentTime(), PLUGIN_ID, this.threadName());
        }
    }

    public void log(Object obj) {
        if (obj != null) {
            this.log(4, null, obj.toString());
        }
    }

    public void log(Throwable t2) {
        if (t2 != null && this.allow(2)) {
            Status status = new Status(4, PLUGIN_ID, this.connectionId(), "", t2);
            this.listener.logMessage(status, this.currentTime(), PLUGIN_ID, this.threadName());
        }
    }
}

