/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.core.log.Logger;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.metadata.ResultsMetadataConstants;
import com.metamatrix.jdbc.AbstractMetadataProvider;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.StaticMetadataProvider;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DeferredMetadataProvider
extends AbstractMetadataProvider {
    private static final String MESSAGE_KEY_PREFIX = "METADATA_";
    private StaticMetadataProvider staticProvider;
    private MMStatement statement;
    private RequestID requestID = null;
    static /* synthetic */ Class class$com$metamatrix$jdbc$DeferredMetadataProvider;

    DeferredMetadataProvider() {
    }

    public static DeferredMetadataProvider createWithInitialData(String[] columnNames, String[] columnTypes, MMStatement statement, RequestID requestID, Logger logger) {
        if (columnNames == null || columnTypes == null || columnNames.length != columnTypes.length) {
            Object[] params = new Object[]{StringUtil.toString(columnNames), StringUtil.toString(columnTypes)};
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("DeferredMetadataProvider.Invalid_data", params));
        }
        DeferredMetadataProvider provider = null;
        provider = AOP.useproxy() ? (DeferredMetadataProvider)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$DeferredMetadataProvider == null ? (class$com$metamatrix$jdbc$DeferredMetadataProvider = DeferredMetadataProvider.class$("com.metamatrix.jdbc.DeferredMetadataProvider")) : class$com$metamatrix$jdbc$DeferredMetadataProvider)) : new DeferredMetadataProvider();
        provider.setLogger(logger);
        provider.setDeferredLookupAttributes(statement, requestID);
        provider.loadPartialMetadata(columnNames, columnTypes);
        return provider;
    }

    private void setDeferredLookupAttributes(MMStatement statement, RequestID requestID) {
        this.statement = statement;
        this.requestID = requestID;
    }

    private void loadPartialMetadata(String[] columnNames, String[] columnTypes) {
        Map[] columnMetadata = new Map[columnNames.length];
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            columnMetadata[i2] = new HashMap();
            columnMetadata[i2].put(ResultsMetadataConstants.ELEMENT_NAME, columnNames[i2]);
            columnMetadata[i2].put(ResultsMetadataConstants.DATA_TYPE, columnTypes[i2]);
        }
        this.staticProvider = StaticMetadataProvider.createWithData(columnMetadata, -1, this.getLogger());
    }

    private synchronized void loadFullMetadata() throws SQLException {
        MetaDataMessage metadataMsg = new MetaDataMessage();
        metadataMsg.setRequestID(this.requestID);
        metadataMsg.setMessageKey(MESSAGE_KEY_PREFIX + this.requestID);
        Message results = this.statement.executeAsynchAndWait(metadataMsg, false);
        if (results instanceof MessageHolder) {
            MessageHolder holder = (MessageHolder)results;
            ExceptionHolder exHolder = (ExceptionHolder)holder.contents;
            throw MMSQLException.create(exHolder.exception);
        }
        MetaDataMessage returnedMetadataMsg = (MetaDataMessage)results;
        this.staticProvider = StaticMetadataProvider.createWithData(returnedMetadataMsg.getMetadataMap(), returnedMetadataMsg.getParameterCount(), this.getLogger());
    }

    public int getColumnCount() throws SQLException {
        return this.staticProvider.getColumnCount();
    }

    public Object getValue(int columnIndex, Integer metadataPropertyKey) throws SQLException {
        Object value = this.staticProvider.getValue(columnIndex, metadataPropertyKey);
        if (value == null) {
            this.loadFullMetadata();
            value = this.staticProvider.getValue(columnIndex, metadataPropertyKey);
        }
        return value;
    }

    public int getParameterCount() throws SQLException {
        int count = this.staticProvider.getParameterCount();
        if (count < 0) {
            this.loadFullMetadata();
            count = this.staticProvider.getParameterCount();
        }
        return count;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

