/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xsd;

import com.metamatrix.internal.core.xml.xsd.XsdHeader;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TerminatingXsdHeaderContentHandler
extends DefaultHandler {
    public static final String SCHEMA_NOT_FOUND_EXCEPTION_MESSAGE = "SchemaNotFoundException";
    public static final String SCHEMA_FOUND_EXCEPTION_MESSAGE = "SchemaFoundException";
    private static final String SCHEMA_TAG_NAME = "schema";
    private static final String IMPORT_TAG_NAME = "import";
    private static final String INCLUDE_TAG_NAME = "include";
    private static final String REDEFINE_TAG_NAME = "redefine";
    private static final String ANNOTATION_TAG_NAME = "annotation";
    private static final String DOCUMENTATION_TAG_NAME = "documentation";
    private static final String APPINFO_TAG_NAME = "appinfo";
    private static final String TARGET_NAMESPACE_ATTRIBUTE_NAME = "targetNamespace";
    private static final String NAMESPACE_ATTRIBUTE_NAME = "namespace";
    private static final String SCHEMA_LOCATION_ATTRIBUTE_NAME = "schemaLocation";
    private boolean foundSchemaStartElement = false;
    private boolean foundTerminatingTag = false;
    private XsdHeader header;

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getXsdHeader().addNamespaceURI(uri);
        super.startPrefixMapping(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (SCHEMA_TAG_NAME.equals(localName)) {
            this.processAttributes(atts);
            this.foundSchemaStartElement = true;
        } else if (IMPORT_TAG_NAME.equals(localName)) {
            this.processImportAttributes(atts);
        } else if (INCLUDE_TAG_NAME.equals(localName)) {
            this.processIncludeAttributes(atts);
        } else if (!(REDEFINE_TAG_NAME.equals(localName) || ANNOTATION_TAG_NAME.equals(localName) || DOCUMENTATION_TAG_NAME.equals(localName) || APPINFO_TAG_NAME.equals(localName))) {
            this.foundTerminatingTag = true;
        }
        this.checkForCompletion();
        super.startElement(uri, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.checkForCompletion();
        super.endElement(namespaceURI, localName, qName);
    }

    public XsdHeader getXsdHeader() {
        if (this.header == null) {
            this.header = new XsdHeader();
        }
        return this.header;
    }

    private void checkForCompletion() throws SAXException {
        if (!this.foundSchemaStartElement) {
            throw new SAXException(SCHEMA_NOT_FOUND_EXCEPTION_MESSAGE);
        }
        if (this.foundTerminatingTag) {
            throw new SAXException(SCHEMA_FOUND_EXCEPTION_MESSAGE);
        }
    }

    private void processAttributes(Attributes atts) {
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String name = atts.getLocalName(i2);
            String value = atts.getValue(i2);
            if (!TARGET_NAMESPACE_ATTRIBUTE_NAME.equals(name)) continue;
            this.getXsdHeader().setTargetNamespaceURI(value);
        }
    }

    private void processImportAttributes(Attributes atts) {
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String name = atts.getLocalName(i2);
            String value = atts.getValue(i2);
            if (NAMESPACE_ATTRIBUTE_NAME.equals(name)) {
                this.getXsdHeader().addImportNamespaceURI(value);
                continue;
            }
            if (!SCHEMA_LOCATION_ATTRIBUTE_NAME.equals(name)) continue;
            this.getXsdHeader().addImportSchemaLocation(value);
        }
    }

    private void processIncludeAttributes(Attributes atts) {
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String name = atts.getLocalName(i2);
            String value = atts.getValue(i2);
            if (!SCHEMA_LOCATION_ATTRIBUTE_NAME.equals(name)) continue;
            this.getXsdHeader().addIncludeSchemaLocation(value);
        }
    }
}

