/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.xmi;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMIHeaderReaderOld {
    private static final String XMI_TAG_NAME = "XMI";
    private static final String MODEL_ANNOTATION_TAG_NAME = "ModelAnnotation";
    private static final String UUID_ATTRIBUTE_NAME = "uuid";
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    private static final String PRIMARY_URI_ATTRIBUTE_NAME = "primaryMetamodelUri";
    private static final String MODEL_TYPE_ATTRIBUTE_NAME = "modelType";

    public static XMIHeader readHeader(InputStream istream) throws MetaMatrixCoreException {
        XMIHeaderReaderOld reader = new XMIHeaderReaderOld();
        return reader.read(istream);
    }

    public XMIHeader read(InputStream istream) throws MetaMatrixCoreException {
        if (istream == null) {
            ArgCheck.isNotNull(istream, CorePlugin.Util.getString("XMIHeaderReader.The_InputStream_reference_may_not_be_null._1"));
        }
        StoppableSAXBuilder builder = new StoppableSAXBuilder();
        builder.setValidation(false);
        Document doc = null;
        try {
            doc = builder.build(istream);
        }
        catch (IOException e2) {
            this.handleException(e2);
            doc = builder.getDocument();
        }
        catch (JDOMException e3) {
            this.handleException(e3);
            doc = builder.getDocument();
        }
        return this.buildXMIHeader(doc);
    }

    private void handleException(Exception e2) throws MetaMatrixCoreException {
        if (e2.getCause() instanceof SAXParseException) {
            throw new MetaMatrixCoreException((Throwable)e2, CorePlugin.Util.getString("XMIHeaderReader.File_is_not_a_valid_XMI_format_2"));
        }
        if (e2.getCause() instanceof XMINotFoundException) {
            throw new MetaMatrixCoreException((Throwable)e2, CorePlugin.Util.getString("XMIHeaderReader.File_is_not_a_valid_XMI_format_2"));
        }
        if (!(e2.getCause() instanceof HeaderFoundException)) {
            throw new MetaMatrixCoreException((Throwable)e2, CorePlugin.Util.getString("XMIHeaderReader.Error_in_parsing_file_3"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMIHeader read(File file) throws MetaMatrixCoreException {
        XMIHeader xMIHeader;
        if (file == null) {
            ArgCheck.isNotNull(file, CorePlugin.Util.getString("XMIHeaderReader.The_File_reference_may_not_be_null._4"));
        }
        if (!file.exists()) {
            ArgCheck.isTrue(file.exists(), CorePlugin.Util.getString("XMIHeaderReader.The_file_does_not_exists_and_therefore_cannot_be_read._5", file));
        }
        if (!file.canRead()) {
            ArgCheck.isTrue(file.canRead(), CorePlugin.Util.getString("XMIHeaderReader.The_file_does_not_have_read_privileges._6", file));
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                xMIHeader = this.read(bis);
                Object var6_6 = null;
                if (bis == null) return xMIHeader;
            }
            catch (FileNotFoundException e3) {
                throw new MetaMatrixCoreException((Throwable)e3, CorePlugin.Util.getString("XMIHeaderReader.Error_in_parsing__7", file));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bis == null) throw throwable;
            try {
                bis.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return xMIHeader;
        }
        bis.close();
        return xMIHeader;
    }

    private XMIHeader buildXMIHeader(Document doc) {
        XMIHeader header = new XMIHeader();
        Element root = doc.getRootElement();
        header.addNamespaceURI(root.getNamespaceURI());
        Iterator iter = root.getAdditionalNamespaces().iterator();
        while (iter.hasNext()) {
            Namespace ns = (Namespace)iter.next();
            header.addNamespaceURI(ns.getURI());
        }
        this.setAnnotationValues(root, header);
        Iterator iter2 = root.getChildren().iterator();
        while (iter2.hasNext()) {
            Element child = (Element)iter2.next();
            if (!child.getName().equalsIgnoreCase(MODEL_ANNOTATION_TAG_NAME)) continue;
            this.setAnnotationValues(child, header);
        }
        return header;
    }

    private void setAnnotationValues(Element element, XMIHeader header) {
        Iterator iter = element.getAttributes().iterator();
        while (iter.hasNext()) {
            Attribute attrib = (Attribute)iter.next();
            if (attrib.getName().equalsIgnoreCase(UUID_ATTRIBUTE_NAME)) {
                header.setUUID(attrib.getValue());
                continue;
            }
            if (attrib.getName().equalsIgnoreCase(DESCRIPTION_ATTRIBUTE_NAME)) {
                header.setDescription(attrib.getValue());
                continue;
            }
            if (attrib.getName().equalsIgnoreCase(PRIMARY_URI_ATTRIBUTE_NAME)) {
                header.setPrimaryMetamodelURI(attrib.getValue());
                continue;
            }
            if (!attrib.getName().equalsIgnoreCase(MODEL_TYPE_ATTRIBUTE_NAME)) continue;
            header.setModelType(attrib.getValue());
        }
    }

    private static class XMINotFoundException
    extends SAXException {
        XMINotFoundException() {
            super(CorePlugin.Util.getString("XMIHeaderReader.XMI_element_was_not_found;_file_is_likely_not_a_valid_XMI_model_9"));
        }
    }

    private static class HeaderFoundException
    extends SAXException {
        HeaderFoundException() {
            super(CorePlugin.Util.getString("XMIHeaderReader.Header_element_was_successfully_found._(This_is_not_an_error.)_8"));
        }
    }

    private class StoppableSAXHandler
    extends SAXHandler {
        private boolean foundXmiStartElement = false;
        private boolean foundAnnotationStartElement = false;
        private boolean foundAnnotationEndElement = false;

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equalsIgnoreCase(XMIHeaderReaderOld.XMI_TAG_NAME)) {
                this.foundXmiStartElement = true;
            } else if (localName.equalsIgnoreCase(XMIHeaderReaderOld.MODEL_ANNOTATION_TAG_NAME)) {
                this.foundAnnotationStartElement = true;
            }
            this.checkForCompletion();
            super.startElement(uri, localName, qName, attributes);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.checkForCompletion();
            if (localName.equals(XMIHeaderReaderOld.MODEL_ANNOTATION_TAG_NAME)) {
                this.foundAnnotationEndElement = true;
            }
            super.endElement(namespaceURI, localName, qName);
        }

        private void checkForCompletion() throws HeaderFoundException, XMINotFoundException {
            if (!this.foundXmiStartElement) {
                throw new XMINotFoundException();
            }
            if (this.foundAnnotationStartElement && this.foundAnnotationEndElement) {
                throw new HeaderFoundException();
            }
        }
    }

    private class StoppableSAXBuilder
    extends SAXBuilder {
        private StoppableSAXHandler handler;

        private StoppableSAXBuilder() {
        }

        protected SAXHandler createContentHandler() {
            this.handler = new StoppableSAXHandler();
            return this.handler;
        }

        Document getDocument() {
            if (this.handler.foundAnnotationEndElement) {
                return this.handler.getDocument();
            }
            return null;
        }
    }
}

