/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.log;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.SystemLogWriter;
import com.metamatrix.internal.core.log.ShutdownThread;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class PlatformLog
implements LogListener {
    private static final PlatformLog INSTANCE = new PlatformLog();
    private static ShutdownThread SHUTDOWNTHREAD = null;
    private static final String SHUTDOWN_HOOK_INSTALLED_PROPERTY = "shutdownHookInstalled";
    private static final String DEFAULT_LOG_WORKER_THREAD_NAME = "LogWorker";
    public static final long DEFAULT_DEQUEUE_TIMEOUT = 5000L;
    public static final int DEFAULT_MAX_NUMBER_OF_TIMEOUTS = 20;
    public static final long SHUTDOWN_TIMEOUT = 20000L;
    private static final long WAIT_INTERVAL_MILLIS = 1000L;
    private static boolean DEBUG_PLATFORM_LOG;
    private static final PrintStream DEBUG_STREAM;
    private final Channel queue;
    private final List logListeners;
    private LogWorker worker;
    private String name;
    private final Object workerLock = new Object();
    private boolean shutdownRequested = false;
    private long dequeueTimeout = 5000L;
    private int maximumNumberOfTimeouts = 20;

    public static PlatformLog getInstance() {
        return INSTANCE;
    }

    public PlatformLog() {
        this(DEFAULT_LOG_WORKER_THREAD_NAME);
    }

    public PlatformLog(String name) {
        this.queue = new LinkedQueue();
        this.logListeners = new ArrayList();
        this.name = name;
    }

    public List getLogListeners() {
        ArrayList al2 = new ArrayList(this.logListeners);
        return al2;
    }

    public static void deregisterShutdownHook() {
        try {
            if (SHUTDOWNTHREAD != null) {
                Runtime.getRuntime().removeShutdownHook(SHUTDOWNTHREAD);
            }
        }
        catch (IllegalStateException e2) {
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean processRemainingContent) {
        if (!this.shutdownRequested) {
            boolean workerExists = false;
            Object object = this.workerLock;
            synchronized (object) {
                if (this.worker != null) {
                    workerExists = true;
                    this.shutdownRequested = true;
                    if (processRemainingContent) {
                        this.worker.shutdown();
                    } else {
                        this.worker.shutdownNow();
                    }
                }
            }
            if (workerExists) {
                this.waitMethod(1000L);
            }
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("PlatformLog has been shutdown");
            }
            object = this.logListeners;
            synchronized (object) {
                Iterator iter = this.logListeners.iterator();
                while (iter.hasNext()) {
                    LogListener listener = (LogListener)iter.next();
                    try {
                        listener.shutdown();
                    }
                    catch (Throwable t2) {}
                }
                this.logListeners.clear();
            }
        }
    }

    public void setShutdownRequested(boolean value) {
        this.shutdownRequested = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureWorkerExists() {
        Object object = this.workerLock;
        synchronized (object) {
            if (this.worker == null || this.worker.stopped) {
                if (DEBUG_PLATFORM_LOG) {
                    DEBUG_STREAM.println("Creating and starting a new LogWorker");
                }
                this.worker = new LogWorker(this.name, this.queue, this.dequeueTimeout, this.maximumNumberOfTimeouts);
                this.worker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseWorker(LogWorker releasedWorker) {
        Object object = this.workerLock;
        synchronized (object) {
            if (this.worker == releasedWorker) {
                if (DEBUG_PLATFORM_LOG) {
                    DEBUG_STREAM.println("Releasing the current LogWorker");
                }
                this.worker = null;
            }
        }
        this.notifyMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitMethod(long timeout) {
        try {
            int numTimes = timeout > 0L ? (int)(20000L / timeout + 1L) : 1;
            for (int i2 = 0; i2 != numTimes; ++i2) {
                LogWorker workerRef = null;
                Object object = this.workerLock;
                synchronized (object) {
                    workerRef = this.worker;
                }
                if (workerRef == null) {
                    if (DEBUG_PLATFORM_LOG) {
                        DEBUG_STREAM.println("PlatformLog.waitMethod returning because worker has been released");
                    }
                    return;
                }
                this.wait(timeout);
            }
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("PlatformLog.waitMethod returning because timeout exceeded");
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    private synchronized void notifyMethod() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LogListener listener) {
        if (listener != null) {
            List list = this.logListeners;
            synchronized (list) {
                this.logListeners.remove(listener);
                if (DEBUG_PLATFORM_LOG) {
                    DEBUG_STREAM.println("Adding to PlatformLog a new log listener " + listener);
                }
                this.logListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LogListener listener) {
        if (listener != null) {
            List list = this.logListeners;
            synchronized (list) {
                if (DEBUG_PLATFORM_LOG) {
                    DEBUG_STREAM.println("Removing from PlatformLog log listener " + listener);
                }
                listener.shutdown();
                this.logListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(IStatus status, long timestamp, String pluginID, String threadName) {
        LogListener[] listeners;
        List list = this.logListeners;
        synchronized (list) {
            listeners = this.logListeners.toArray(new LogListener[this.logListeners.size()]);
        }
        if (listeners.length == 0) {
            return;
        }
        Message messageObj = new Message(status, listeners, pluginID, threadName);
        try {
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("Enqueuing message " + messageObj);
            }
            this.queue.put(messageObj);
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        this.ensureWorkerExists();
    }

    public void waitForProcessing(long mswait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < mswait && this.queue.peek() != null) {
        }
    }

    static {
        String hook = System.getProperty(SHUTDOWN_HOOK_INSTALLED_PROPERTY);
        if (hook == null || hook.equalsIgnoreCase(String.valueOf(Boolean.FALSE))) {
            SHUTDOWNTHREAD = new ShutdownThread(INSTANCE);
            INSTANCE.addListener(new SystemLogWriter());
            try {
                Runtime.getRuntime().addShutdownHook(SHUTDOWNTHREAD);
                System.setProperty(SHUTDOWN_HOOK_INSTALLED_PROPERTY, Boolean.TRUE.toString());
            }
            catch (IllegalStateException e2) {
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
        DEBUG_PLATFORM_LOG = false;
        DEBUG_STREAM = System.err;
    }

    class LogWorker
    extends Thread {
        private Channel channel;
        private boolean stopped = false;
        private boolean stopImmediately = false;
        private long timeout;
        private int maxTimeouts;
        private int numTimeouts;

        LogWorker(String name, Channel channel, long timeout, int maxTimeouts) {
            super(name);
            this.channel = channel;
            this.timeout = timeout;
            this.maxTimeouts = maxTimeouts;
            this.numTimeouts = 0;
            this.setDaemon(true);
        }

        public void run() {
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("LogWorker is starting");
            }
            while (!this.stopImmediately) {
                try {
                    Runnable runnable;
                    if (DEBUG_PLATFORM_LOG) {
                        DEBUG_STREAM.println("Polling ...");
                    }
                    if ((runnable = (Runnable)this.channel.poll(this.timeout)) != null) {
                        if (DEBUG_PLATFORM_LOG) {
                            DEBUG_STREAM.println("Processing message " + runnable);
                        }
                        if (this.stopImmediately) {
                            while (this.channel.poll(0L) != null) {
                            }
                            continue;
                        }
                        runnable.run();
                        this.numTimeouts = 0;
                        continue;
                    }
                    if (DEBUG_PLATFORM_LOG) {
                        DEBUG_STREAM.println("Found no message to process");
                    }
                    if (this.stopped) {
                        if (this.numTimeouts < this.maxTimeouts) {
                            this.numTimeouts = this.maxTimeouts - 1;
                        }
                        this.timeout = 1000L;
                        this.stopped = false;
                        continue;
                    }
                    ++this.numTimeouts;
                    if (this.numTimeouts <= this.maxTimeouts) continue;
                    this.stopped = true;
                    break;
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            if (DEBUG_PLATFORM_LOG) {
                if (this.stopImmediately) {
                    DEBUG_STREAM.println("LogWorker has been stopped immediately; requesting release");
                } else {
                    DEBUG_STREAM.println("LogWorker has completed; requesting release");
                }
            }
            PlatformLog.this.releaseWorker(this);
        }

        void shutdown() {
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("LogWorker requested to shutdown");
            }
            this.stopped = true;
        }

        void shutdownNow() {
            if (DEBUG_PLATFORM_LOG) {
                DEBUG_STREAM.println("LogWorker requested to shutdown immediately");
            }
            this.stopped = true;
            this.stopImmediately = true;
        }
    }

    class Message
    implements Runnable {
        private final IStatus status;
        private final long timestamp = System.currentTimeMillis();
        private final LogListener[] listeners;
        private final String pluginID;
        private final String threadName;

        Message(IStatus status, LogListener[] listeners, String pluginID, String threadName) {
            this.status = status;
            this.listeners = listeners;
            this.pluginID = pluginID;
            this.threadName = threadName;
        }

        public void run() {
            for (int i2 = 0; i2 < this.listeners.length; ++i2) {
                LogListener listener = this.listeners[i2];
                listener.logMessage(this.status, this.timestamp, this.pluginID, this.threadName);
            }
        }

        public String toString() {
            return this.status.getMessage();
        }
    }
}

