/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.log;

import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.internal.core.log.BasePlatformLogWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.core.runtime.IStatus;

public class PlatformLimitSizeLogWriter
extends BasePlatformLogWriter {
    protected Writer outLog = null;
    protected Writer errorLog = null;
    protected FileOutputStream fos = null;
    protected OutputStreamWriter osw = null;
    protected BufferedWriter logBufferedWriter = null;
    protected OutputStreamWriter logStreamWriter = null;
    protected PrintStream ps = null;
    private boolean resetSystemStreams = true;

    public PlatformLimitSizeLogWriter(File file) {
        super(file);
        this.ps = System.out;
        this.openLogFile();
    }

    public PlatformLimitSizeLogWriter(File file, boolean resetSystemStreams) {
        super(file);
        this.resetSystemStreams = resetSystemStreams;
        this.openLogFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logMessage(IStatus status, long timestamp, String pluginID, String threadName) {
        try {
            block9: {
                boolean isError = false;
                try {
                    if (status.getSeverity() == 4) {
                        PlatformLimitSizeLogWriter.write(this.errorLog, status, timestamp, threadName, null, 0);
                        isError = true;
                    } else {
                        PlatformLimitSizeLogWriter.write(this.outLog, status, timestamp, threadName, null, 0);
                    }
                    Object var8_7 = null;
                    if (!isError) break block9;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (isError) {
                        this.errorLog.flush();
                        throw throwable;
                    }
                    this.outLog.flush();
                    throw throwable;
                }
                this.errorLog.flush();
                return;
            }
            this.outLog.flush();
            return;
        }
        catch (Exception e2) {
            System.err.println("An exception occurred while writing to the platform log:");
            e2.printStackTrace(System.err);
            System.err.println("Logging to the console instead.");
            try {
                Writer log = this.logForStream(System.err);
                PlatformLimitSizeLogWriter.write(log, status, timestamp, threadName, null, 0);
                log.flush();
                return;
            }
            catch (Exception e22) {
                System.err.println("An exception occurred while logging to the console:");
                e22.printStackTrace(System.err);
            }
        }
    }

    protected static void write(Writer log, String message) throws IOException {
        if (message != null) {
            log.write(message.trim());
            log.flush();
        }
    }

    protected void openLogFile() {
        try {
            File parent = this.getLogFile().getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            this.fos = new FileOutputStream(this.getLogFile().getAbsolutePath(), false);
            this.ps = new PrintStream(this.fos);
            if (this.resetSystemStreams) {
                System.setOut(this.ps);
                System.setErr(this.ps);
            }
            this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF-8");
            this.errorLog = this.outLog = new BufferedWriter(this.osw);
            this.writeHeader(this.outLog);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.closeLogFile();
            try {
                this.outLog = this.logForStream(System.out);
                this.errorLog = this.logForStream(System.err);
            }
            catch (Exception e22) {
                e22.printStackTrace();
            }
        }
    }

    protected Writer logForStream(OutputStream output) throws Exception {
        try {
            this.logStreamWriter = new OutputStreamWriter(output, "UTF-8");
            this.logBufferedWriter = new BufferedWriter(this.logStreamWriter);
            return this.logBufferedWriter;
        }
        catch (UnsupportedEncodingException e2) {
            this.logStreamWriter = new OutputStreamWriter(output);
            this.logBufferedWriter = new BufferedWriter(this.logStreamWriter);
            return this.logBufferedWriter;
        }
    }

    public void shutdown() {
        try {
            this.closeLogFile();
            this.setLogFile(null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeLogFile() {
        if (this.outLog != null) {
            try {
                this.outLog.flush();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (this.errorLog != null) {
            try {
                this.errorLog.flush();
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        if (this.logBufferedWriter != null) {
            try {
                this.logBufferedWriter.flush();
            }
            catch (Exception e4) {
                // empty catch block
            }
        }
        if (this.logStreamWriter != null) {
            try {
                this.logStreamWriter.flush();
            }
            catch (Exception e5) {
                // empty catch block
            }
        }
        if (this.osw != null) {
            try {
                this.osw.flush();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (this.fos != null) {
            try {
                this.fos.flush();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (this.outLog != null) {
            try {
                this.outLog.close();
            }
            catch (Exception e6) {
                e6.printStackTrace();
            }
            finally {
                this.outLog = null;
            }
        }
        if (this.errorLog != null) {
            try {
                this.errorLog.close();
            }
            catch (Exception e7) {
                e7.printStackTrace();
            }
            finally {
                this.errorLog = null;
            }
        }
        if (this.logBufferedWriter != null) {
            try {
                this.logBufferedWriter.close();
            }
            catch (Exception e8) {
                e8.printStackTrace();
            }
            finally {
                this.logBufferedWriter = null;
            }
        }
        if (this.logStreamWriter != null) {
            try {
                this.logStreamWriter.close();
            }
            catch (Exception e9) {
                e9.printStackTrace();
            }
            finally {
                this.logStreamWriter = null;
            }
        }
        if (this.osw != null) {
            try {
                this.osw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                this.osw = null;
            }
        }
        if (this.ps != null) {
            this.ps.flush();
            this.ps.close();
            this.ps = null;
        }
        if (this.fos != null) {
            try {
                this.fos.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                this.fos = null;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PlatformLimitSizeLogWriter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlatformLimitSizeLogWriter that = (PlatformLimitSizeLogWriter)obj;
        if (this.getLogFile() != null) {
            return this.getLogFile().equals(that.getLogFile());
        }
        if (that.getLogFile() != null) {
            return false;
        }
        return this.outLog == that.outLog && this.errorLog == that.errorLog;
    }

    public int hashCode() {
        int hash = 0;
        if (this.getLogFile() != null) {
            hash = HashCodeUtil.hashCode(hash, this.getLogFile());
        } else {
            hash = HashCodeUtil.hashCode(hash, this.outLog);
            hash = HashCodeUtil.hashCode(hash, this.errorLog);
        }
        return hash;
    }

    public String toString() {
        if (this.getLogFile() != null) {
            return "PlatformLimitSizeLogWriter " + this.getLogFile();
        }
        if (this.outLog != this.errorLog) {
            return "PlatformLimitSizeLogWriter " + this.outLog + "/" + this.errorLog;
        }
        return "PlatformLimitSizeLogWriter " + this.outLog;
    }

    public void setResetSystemStreams(boolean resetSystemStreams) {
        this.resetSystemStreams = resetSystemStreams;
    }
}

