/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.log;

import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.util.ArgCheck;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public abstract class BasePlatformLogWriter
implements LogListener {
    protected static final String PASSWORD = "-password";
    public static final String TIMESTAMP_FORMAT = "MMM dd, yyyy HH:mm:ss.SSS";
    static DateFormat DATE_FORMATTER = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SSS");
    static final String SESSION = "Session";
    static final String LEFT_BRACKET = " [";
    static final String RIGHT_BRACKET = "] ";
    static final String RIGHT = "> ";
    static final String LEFT = " <";
    static final char CENTER = '|';
    static final String LINE_SEPARATOR;
    static final String TAB_STRING = "\t";
    private static final boolean ALWAYS_WRITE_STACK_TRACE = false;
    private File logFile = null;

    protected BasePlatformLogWriter() {
    }

    public BasePlatformLogWriter(File file) {
        ArgCheck.isNotNull(file, "BasePlatformLogWriter requires the file to be specified.");
        this.logFile = file;
    }

    public abstract void logMessage(IStatus var1, long var2, String var4, String var5);

    public abstract void shutdown();

    protected File getLogFile() {
        return this.logFile;
    }

    protected void setLogFile(File f2) {
        this.logFile = f2;
    }

    protected void writeHeader(Writer log) throws IOException {
        BasePlatformLogWriter.write(log, SESSION);
        BasePlatformLogWriter.writeSpace(log);
        String date = BasePlatformLogWriter.getDate(System.currentTimeMillis());
        BasePlatformLogWriter.write(log, date);
        BasePlatformLogWriter.writeSpace(log);
        for (int i2 = SESSION.length() + date.length(); i2 < 78; ++i2) {
            BasePlatformLogWriter.write(log, "-");
        }
        BasePlatformLogWriter.writeln(log);
        try {
            String key = "java.fullversion";
            String value = System.getProperty(key);
            if (value == null) {
                key = "java.version";
                value = System.getProperty(key);
                BasePlatformLogWriter.writeln(log, key + "=" + value);
                key = "java.vendor";
                value = System.getProperty(key);
                BasePlatformLogWriter.writeln(log, key + "=" + value);
            } else {
                BasePlatformLogWriter.writeln(log, key + "=" + value);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            BasePlatformLogWriter.write(log, "BootLoader constants: OS=" + Platform.getOS());
            BasePlatformLogWriter.write(log, ", ARCH=" + Platform.getOSArch());
            BasePlatformLogWriter.write(log, ", WS=" + Platform.getWS());
            BasePlatformLogWriter.writeln(log, ", NL=" + Platform.getNL());
            String[] args = Platform.getCommandLineArgs();
            if (args != null && args.length > 0) {
                BasePlatformLogWriter.write(log, "Command-line arguments:");
                for (int i3 = 0; i3 < args.length; ++i3) {
                    if (i3 > 0 && PASSWORD.equals(args[i3 - 1])) {
                        BasePlatformLogWriter.write(log, " (omitted)");
                        continue;
                    }
                    BasePlatformLogWriter.write(log, " " + args[i3]);
                }
                BasePlatformLogWriter.writeln(log);
            }
        }
        catch (IOException e1) {
            throw e1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static String getDate(long timestamp) {
        try {
            return DATE_FORMATTER.format(new Date(timestamp));
        }
        catch (Exception exception) {
            return Long.toString(timestamp);
        }
    }

    protected static void write(Writer log, IStatus status, long timestamp, String threadName, String depth, int indexAtDepth) throws IOException {
        BasePlatformLogWriter.write(log, BasePlatformLogWriter.getDate(timestamp));
        BasePlatformLogWriter.write(log, LEFT_BRACKET);
        BasePlatformLogWriter.write(log, threadName);
        BasePlatformLogWriter.write(log, '|');
        if (depth != null) {
            BasePlatformLogWriter.write(log, depth);
            BasePlatformLogWriter.write(log, '.');
        }
        BasePlatformLogWriter.write(log, indexAtDepth);
        BasePlatformLogWriter.write(log, RIGHT_BRACKET);
        switch (status.getSeverity()) {
            case 0: {
                BasePlatformLogWriter.write(log, "OK");
                break;
            }
            case 1: {
                BasePlatformLogWriter.write(log, "INFO");
                break;
            }
            case 4: {
                BasePlatformLogWriter.write(log, "ERROR");
                break;
            }
            case 2: {
                BasePlatformLogWriter.write(log, "WARNING");
                break;
            }
            default: {
                BasePlatformLogWriter.write(log, status.getSeverity());
            }
        }
        BasePlatformLogWriter.write(log, LEFT);
        String pluginName = status.getPlugin();
        if (pluginName != null) {
            BasePlatformLogWriter.write(log, pluginName);
        }
        BasePlatformLogWriter.write(log, '|');
        BasePlatformLogWriter.write(log, status.getCode());
        BasePlatformLogWriter.write(log, RIGHT);
        BasePlatformLogWriter.writeln(log, status.getMessage());
        if (status.getSeverity() == 4) {
            BasePlatformLogWriter.write(log, status.getException(), timestamp, threadName, (depth != null ? depth + '.' : "") + indexAtDepth, indexAtDepth);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                BasePlatformLogWriter.write(log, children[i2], timestamp, threadName, depth, i2 + 1);
            }
        }
    }

    protected static void write(Writer log, Throwable throwable, long timestamp, String threadName, String depth, int indexAtDepth) throws IOException {
        if (throwable == null) {
            return;
        }
        throwable.printStackTrace(new PrintWriter(log));
        if (throwable instanceof CoreException) {
            CoreException e2 = (CoreException)throwable;
            BasePlatformLogWriter.write(log, e2.getStatus(), timestamp, threadName, depth, indexAtDepth + 1);
        }
    }

    protected static void writeln(Writer log) throws IOException {
        log.write(LINE_SEPARATOR);
    }

    protected static void writeln(Writer log, String s2) throws IOException {
        BasePlatformLogWriter.write(log, s2);
        BasePlatformLogWriter.writeln(log);
    }

    protected static void write(Writer log, char c2) throws IOException {
        log.write(c2);
    }

    protected static void write(Writer log, int i2) throws IOException {
        log.write(Integer.toString(i2));
    }

    protected static void write(Writer log, String message) throws IOException {
        if (message != null) {
            log.write(message);
        }
    }

    protected static void writeSpace(Writer log) throws IOException {
        log.write(32);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    static {
        String s2 = System.getProperty("line.separator");
        LINE_SEPARATOR = s2 == null ? "\n" : s2;
    }
}

