/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.index.IQueryResult;
import com.metamatrix.internal.core.index.InMemoryIndex;
import com.metamatrix.internal.core.index.IndexInput;
import com.metamatrix.internal.core.index.IndexedFile;
import com.metamatrix.internal.core.index.WordEntry;
import java.io.IOException;
import java.util.ArrayList;

public class SimpleIndexInput
extends IndexInput {
    protected WordEntry[] sortedWordEntries;
    protected IndexedFile currentFile;
    protected IndexedFile[] sortedFiles;
    protected InMemoryIndex index;

    public SimpleIndexInput(InMemoryIndex index) {
        this.index = index;
    }

    public void clearCache() {
    }

    public void close() throws IOException {
        this.sortedFiles = null;
    }

    public IndexedFile getCurrentFile() throws IOException {
        if (!this.hasMoreFiles()) {
            return null;
        }
        return this.currentFile;
    }

    public IndexedFile getIndexedFile(int fileNum) throws IOException {
        for (int i2 = 0; i2 < this.sortedFiles.length; ++i2) {
            if (this.sortedFiles[i2].getFileNumber() != fileNum) continue;
            return this.sortedFiles[i2];
        }
        return null;
    }

    public IndexedFile getIndexedFile(IDocument document) throws IOException {
        String name = document.getName();
        for (int i2 = this.index.getNumFiles(); i2 >= 1; --i2) {
            IndexedFile file = this.getIndexedFile(i2);
            if (!name.equals(file.getPath())) continue;
            return file;
        }
        return null;
    }

    public int getNumFiles() {
        return this.index.getNumFiles();
    }

    public int getNumWords() {
        return this.sortedWordEntries.length;
    }

    public Object getSource() {
        return this.index;
    }

    public void init() {
        this.index.init();
    }

    public void moveToNextFile() throws IOException {
        ++this.filePosition;
        if (!this.hasMoreFiles()) {
            return;
        }
        this.currentFile = this.sortedFiles[this.filePosition - 1];
    }

    public void moveToNextWordEntry() throws IOException {
        ++this.wordPosition;
        if (this.hasMoreWords()) {
            this.currentWordEntry = this.sortedWordEntries[this.wordPosition - 1];
        }
    }

    public void open() throws IOException {
        this.sortedWordEntries = this.index.getSortedWordEntries();
        this.sortedFiles = this.index.getSortedFiles();
        this.filePosition = 1;
        this.wordPosition = 1;
        this.setFirstFile();
        this.setFirstWord();
    }

    public IQueryResult[] query(String word) throws IOException {
        char[] wordChar = word.toCharArray();
        WordEntry wordEntry = this.index.getWordEntry(wordChar);
        int[] fileNums = wordEntry.getRefs();
        IQueryResult[] files = new IQueryResult[fileNums.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            files[i2] = this.getIndexedFile(fileNums[i2]);
        }
        return files;
    }

    public IEntryResult[] queryEntriesPrefixedBy(char[] prefix) throws IOException {
        return null;
    }

    public IQueryResult[] queryFilesReferringToPrefix(char[] prefix) throws IOException {
        return null;
    }

    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        this.setFirstFile();
        ArrayList<String> matches = new ArrayList<String>();
        while (this.hasMoreFiles()) {
            IndexedFile file = this.getCurrentFile();
            if (file.getPath().indexOf(word) != -1) {
                matches.add(file.getPath());
            }
            this.moveToNextFile();
        }
        IQueryResult[] match = new IQueryResult[matches.size()];
        matches.toArray(match);
        return match;
    }

    protected void setFirstFile() throws IOException {
        this.filePosition = 1;
        if (this.sortedFiles.length > 0) {
            this.currentFile = this.sortedFiles[0];
        }
    }

    protected void setFirstWord() throws IOException {
        this.wordPosition = 1;
        if (this.sortedWordEntries.length > 0) {
            this.currentWordEntry = this.sortedWordEntries[0];
        }
    }
}

