/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.util.CharOperation;
import com.metamatrix.internal.core.index.IndexBlock;
import com.metamatrix.internal.core.index.WordEntry;
import java.io.UTFDataFormatException;

public class SimpleIndexBlock
extends IndexBlock {
    protected int offset = 0;

    public SimpleIndexBlock(int blockSize) {
        super(blockSize);
    }

    public boolean addEntry(WordEntry entry) {
        int n2;
        int offset = this.offset;
        char[] word = entry.getWord();
        int sizeEstimate = 2 + word.length * 3 + 4 + (n2 = entry.getNumRefs()) * 4;
        if (offset + sizeEstimate > this.blockSize - 2) {
            return false;
        }
        offset += this.field.putUTF(offset, word);
        this.field.putInt4(offset, n2);
        offset += 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.field.putInt4(offset, entry.getRef(i2));
            offset += 4;
        }
        this.offset = offset;
        return true;
    }

    public WordEntry findEntry(char[] word) {
        try {
            int byteLen;
            int offset = 0;
            while ((byteLen = this.field.getUInt2(offset)) != 0) {
                char[] tempWord = this.field.getUTF(offset);
                offset += byteLen + 2;
                if (CharOperation.equals(tempWord, word)) {
                    WordEntry entry = new WordEntry(word);
                    int n2 = this.field.getInt4(offset);
                    offset += 4;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int ref = this.field.getInt4(offset);
                        offset += 4;
                        entry.addRef(ref);
                    }
                    return entry;
                }
                int n3 = this.field.getInt4(offset);
                offset += 4 + 4 * n3;
            }
            return null;
        }
        catch (UTFDataFormatException e2) {
            return null;
        }
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
        }
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public boolean nextEntry(WordEntry entry) {
        try {
            int offset = this.offset;
            int byteLen = this.field.getUInt2(offset);
            if (byteLen == 0) {
                return false;
            }
            char[] word = this.field.getUTF(offset);
            entry.reset(word);
            int n2 = this.field.getInt4(offset += byteLen + 2);
            offset += 4;
            for (int i2 = 0; i2 < n2; ++i2) {
                int ref = this.field.getInt4(offset);
                offset += 4;
                entry.addRef(ref);
            }
            this.offset = offset;
            return true;
        }
        catch (UTFDataFormatException e2) {
            return false;
        }
    }

    public void reset() {
        super.reset();
        this.offset = 0;
    }
}

